/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Diagram;
import biouml.model.Edge;
import biouml.workbench.diagram.DiagramDocument;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import ru.biosoft.graph.Path;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPane;

public class SnapEdgeAction
extends AbstractAction {
    public static final String KEY = "Snap edge";
    public static final String EDGE = "edge";
    public static final String VIEWPANE = "viewPane";

    public SnapEdgeAction() {
        this(true);
    }

    public SnapEdgeAction(boolean enabled) {
        super(KEY);
        this.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Edge edge = (Edge)((Object)this.getValue(EDGE));
        ViewEditorPane viewPane = (ViewEditorPane)this.getValue(VIEWPANE);
        Diagram diagram = Diagram.getDiagram(edge);
        int snapSize = diagram.getViewOptions().getGridOptions().getCellSize();
        Path oldPath = edge.getPath();
        Path newPath = new Path();
        newPath.npoints = oldPath.npoints;
        newPath.xpoints = (int[])oldPath.xpoints.clone();
        newPath.ypoints = (int[])oldPath.ypoints.clone();
        newPath.pointTypes = (int[])oldPath.pointTypes.clone();
        for (int i = 1; i < newPath.npoints - 1; ++i) {
            newPath.xpoints[i] = this.snap(newPath.xpoints[i], snapSize);
            newPath.ypoints[i] = this.snap(newPath.ypoints[i], snapSize);
        }
        Point in = new Point();
        Point out = new Point();
        viewPane.startTransaction(KEY);
        edge.setPath(newPath);
        diagram.getType().getDiagramViewBuilder().calculateInOut(edge, in, out);
        newPath.xpoints[0] = in.x;
        newPath.ypoints[0] = in.y;
        newPath.xpoints[newPath.npoints - 1] = out.x;
        newPath.ypoints[newPath.npoints - 1] = out.y;
        edge.setPath(newPath);
        DiagramDocument.updateDiagram((ViewPane)viewPane, edge);
        viewPane.completeTransaction();
    }

    private int snap(int prev, int snapSize) {
        return (prev + snapSize / 2 * (prev > 0 ? 1 : -1)) / snapSize * snapSize;
    }
}

