/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Diagram;
import biouml.model.dynamics.Variable;
import biouml.standard.state.DiagramStateUtility;
import biouml.standard.state.State;
import biouml.standard.state.StatePropertyChangeUndo;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.undo.Transaction;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.undo.UndoableEdit;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.repository.DataElementPathDialog;
import ru.biosoft.table.RowDataElement;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.table.datatype.DataType;

public abstract class SetInitialValuesAction
extends AbstractAction {
    public static final String KEY = "set initial values";
    public static final String VALUE_COLUMN = "Value";
    protected Logger log = Logger.getLogger(SetInitialValuesAction.class.getName());

    protected abstract void setValue(DataElement var1, double var2);

    @Nonnull
    protected abstract Iterator<DataElement> getElementsIterator();

    public SetInitialValuesAction() {
        super(KEY);
    }

    public SetInitialValuesAction(Logger log) {
        super(KEY);
        this.log = log;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            DataElementPathDialog dialog = new DataElementPathDialog("Select a table with initial values or a diagram state");
            dialog.setElementMustExist(true);
            dialog.setMultiSelect(false);
            dialog.setElementClass(new Class[]{TableDataCollection.class, State.class});
            dialog.setValue((DataElementPath)null);
            if (dialog.doModal()) {
                if (dialog.getValue().getDataElement() instanceof TableDataCollection) {
                    this.setValues((TableDataCollection)dialog.getValue().getDataElement());
                } else if (dialog.getValue().getDataElement() instanceof State) {
                    this.setValues((State)dialog.getValue().getDataElement());
                }
            }
        }
        catch (Exception exc) {
            this.log.log(Level.SEVERE, "SetInitialValuesAction: can not set initial values.", exc);
        }
    }

    public void setValues(TableDataCollection tdc) throws Exception {
        if (tdc.getColumnModel().hasColumn(VALUE_COLUMN)) {
            if (tdc.getColumnModel().getColumn(VALUE_COLUMN).getType().equals(DataType.Float)) {
                Iterator<DataElement> it = this.getElementsIterator();
                while (it.hasNext()) {
                    DataElement de = it.next();
                    if (tdc.contains(de.getName())) {
                        this.setValue(de, (Double)((RowDataElement)tdc.get(de.getName())).getValue(VALUE_COLUMN));
                        continue;
                    }
                    this.log.log(Level.INFO, "The table '" + tdc.getName() + "' does not contain a row with id '" + de.getName() + "'. Thus, the value for '" + de.getName() + "' remains the same.");
                }
            } else {
                this.log.log(Level.WARNING, "The column 'Value' in the table '" + tdc.getName() + "' must be of the type 'Float'.");
            }
        } else {
            this.log.log(Level.WARNING, "The table '" + tdc.getName() + "' must contain the column '" + VALUE_COLUMN + "' including new initial values to be set.");
        }
    }

    private void setValues(State st) {
        Iterator<DataElement> it = this.getElementsIterator();
        while (it.hasNext()) {
            DataElement de = it.next();
            Double newValue = this.findValue(st, de.getName());
            if (newValue != null) {
                this.setValue(de, newValue);
                continue;
            }
            this.log.log(Level.INFO, "The state '" + st.getName() + "' does not change a value for '" + de.getName() + "'. Thus, the value for '" + de.getName() + "' remains the same.");
        }
    }

    private Double findValue(State st, String paramName) {
        return this.findValue(st.getStateUndoManager().getEdits(), DiagramStateUtility.getNativeDiagram(st), paramName);
    }

    private Double findValue(List<UndoableEdit> edits, Diagram diagram, String paramName) {
        for (UndoableEdit edit : edits) {
            Variable var;
            Property property;
            if (edit instanceof Transaction) {
                Double value = this.findValue(((Transaction)edit).getEdits(), diagram, paramName);
                if (value == null) continue;
                return value;
            }
            if (!(edit instanceof StatePropertyChangeUndo) || !((property = ComponentFactory.getModel((Object)((Object)diagram)).findProperty(((StatePropertyChangeUndo)edit).getPropertyName())).getOwner() instanceof Variable) || !(var = (Variable)((Object)property.getOwner())).getName().equals(paramName)) continue;
            return (Double)((StatePropertyChangeUndo)edit).getNewValue();
        }
        return null;
    }
}

