/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import one.util.streamex.EntryStream;

public class SaveCompositeDiagramDialog
extends OkCancelDialog {
    protected List<JCheckBox> checkBoxes;
    protected List<JLabel> labels;
    protected JButton selectAllButton;

    public SaveCompositeDiagramDialog(List<String> changedSubdiagramNames) {
        super((JFrame)Application.getApplicationFrame(), "Save dialog");
        this.init(changedSubdiagramNames);
    }

    protected void init(List<String> changedSubdiagramNames) {
        this.setResizable(false);
        this.checkBoxes = new ArrayList<JCheckBox>();
        this.labels = new ArrayList<JLabel>();
        this.selectAllButton = new JButton("Select all");
        this.selectAllButton.setDefaultCapable(true);
        this.selectAllButton.addActionListener(e -> {
            for (JCheckBox checkBox : this.checkBoxes) {
                checkBox.setSelected(true);
            }
        });
        this.buttonPanel.add((Component)this.selectAllButton, 0);
        this.paint(changedSubdiagramNames);
    }

    protected void paint(List<String> changedSubdiagramNames) {
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        String message = "<html>The following diagrams have been changed.<br> What changes do you want to save?</html>";
        contentPane.add((Component)new JLabel(message), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        for (int i = 0; i < changedSubdiagramNames.size(); ++i) {
            JCheckBox checkBox = new JCheckBox();
            JLabel label = new JLabel(changedSubdiagramNames.get(i));
            contentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
            contentPane.add((Component)checkBox, new GridBagConstraints(0, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            contentPane.add((Component)label, new GridBagConstraints(1, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            checkBox.setSelected(true);
            this.checkBoxes.add(checkBox);
            this.labels.add(label);
        }
        this.setContent(contentPane);
    }

    public List<String> getSubdiagramNamesToBeSaved() {
        return EntryStream.zip(this.checkBoxes, this.labels).filterKeys(AbstractButton::isSelected).values().map(JLabel::getText).toList();
    }
}

