/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Diagram;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.repository.DataElementPathDialog;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.GUI;
import ru.biosoft.table.TableDataCollection;

public class SaveAsDocumentAction
extends AbstractAction {
    protected static final Logger log = Logger.getLogger("biouml.workbench.SaveAsDocumentAction");
    public static final String KEY = "Save document as";

    public SaveAsDocumentAction(boolean enabled) {
        super(KEY);
        this.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Document activeDocument = Document.getActiveDocument();
            if (activeDocument == null) {
                return;
            }
            DataElement element = (DataElement)activeDocument.getModel();
            Method cloneMethod = null;
            try {
                cloneMethod = element.getClass().getMethod("clone", DataCollection.class, String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (cloneMethod == null) {
                log.info("Document " + activeDocument.getDisplayName() + " does not support copying.");
                return;
            }
            DataElementPathDialog dialog = new DataElementPathDialog();
            if (element instanceof TableDataCollection) {
                dialog.setElementClass(new Class[]{TableDataCollection.class});
            } else if (element instanceof Diagram) {
                dialog.setElementClass(new Class[]{Diagram.class});
            } else {
                dialog.setElementClass(new Class[]{element.getClass()});
            }
            DataElementPath dePath = null;
            try {
                dePath = DataElementPath.create((DataElement)element);
            }
            catch (Exception exception) {
                // empty catch block
            }
            dialog.setValue(dePath);
            dialog.setPromptOverwrite(true);
            if (dialog.doModal()) {
                DataCollection origin = dialog.getValue().getParentPath().getDataCollection();
                Object clonedElement = cloneMethod.invoke((Object)element, origin, dialog.getValue().getName());
                origin.put((DataElement)clonedElement);
                if (clonedElement instanceof DataCollection) {
                    ((DataCollection)clonedElement).close();
                }
                origin.release(((DataElement)clonedElement).getName());
                GUI.getManager().getRepositoryTabs().selectElement(((DataElement)clonedElement).getCompletePath());
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Saving document error", t);
        }
    }
}

