/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Diagram;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.model.SubDiagram;
import biouml.workbench.diagram.DiagramDocument;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPane;

public class RotateNodeAction
extends AbstractAction {
    public static final String KEY = "Rotate clockwise";
    public static final String NODE = "node";
    public static final String VIEWPANE = "viewPane";
    private static final Map<String, String> orientationClockwise = new HashMap<String, String>(){
        {
            this.put("right", "bottom");
            this.put("bottom", "left");
            this.put("left", "top");
            this.put("top", "right");
        }
    };

    public RotateNodeAction() {
        this(true);
    }

    public RotateNodeAction(boolean enabled) {
        super(KEY);
        this.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Node node = (Node)((Object)this.getValue(NODE));
        ViewEditorPane viewPane = (ViewEditorPane)this.getValue(VIEWPANE);
        DynamicProperty dp = node.getAttributes().getProperty("orientation");
        if (dp == null) {
            return;
        }
        Object value = dp.getValue();
        if (orientationClockwise.containsKey(value)) {
            dp.setValue((Object)orientationClockwise.get(value));
        } else if (value instanceof SubDiagram.PortOrientation) {
            dp.setValue((Object)((SubDiagram.PortOrientation)((Object)value)).clockwise());
        }
        Dimension shapeSize = node.getShapeSize();
        int w = shapeSize != null ? shapeSize.width : 0;
        int h = shapeSize != null ? shapeSize.height : 0;
        int x = node.getLocation().x + (w - h) / 2;
        int y = node.getLocation().y + (h - w) / 2;
        node.setLocation(new Point(x, y));
        node.setShapeSize(new Dimension(h, w));
        SemanticController controller = Diagram.getDiagram(node).getType().getSemanticController();
        viewPane.startTransaction("Rotate node");
        node.edges().forEach(controller::recalculateEdgePath);
        DiagramDocument.updateDiagram((ViewPane)viewPane, node);
        viewPane.completeTransaction();
    }
}

