/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Edge;
import biouml.workbench.diagram.DiagramDocument;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import ru.biosoft.graph.Path;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPane;

public class RemoveVertexAction
extends AbstractAction {
    public static final String KEY = "Remove vertex";
    public static final String EDGE = "edge";
    public static final String POINT = "point";
    public static final String VIEWPANE = "viewPane";

    public RemoveVertexAction() {
        this(true);
    }

    public RemoveVertexAction(boolean enabled) {
        super(KEY);
        this.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Edge edge = (Edge)((Object)this.getValue(EDGE));
        Integer point = (Integer)this.getValue(POINT);
        ViewEditorPane viewPane = (ViewEditorPane)this.getValue(VIEWPANE);
        Path oldPath = edge.getPath();
        if (oldPath != null && oldPath.npoints > point) {
            int i;
            Path newPath = new Path();
            for (i = 0; i < point; ++i) {
                newPath.addPoint(oldPath.xpoints[i], oldPath.ypoints[i], oldPath.pointTypes[i]);
            }
            for (i = point + 1; i < oldPath.npoints; ++i) {
                newPath.addPoint(oldPath.xpoints[i], oldPath.ypoints[i], oldPath.pointTypes[i]);
            }
            viewPane.startTransaction(KEY);
            edge.setPath(newPath);
            DiagramDocument.updateDiagram((ViewPane)viewPane, edge);
            viewPane.completeTransaction();
        }
    }
}

