/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.standard.type.Reaction;
import biouml.workbench.diagram.AddVertexAction;
import biouml.workbench.diagram.CopyNodeAction;
import biouml.workbench.diagram.CubicVertexTypeAction;
import biouml.workbench.diagram.EditElementAction;
import biouml.workbench.diagram.LineVertexTypeAction;
import biouml.workbench.diagram.MessageBundle;
import biouml.workbench.diagram.PinElementAction;
import biouml.workbench.diagram.QuadricVertexTypeAction;
import biouml.workbench.diagram.RemoveVertexAction;
import biouml.workbench.diagram.RotateNodeAction;
import biouml.workbench.diagram.SnapEdgeAction;
import biouml.workbench.diagram.StraightenEdgeAction;
import biouml.workbench.diagram.UnpinElementAction;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.action.ActionInitializer;
import com.developmentontheedge.application.action.ActionManager;
import com.developmentontheedge.beans.ActionsProvider;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import ru.biosoft.graphics.ArrowView;
import ru.biosoft.graphics.SimplePath;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPaneEvent;

public class PopupActionsProvider
implements ActionsProvider {
    private final ActionManager actionManager = Application.getActionManager();

    public PopupActionsProvider() {
        ActionInitializer initializer = new ActionInitializer(new Class[]{MessageBundle.class});
        AbstractAction action = new LineVertexTypeAction();
        this.actionManager.addAction("Line vertex type", (Action)action);
        initializer.initAction((Action)action, "Line vertex type");
        action = new QuadricVertexTypeAction();
        this.actionManager.addAction("Quadric vertex type", (Action)action);
        initializer.initAction((Action)action, "Quadric vertex type");
        action = new CubicVertexTypeAction();
        this.actionManager.addAction("Cubic vertex type", (Action)action);
        initializer.initAction((Action)action, "Cubic vertex type");
        action = new RemoveVertexAction();
        this.actionManager.addAction("Remove vertex", (Action)action);
        initializer.initAction((Action)action, "Remove vertex");
        action = new AddVertexAction();
        this.actionManager.addAction("Add vertex", (Action)action);
        initializer.initAction((Action)action, "Add vertex");
        action = new StraightenEdgeAction();
        this.actionManager.addAction("Straighten edge", (Action)action);
        initializer.initAction((Action)action, "Straighten edge");
        action = new SnapEdgeAction();
        this.actionManager.addAction("Snap edge", (Action)action);
        initializer.initAction((Action)action, "Snap edge");
        action = new RotateNodeAction();
        this.actionManager.addAction("Rotate clockwise", (Action)action);
        initializer.initAction((Action)action, "Rotate clockwise");
        action = new EditElementAction();
        this.actionManager.addAction("Edit", (Action)action);
        initializer.initAction((Action)action, "Edit");
        action = new CopyNodeAction();
        this.actionManager.addAction("Copy", (Action)action);
        initializer.initAction((Action)action, "Copy");
        action = new PinElementAction();
        this.actionManager.addAction("Pin", (Action)action);
        initializer.initAction((Action)action, "Pin");
        action = new UnpinElementAction();
        this.actionManager.addAction("Unpin", (Action)action);
        initializer.initAction((Action)action, "Unpin");
    }

    public Action[] getActions(Object obj) {
        ViewPaneEvent e;
        if (obj instanceof ViewPaneEvent && (e = (ViewPaneEvent)obj).getViewPane() instanceof ViewEditorPane) {
            Point location = new Point(e.getPoint());
            Object model = e.getViewSource().getModel();
            if (model instanceof DiagramElement) {
                ArrayList<Action> actions = new ArrayList<Action>();
                Action action = this.actionManager.getAction("Edit");
                action.putValue("diagram element", model);
                action.putValue("viewPane", e.getViewPane());
                actions.add(action);
                action = this.actionManager.getAction("Pin");
                action.putValue("diagram element", model);
                actions.add(action);
                action = this.actionManager.getAction("Unpin");
                action.putValue("diagram element", model);
                actions.add(action);
                if (model instanceof Edge && e.getViewSource() instanceof ArrowView) {
                    ArrowView view = (ArrowView)e.getViewSource();
                    Point pathOffset = view.getPathOffset();
                    SimplePath path = view.getPath();
                    if (path != null) {
                        int point = -1;
                        for (int i = 1; i < path.npoints - 1; ++i) {
                            if (Math.abs(path.xpoints[i] - location.x + pathOffset.x) >= 5 || Math.abs(path.ypoints[i] - location.y + pathOffset.y) >= 5) continue;
                            point = i;
                            break;
                        }
                        if (point != -1) {
                            Action action1 = this.actionManager.getAction("Line vertex type");
                            action1.putValue("viewPane", e.getViewPane());
                            action1.putValue("edge", model);
                            action1.putValue("point", point);
                            action1.putValue("type", path.pointTypes[point]);
                            Action action2 = this.actionManager.getAction("Quadric vertex type");
                            action2.putValue("viewPane", e.getViewPane());
                            action2.putValue("edge", model);
                            action2.putValue("point", point);
                            action2.putValue("type", path.pointTypes[point]);
                            Action action3 = this.actionManager.getAction("Cubic vertex type");
                            action3.putValue("viewPane", e.getViewPane());
                            action3.putValue("edge", model);
                            action3.putValue("point", point);
                            action3.putValue("type", path.pointTypes[point]);
                            Action removeAction = this.actionManager.getAction("Remove vertex");
                            removeAction.putValue("viewPane", e.getViewPane());
                            removeAction.putValue("edge", model);
                            removeAction.putValue("point", point);
                            actions.add(null);
                            actions.add(action1);
                            actions.add(action2);
                            actions.add(action3);
                            actions.add(null);
                            actions.add(removeAction);
                        } else {
                            action = this.actionManager.getAction("Add vertex");
                            action.putValue("viewPane", e.getViewPane());
                            action.putValue("edge", model);
                            action.putValue("point", new Point(location.x - pathOffset.x, location.y - pathOffset.y));
                            actions.add(null);
                            actions.add(action);
                        }
                        if (path.npoints > 2) {
                            Action straightenAction = this.actionManager.getAction("Straighten edge");
                            straightenAction.putValue("viewPane", e.getViewPane());
                            straightenAction.putValue("edge", model);
                            actions.add(straightenAction);
                            Action alignAction = this.actionManager.getAction("Snap edge");
                            alignAction.putValue("viewPane", e.getViewPane());
                            alignAction.putValue("edge", model);
                            actions.add(alignAction);
                        }
                    }
                } else if (model instanceof Node) {
                    if (((Node)((Object)model)).getAttributes().getProperty("orientation") != null) {
                        action = this.actionManager.getAction("Rotate clockwise");
                        action.putValue("node", model);
                        action.putValue("viewPane", e.getViewPane());
                        actions.add(null);
                        actions.add(action);
                    }
                    if (!(((Node)((Object)model)).getKernel() instanceof Reaction)) {
                        action = this.actionManager.getAction("Copy");
                        action.putValue("node", model);
                        action.putValue("viewPane", e.getViewPane());
                        actions.add(action);
                    }
                }
                return actions.toArray(new Action[actions.size()]);
            }
        }
        return null;
    }
}

