/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Diagram;
import biouml.model.DiagramType;
import biouml.model.Module;
import biouml.workbench.BioUMLApplication;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import one.util.streamex.StreamEx;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.core.AbstractDataCollection;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElementPath;

public class NewDiagramDialog
extends OkCancelDialog {
    protected static final Logger log = Logger.getLogger(NewDiagramDialog.class.getName());
    protected JComboBox<DataElementPath> moduleType = new JComboBox();
    protected DataCollection<?> parent = null;
    protected JTextField diagramName = new JTextField();
    protected JComboBox<DiagramType> diagramType = new JComboBox();
    protected JEditorPane diagramTypeDescription = new JEditorPane();
    protected Diagram diagram = null;
    protected DataElementPath diagramCompletePath = null;

    public NewDiagramDialog(JDialog dialog, String title, List<DataElementPath> dbNames, DataCollection<?> parent) {
        super(dialog, title);
        this.init(dbNames, parent);
    }

    public NewDiagramDialog(JFrame frame, String title, List<DataElementPath> dbNames, DataCollection<?> parent) {
        super(frame, title);
        this.init(dbNames, parent);
    }

    public static List<DataElementPath> getAvailableDatabases() {
        return ((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Stream)CollectionFactoryUtils.getDatabases().stream()).select(Module.class).filter(module -> module.contains("Diagrams"))).filter(module -> module.getDiagrams().isMutable())).append(CollectionFactoryUtils.getUserProjectsPath().getDataCollection().stream(Module.class))).map(AbstractDataCollection::getCompletePath).toList();
    }

    protected void init(List<DataElementPath> dbNames, DataCollection<?> parent) {
        this.parent = parent;
        JPanel content = new JPanel(new BorderLayout(5, 5));
        content.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel gridPanel = new JPanel(new GridBagLayout());
        content.add((Component)gridPanel, "North");
        JLabel moduleLabel = new JLabel(BioUMLApplication.getMessageBundle().getResourceString("DATABASE"));
        gridPanel.add((Component)moduleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        gridPanel.add(this.moduleType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        for (DataElementPath db : dbNames) {
            this.moduleType.addItem(db);
        }
        DataElementPath modulePath = Module.optModulePath(parent);
        if (modulePath != null) {
            this.moduleType.setSelectedItem(modulePath);
            this.setTitle(this.getTitle() + " (module " + modulePath + ")");
            moduleLabel.setVisible(false);
            this.moduleType.setVisible(false);
        } else if (this.moduleType.getItemCount() > 0) {
            this.moduleType.setSelectedIndex(0);
        }
        this.moduleType.addActionListener(e -> {
            int idx = this.moduleType.getSelectedIndex();
            if (idx >= 0) {
                this.setDiagramTypes(this.moduleType.getItemAt(idx));
            } else {
                this.setDiagramTypes(null);
            }
            this.checkIfOkButtonShouldBeEnabled();
        });
        gridPanel.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("DIAGRAM_NAME")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        gridPanel.add((Component)this.diagramName, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.diagramName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                NewDiagramDialog.this.checkIfOkButtonShouldBeEnabled();
            }
        });
        gridPanel.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("DIAGRAM_TYPE")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 10, 0), 0, 0));
        gridPanel.add(this.diagramType, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.diagramType.addActionListener(evt -> this.updateDescription());
        int idx = this.moduleType.getSelectedIndex();
        if (idx >= 0) {
            this.setDiagramTypes(this.moduleType.getItemAt(idx));
        } else {
            this.setDiagramTypes(null);
        }
        this.diagramTypeDescription.setEditable(false);
        this.diagramTypeDescription.setPreferredSize(new Dimension(250, 150));
        JPanel descr = new JPanel(new BorderLayout(0, 5));
        descr.add((Component)new JLabel(BioUMLApplication.getMessageBundle().getResourceString("NEW_DIAGRAM_TYPE_DESCRIPTION")), "North");
        descr.add((Component)new JScrollPane(this.diagramTypeDescription), "Center");
        content.add((Component)descr, "Center");
        this.setContent(content);
        this.okButton.setEnabled(false);
    }

    protected void checkIfOkButtonShouldBeEnabled() {
        this.okButton.setEnabled(false);
        try {
            if (this.getModuleType().optDataElement() == null) {
                this.okButton.setEnabled(false);
            }
        }
        catch (Exception e) {
            this.okButton.setEnabled(false);
        }
        String name = this.diagramName.getText();
        this.okButton.setEnabled(name != null && name.length() > 0 && 0 <= this.moduleType.getSelectedIndex() && 0 <= this.diagramType.getSelectedIndex());
    }

    public DataElementPath getDiagramCompletePath() {
        return this.diagramCompletePath;
    }

    protected String getDiagramName() {
        return this.diagramName.getText();
    }

    protected DataElementPath getModuleType() {
        return this.moduleType.getItemAt(this.moduleType.getSelectedIndex());
    }

    protected void setDiagramTypes(DataElementPath modulePath) {
        this.diagramType.removeAllItems();
        if (modulePath == null) {
            return;
        }
        try {
            ((Module)modulePath.getDataElement(Module.class)).getType().getDiagramTypeObjects().forEach(this.diagramType::addItem);
            this.pack();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Setting diagram type error", e);
        }
    }

    protected void okPressed() {
        try {
            int selectedIndex;
            Object origin = this.parent;
            if (origin == null) {
                origin = ((Module)this.getModuleType().getDataElement()).getDiagrams();
            }
            if ((selectedIndex = this.diagramType.getSelectedIndex()) == -1) {
                log.log(Level.SEVERE, "Diagram type is not selected");
                return;
            }
            DiagramType type = this.diagramType.getItemAt(selectedIndex);
            String diagramName = this.getDiagramName();
            if (!this.checkElementNotExist((DataCollection)origin, diagramName)) {
                return;
            }
            this.diagram = type.createDiagram((DataCollection<?>)origin, diagramName, null);
            this.diagramCompletePath = this.diagram.getCompletePath();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Creating new diagram ", e);
        }
        super.okPressed();
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    protected void updateDescription() {
        int selectedIndex = this.diagramType.getSelectedIndex();
        if (selectedIndex == -1) {
            this.diagramTypeDescription.setText("No diagram type is selected");
        } else {
            this.diagramTypeDescription.setText(this.diagramType.getItemAt(selectedIndex).getDescription());
        }
    }

    private boolean checkElementNotExist(DataCollection origin, String name) {
        if (origin.contains(name)) {
            String message = MessageFormat.format(BioUMLApplication.getMessageBundle().getResourceString("NEW_DIAGRAM_ALREADY_EXIST"), name);
            int status = JOptionPane.showConfirmDialog((Component)Application.getApplicationFrame(), message, "", 0);
            return status == 0;
        }
        return true;
    }
}

