/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Module;
import biouml.workbench.BioUMLApplication;
import biouml.workbench.diagram.NewDiagramDialog;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationFrame;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.gui.DocumentManager;
import ru.biosoft.gui.GUI;

public class NewDiagramAction
extends AbstractAction {
    protected static final Logger log = Logger.getLogger(NewDiagramAction.class.getName());
    public static final String KEY = "New diagram";
    public static final String COLLECTION = "Collection";

    public NewDiagramAction() {
        super(KEY);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataCollection parent = (DataCollection)this.getValue(COLLECTION);
        NewDiagramAction.newDiagram(parent);
        this.putValue(COLLECTION, null);
    }

    public static void newDiagram(DataCollection<?> parent) {
        ApplicationFrame frame = Application.getApplicationFrame();
        try {
            String dialogTilte = BioUMLApplication.getMessageBundle().getResourceString("NEW_DIAGRAM_DIALOG_TITLE");
            List<DataElementPath> databases = null;
            if (parent == null) {
                databases = NewDiagramDialog.getAvailableDatabases();
            } else {
                databases = new ArrayList<DataElementPath>();
                databases.add(Module.getModulePath(parent));
            }
            if (databases.size() == 0) {
                JOptionPane.showMessageDialog((Component)frame, BioUMLApplication.getMessageBundle().getResourceString("NEW_DIAGRAM_NO_DATABASES"), dialogTilte, 0);
            } else {
                NewDiagramDialog dialog = new NewDiagramDialog((JFrame)frame, dialogTilte, databases, parent);
                if (dialog.doModal()) {
                    dialog.getDiagramCompletePath().save((DataElement)dialog.getDiagram());
                    DocumentManager.getDocumentManager().openDocument((DataElement)dialog.getDiagram());
                    GUI.getManager().getRepositoryTabs().selectElement(dialog.getDiagram().getCompletePath());
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error during creating new diagram", e);
        }
    }
}

