/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Diagram;
import biouml.model.ScalableElementExporter;
import biouml.model.util.ImageGenerator;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import ru.biosoft.access.ImageElement;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.util.bean.StaticDescriptor;

public class ImageExporter
extends ScalableElementExporter {
    private static final String ANTI_ALIASING_PROPERTY = "anti-aliasing";
    private static final PropertyDescriptor ANTI_ALIASING_PD = StaticDescriptor.create((String)"anti-aliasing", (String)"Smooth image");
    private static Logger log = Logger.getLogger(ImageExporter.class.getName());
    protected ImageWriter writer;
    protected String format;
    protected String suffix;

    protected void initWriter(Iterator<ImageWriter> i) {
        if (i == null) {
            return;
        }
        while (i.hasNext()) {
            if (this.writer == null) {
                this.writer = i.next();
                log.info("ImageWriter " + this.writer + " is used for format=" + this.format + ", suffix=" + this.suffix);
                continue;
            }
            log.warning("Alternative ImageWriter " + this.writer + " for format=" + this.format + ", suffix=" + this.suffix);
        }
    }

    public int accept(DataElement de) {
        if (de instanceof Diagram || de instanceof ImageElement) {
            return 20;
        }
        return 0;
    }

    public void doExport(@Nonnull DataElement de, @Nonnull File file) throws Exception {
        BufferedImage image = this.getImage(de);
        if (!this.format.equals("PNG")) {
            BufferedImage convertedImg = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            convertedImg.getGraphics().setColor(Color.WHITE);
            convertedImg.getGraphics().fillRect(0, 0, image.getWidth(), image.getHeight());
            convertedImg.getGraphics().drawImage(image, 0, 0, null);
            image = convertedImg;
        }
        file.delete();
        try (ImageOutputStream stream = ImageIO.createImageOutputStream(file);){
            this.writer.setOutput(stream);
            this.writer.write(image);
        }
        this.writer.dispose();
    }

    protected Boolean isAntialiased() {
        return this.properties.getProperty(ANTI_ALIASING_PROPERTY) == null || this.properties.getProperty(ANTI_ALIASING_PROPERTY).getValue() == null ? Boolean.valueOf(false) : this.properties.getProperty(ANTI_ALIASING_PROPERTY).getValue();
    }

    private BufferedImage getImage(DataElement de) {
        if (de instanceof Diagram) {
            return ImageGenerator.generateDiagramImage((Diagram)de, this.getScale(), this.isAntialiased());
        }
        if (de instanceof ImageElement) {
            Dimension size = ((ImageElement)de).getImageSize();
            size.width = (int)((double)size.width * this.getScale());
            size.height = (int)((double)size.height * this.getScale());
            return ((ImageElement)de).getImage(size);
        }
        return null;
    }

    public void doExport(@Nonnull DataElement de, @Nonnull File file, FunctionJobControl jobControl) throws Exception {
        if (jobControl != null) {
            jobControl.functionStarted();
        }
        this.doExport(de, file);
        if (jobControl != null && jobControl.getStatus() != 4 && jobControl.getStatus() != 5) {
            jobControl.setPreparedness(100);
            jobControl.functionFinished();
        }
    }

    public boolean init(Properties properties) {
        this.format = properties.getProperty("format");
        this.suffix = properties.getProperty("suffix");
        this.initWriter(ImageIO.getImageWritersByFormatName(this.format));
        if (this.writer == null && this.suffix != null) {
            this.initWriter(ImageIO.getImageWritersBySuffix(this.suffix));
        }
        if (this.writer == null) {
            log.log(Level.SEVERE, "Could not find ImageWriter for format=" + this.format + ", suffix=" + this.suffix);
            return false;
        }
        return true;
    }

    @Override
    public Object getProperties(DataElement de, File file) {
        if (de instanceof Diagram) {
            this.properties.add(new DynamicProperty(ANTI_ALIASING_PD, Boolean.class, (Object)true));
        }
        return super.getProperties(de, file);
    }

    public List<Class<? extends DataElement>> getSupportedTypes() {
        return Arrays.asList(ImageElement.class, Diagram.class);
    }
}

