/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Diagram;
import biouml.workbench.diagram.DiagramDocument;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.gui.Document;

public class FitToScreenAction
extends AbstractAction {
    public static final String KEY = "Fit to screen";

    public FitToScreenAction(boolean enabled) {
        super(KEY);
        this.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Document activeDocument = Document.getActiveDocument();
        if (activeDocument != null && activeDocument instanceof DiagramDocument) {
            ViewPane viewPane = ((DiagramDocument)activeDocument).getDiagramViewPane();
            Diagram diagram = ((DiagramDocument)activeDocument).getDiagram();
            Rectangle bounds = diagram.getView().getBounds();
            try {
                if (viewPane != null) {
                    double scale = Math.min((double)viewPane.getWidth() / bounds.getWidth(), (double)viewPane.getHeight() / bounds.getHeight()) * 0.95;
                    viewPane.scale(scale / viewPane.getScaleX(), scale / viewPane.getScaleY());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

