/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Diagram;
import biouml.model.DiagramType;
import biouml.model.DiagramTypeConverter;
import biouml.model.xml.XmlDiagramType;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.beans.DynamicProperty;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.util.streamex.StreamEx;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import ru.biosoft.access.ClassLoading;

public class DiagramTypeConverterRegistry {
    private static Logger log = Logger.getLogger(DiagramTypeConverterRegistry.class.getName());
    private static HashMap<String, List<Conversion>> map;
    private static HashMap<String, List<Conversion>> elementConverterMap;
    private static HashMap<String, Conversion> converterNameMap;
    public static final String CONVERSION = "conversion";
    public static final String DIAGRAM_TYPE_FROM = "from";
    public static final String DIAGRAM_TYPE_TO = "to";
    public static final String Converter_CLASS = "converter";
    public static final String ELEMENT_CONVERSION = "elementConversion";
    public static final String CONVERTER_NAME = "name";

    public static Conversion[] getPossibleConversions(String diagramType) {
        if (map == null) {
            DiagramTypeConverterRegistry.loadExtensions("biouml.workbench.diagramTypeConverter");
        }
        if (!map.containsKey(diagramType)) {
            return new Conversion[0];
        }
        List<Conversion> list = map.get(diagramType);
        Conversion[] conversions = new Conversion[list.size()];
        return list.toArray(conversions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void loadExtensions(String extensionPointId) {
        IConfigurationElement[] extensions;
        map = new HashMap();
        elementConverterMap = new HashMap();
        converterNameMap = new HashMap();
        IExtensionRegistry registry = Application.getExtensionRegistry();
        for (IConfigurationElement extension : extensions = registry.getConfigurationElementsFor(extensionPointId)) {
            String pluginId = extension.getNamespaceIdentifier();
            try {
                String to;
                String from;
                String extensionName = extension.getName();
                if (extensionName.equals(CONVERSION)) {
                    String converter;
                    from = extension.getAttribute(DIAGRAM_TYPE_FROM);
                    if (from == null) {
                        throw new Exception("diagram type absents (from)");
                    }
                    to = extension.getAttribute(DIAGRAM_TYPE_TO);
                    if (to == null) {
                        throw new Exception("diagram type absents (to)");
                    }
                    Object diagramType = null;
                    if (to.startsWith(XmlDiagramType.class.getName())) {
                        int ind = to.lastIndexOf(58);
                        if (ind == -1) throw new Exception("xml diagram type (to) should contains notation name");
                        diagramType = to.substring(ind + 1, to.length());
                    } else {
                        diagramType = ClassLoading.loadSubClass((String)to, (String)pluginId, DiagramType.class);
                    }
                    if ((converter = extension.getAttribute(Converter_CLASS)) == null) {
                        throw new Exception("converter type absents");
                    }
                    Class converterClass = ClassLoading.loadSubClass((String)converter, (String)pluginId, DiagramTypeConverter.class);
                    if (map.containsKey(from)) {
                        map.get(from).add(new Conversion(diagramType, converterClass));
                    } else {
                        ArrayList<Conversion> list = new ArrayList<Conversion>();
                        list.add(new Conversion(diagramType, converterClass));
                        map.put(from, list);
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, "Diagram type converter loaded: " + from + " -> " + to + ", converter=" + converter);
                    continue;
                }
                if (!extensionName.equals(ELEMENT_CONVERSION)) continue;
                from = extension.getAttribute(DIAGRAM_TYPE_FROM);
                if (from == null) {
                    throw new Exception("diagram type absents (from)");
                }
                to = extension.getAttribute(DIAGRAM_TYPE_TO);
                if (to == null) {
                    throw new Exception("diagram type absents (to)");
                }
                String name = extension.getAttribute(CONVERTER_NAME);
                Class toClass = ClassLoading.loadSubClass((String)to, (String)pluginId, DiagramType.class);
                String converter = extension.getAttribute(Converter_CLASS);
                if (converter == null) {
                    throw new Exception("converter type absents");
                }
                Class converterClass = ClassLoading.loadSubClass((String)converter, (String)pluginId, DiagramTypeConverter.class);
                if (name != null) {
                    converterNameMap.put(name, new Conversion(toClass, converterClass));
                }
                if (elementConverterMap.containsKey(from)) {
                    elementConverterMap.get(from).add(new Conversion(toClass, converterClass));
                } else {
                    ArrayList<Conversion> list = new ArrayList<Conversion>();
                    list.add(new Conversion(toClass, converterClass));
                    elementConverterMap.put(from, list);
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "Diagram node converter loaded: " + from + " -> " + to + ", converter=" + converter);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not load diagram type converter, extension=" + extension.getName() + ", error: " + t + ".");
            }
        }
    }

    public static Conversion[] getPossibleElementConversions(String diagramType) {
        if (elementConverterMap == null) {
            DiagramTypeConverterRegistry.loadExtensions("biouml.workbench.diagramTypeConverter");
        }
        if (!elementConverterMap.containsKey(diagramType)) {
            return new Conversion[0];
        }
        List<Conversion> list = elementConverterMap.get(diagramType);
        return list.toArray(new Conversion[list.size()]);
    }

    public static void assignConverterToDiagram(Diagram diagram, DiagramTypeConverter converter) throws Exception {
        if (converterNameMap == null) {
            DiagramTypeConverterRegistry.loadExtensions("biouml.workbench.diagramTypeConverter");
        }
        String converterName = (String)StreamEx.ofKeys(converterNameMap, val -> val.getConverter().equals(converter.getClass())).findAny().orElseThrow(() -> new Exception("Can not assign converter " + converter.getClass().getName() + "to diagram " + diagram.getName()));
        diagram.getAttributes().add(new DynamicProperty(Converter_CLASS, String.class, (Object)converterName));
    }

    public static boolean checkConverter(Diagram diagram, DiagramTypeConverter converter) {
        Object converterName;
        if (converterNameMap == null) {
            DiagramTypeConverterRegistry.loadExtensions("biouml.workbench.diagramTypeConverter");
        }
        return (converterName = diagram.getAttributes().getValue(Converter_CLASS)) != null && converterNameMap.containsKey(converterName);
    }

    public static Conversion[] getDiagramElementConverter(Diagram diagram) {
        Object converterName;
        if (converterNameMap == null) {
            DiagramTypeConverterRegistry.loadExtensions("biouml.workbench.diagramTypeConverter");
        }
        if ((converterName = diagram.getAttributes().getValue(Converter_CLASS)) != null && converterNameMap.containsKey(converterName)) {
            return new Conversion[]{converterNameMap.get(converterName)};
        }
        return DiagramTypeConverterRegistry.getPossibleElementConversions(diagram.getType().getClass().getName());
    }

    public static class Conversion {
        private final Object diagramType;
        private String diagramTypeDisplayName;
        private final Class<? extends DiagramTypeConverter> converter;

        public Conversion(Object diagramType, Class<? extends DiagramTypeConverter> converter) {
            XmlDiagramType diagramTypeObj;
            this.diagramType = diagramType;
            this.converter = converter;
            if (diagramType instanceof Class) {
                this.diagramTypeDisplayName = ((Class)diagramType).getName();
                try {
                    BeanInfo info = Introspector.getBeanInfo((Class)diagramType);
                    this.diagramTypeDisplayName = info.getBeanDescriptor().getDisplayName();
                }
                catch (Exception info) {}
            } else if (diagramType instanceof String && (diagramTypeObj = XmlDiagramType.getTypeObject((String)diagramType)) != null) {
                this.diagramTypeDisplayName = diagramTypeObj.getTitle();
            }
        }

        public Object getDiagramType() {
            return this.diagramType;
        }

        public String getDiagramTypeDisplayName() {
            return this.diagramTypeDisplayName;
        }

        public Class<? extends DiagramTypeConverter> getConverter() {
            return this.converter;
        }

        public String toString() {
            return this.getDiagramTypeDisplayName();
        }
    }
}

