/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.workbench.BioUMLApplication;
import biouml.workbench.resources.MessageBundle;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.application.action.ActionInitializer;
import com.developmentontheedge.beans.undo.TransactionEvent;
import com.developmentontheedge.beans.undo.TransactionListener;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEdit;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.undo.DataCollectionUndoListener;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.exception.LoggedException;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.editor.InsertAction;
import ru.biosoft.graphics.editor.ViewEditorHelper;
import ru.biosoft.graphics.editor.ViewEditorPane;

public class DiagramEditorHelper
implements ViewEditorHelper,
TransactionListener {
    protected static final Logger log = Logger.getLogger(DiagramEditorHelper.class.getName());
    protected Diagram diagram;
    protected SemanticController semanticController;
    protected ViewEditorPane viewEditor;
    protected DataCollectionUndoListener diagramChangeListener;

    public DiagramEditorHelper(Diagram diagram) {
        this.diagram = diagram;
        this.semanticController = diagram.getType().getSemanticController();
    }

    public void register(ViewEditorPane viewEditor) {
        this.viewEditor = viewEditor;
        viewEditor.addTransactionListener((TransactionListener)this);
    }

    public void startTransaction(TransactionEvent te) {
        this.diagramChangeListener = new DataCollectionUndoListener((TransactionListener)this.viewEditor);
        this.diagram.addDataCollectionListener((DataCollectionListener)this.diagramChangeListener);
        this.diagram.addPropertyChangeListener((PropertyChangeListener)this.diagramChangeListener);
    }

    public void completeTransaction() {
        this.diagram.removeDataCollectionListener((DataCollectionListener)this.diagramChangeListener);
        this.diagram.removePropertyChangeListener((PropertyChangeListener)this.diagramChangeListener);
        this.diagramChangeListener = null;
    }

    public Dimension moveView(View view, Dimension offset) throws LoggedException {
        Object model = view.getModel();
        if (!(model instanceof DiagramElement)) {
            return new Dimension(0, 0);
        }
        DiagramElement de = (DiagramElement)((Object)model);
        Compartment parent = de.getCompartment();
        Rectangle rect = view.getBounds();
        if (de instanceof Node) {
            Point pt = new Point(rect.x + rect.width / 2 + offset.width, rect.y + rect.height / 2 + offset.height);
            CompositeView diagramView = this.viewEditor.getView();
            View parentView = diagramView.getDeepestActive(pt, de.recursiveStream().toArray(), Compartment.class);
            DiagramElement cmpElement = (DiagramElement)((Object)parentView.getModel());
            while (!(cmpElement instanceof Compartment)) {
                cmpElement = (DiagramElement)cmpElement.getParent();
            }
            parent = (Compartment)cmpElement;
        }
        try {
            if (de instanceof Compartment) {
                DataElementPath oldPath = ((Compartment)de).getCompletePath();
                DataElementPath newPath = parent.getCompletePath();
                if (newPath.isDescendantOf(oldPath)) {
                    if (de.getOrigin() instanceof Compartment) {
                        parent = (Compartment)de.getOrigin();
                    } else {
                        return new Dimension(0, 0);
                    }
                }
            }
            Dimension dimension = this.semanticController.move(de, parent, offset, rect);
            DiagramElement newDE = parent.get(de.getName());
            if (newDE != null) {
                view.setModel((Object)newDE);
            }
            return dimension;
        }
        catch (Throwable t) {
            this.logException(t, de.getName(), parent.getName());
            throw ExceptionRegistry.translateException((Throwable)t);
        }
    }

    private void logException(Throwable t, String deName, String parentName) {
        String message = null;
        message = t instanceof LoggedException ? t.getMessage() : (DefaultSemanticController.ERROR_NODE_IS_DUPLICATED.equals(t.getMessage()) ? BioUMLApplication.getMessageBundle().getResourceString("MESSAGE_NODE_ALREADY_EXIST") : BioUMLApplication.getMessageBundle().getResourceString("CANNOT_MOVE_NODE_INTO_PARENT"));
        message = MessageFormat.format(message, deName, parentName);
        log.log(Level.SEVERE, "Moving view error: " + message, t);
        String title = BioUMLApplication.getMessageBundle().getResourceString("INFO_TITLE");
        if (Application.getApplicationFrame() != null) {
            ApplicationUtils.messageBox((String)title, (String)message);
        }
    }

    public Dimension resizeView(View view, Dimension size) throws LoggedException {
        return this.resizeView(view, size, new Dimension(0, 0));
    }

    public Dimension resizeView(View view, Dimension size, Dimension offset) throws LoggedException {
        Object model = view.getModel();
        Rectangle rect = view.getBounds();
        if (model instanceof DiagramElement) {
            size = this.semanticController.resize((DiagramElement)((Object)model), size, offset);
        }
        Dimension newSize = new Dimension(rect.width + size.width, rect.height + size.height);
        if (model instanceof Node) {
            Dimension shapeSize = ((Node)((Object)model)).getShapeSize();
            if (shapeSize.width > 0 || shapeSize.height > 0) {
                newSize = new Dimension(shapeSize.width + size.width, shapeSize.height + size.height);
            }
            ((Node)((Object)model)).setShapeSize(newSize);
            if (offset.width != 0 || offset.height != 0) {
                Point location = ((Node)((Object)model)).getLocation();
                location.translate(offset.width, offset.height);
                ((Node)((Object)model)).setLocation(location);
            }
            if (model instanceof Compartment) {
                Compartment compartment = (Compartment)((Object)model);
                this.diagram.getType().getDiagramViewBuilder().createDiagramView(this.diagram, ApplicationUtils.getGraphics());
                this.viewEditor.setView((CompositeView)this.diagram.getView());
                this.moveCollection(compartment);
            }
            for (Edge edge : ((Node)((Object)model)).getEdges()) {
                this.semanticController.recalculateEdgePath(edge);
            }
        }
        return newSize;
    }

    private void moveCollection(Compartment compartment) throws LoggedException {
        Iterator<DiagramElement> iter = compartment.iterator();
        ArrayList<DiagramElement> children = new ArrayList<DiagramElement>();
        while (iter.hasNext()) {
            children.add(iter.next());
        }
        for (DiagramElement de : children) {
            if (!compartment.contains((DataElement)de)) continue;
            this.moveView(de.getView(), new Dimension(0, 0));
        }
    }

    public boolean canAccept(CompositeView composite, View view) {
        boolean canAccept = false;
        Object modelToAccept = composite.getModel();
        Object modelToDrop = view.getModel();
        if (modelToAccept instanceof Edge) {
            return true;
        }
        if (modelToAccept instanceof Compartment && modelToDrop instanceof DiagramElement && modelToAccept != modelToDrop) {
            if (((DiagramElement)((Object)modelToDrop)).getOrigin() == modelToAccept) {
                return true;
            }
            canAccept = this.semanticController.canAccept((Compartment)((Object)modelToAccept), (DiagramElement)((Object)modelToDrop));
        }
        return canAccept;
    }

    public boolean isResizable(View view) {
        boolean isResizable = false;
        Object model = view.getModel();
        if (model instanceof DiagramElement && this.semanticController != null) {
            isResizable = this.semanticController.isResizable((DiagramElement)((Object)model));
        }
        return isResizable;
    }

    public boolean removeView(View view) {
        boolean isRemoved = false;
        Object model = view.getModel();
        if (model instanceof DiagramElement) {
            try {
                return this.semanticController.remove((DiagramElement)((Object)model));
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error during removing diagram element", t);
            }
        }
        return false;
    }

    public View add(Object obj, Point location) {
        DataCollection parent = this.getOrigin(location);
        try {
            DiagramElement de;
            if (parent == null) {
                parent = this.diagram;
            }
            if ((de = (DiagramElement)((Object)obj)).getOrigin().get(de.getName()) != null) {
                String name = DefaultSemanticController.generateUniqueNodeName((Compartment)de.getOrigin(), de.getName());
                de = de.clone((Compartment)de.getOrigin(), name);
            }
            if (parent != de.getOrigin()) {
                de.getOrigin().put((DataElement)de);
                if (de instanceof Node) {
                    this.moveNodeToLocation(de, location);
                }
            } else {
                parent.put((DataElement)de);
                if (de instanceof Node) {
                    this.moveNodeToLocation(de, location);
                }
            }
            if (de instanceof Edge) {
                this.semanticController.move(de, de.getCompartment(), new Dimension(0, 0), null);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Adding an object to location error", e);
        }
        return null;
    }

    private void moveNodeToLocation(DiagramElement de, Point location) throws Exception {
        Rectangle oldBounds = null;
        if (de.getView() != null) {
            oldBounds = de.getView().getBounds();
        }
        Point oldLocation = ((Node)de).getLocation();
        Dimension offset = null;
        offset = oldLocation != null ? new Dimension(location.x - oldLocation.x, location.y - oldLocation.y) : new Dimension(location.x, location.y);
        this.semanticController.move(de, de.getCompartment(), offset, oldBounds);
    }

    public boolean addEdit(UndoableEdit ue) {
        return true;
    }

    public DataCollection getOrigin(Point pt) {
        CompositeView diagramView = (CompositeView)this.diagram.getView();
        if (diagramView == null) {
            return null;
        }
        View parentView = diagramView.getDeepestActive(pt);
        DataCollection parent = null;
        if (parentView != null) {
            Object obj = parentView.getModel();
            if (obj instanceof DataCollection) {
                parent = (DataCollection)obj;
            } else {
                DataElement de = (DataElement)obj;
                parent = de.getOrigin();
            }
        }
        return parent;
    }

    public Object createObject(Object type, Point pt) {
        DiagramElement diagramElement;
        Compartment parent = (Compartment)this.getOrigin(pt);
        if (parent == null || type instanceof Class && (((Class)type).getName().equals("biouml.standard.type.Stub$DirectedConnection") || ((Class)type).getName().equals("biouml.standard.type.Stub$UndirectedConnection"))) {
            parent = this.diagram;
        }
        if ((diagramElement = this.semanticController.createInstance(parent, type, pt, this.viewEditor).get(0)) != null && !this.semanticController.canAccept(parent, diagramElement)) {
            JOptionPane.showMessageDialog(null, "Can not accept diagram element '" + diagramElement.getName() + "' to compartment '" + parent.getName() + "'");
            return null;
        }
        return diagramElement;
    }

    public Action[] getActions() {
        ActionInitializer initializer = new ActionInitializer(new Class[]{MessageBundle.class});
        InsertAction selectAction = new InsertAction();
        initializer.initAction((Action)selectAction, "Select");
        return (Action[])((StreamEx)StreamEx.of((Object[])new Object[][]{this.diagram.getType().getNodeTypes(), this.diagram.getType().getEdgeTypes()}).nonNull()).flatMap(Arrays::stream).mapToEntry(type -> this.diagram.getType().getDiagramViewBuilder().getIcon(type)).nonNullValues().mapKeyValue(InsertAction::new).prepend((Object)selectAction).toArray(Action[]::new);
    }

    public boolean drawOnFly() {
        return this.diagram.getViewOptions().isDrawOnFly();
    }
}

