/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.DiagramFilter;
import biouml.model.DiagramViewBuilder;
import biouml.model.Edge;
import biouml.model.ModelDefinition;
import biouml.model.Module;
import biouml.model.SemanticController;
import biouml.standard.state.State;
import biouml.standard.state.StateUndoManager;
import biouml.workbench.diagram.DiagramEditorHelper;
import biouml.workbench.diagram.FitToScreenAction;
import biouml.workbench.diagram.PopupActionsProvider;
import biouml.workbench.diagram.ViewOptionsAction;
import biouml.workbench.graph.DiagramToGraphTransformer;
import biouml.workbench.resources.MessageBundle;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.action.ActionInitializer;
import com.developmentontheedge.application.action.ActionManager;
import com.developmentontheedge.beans.ActionsProvider;
import com.developmentontheedge.beans.undo.TransactionListener;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import one.util.streamex.StreamEx;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.DataCollectionUtils;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.DataCollectionInfo;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.repository.DataElementImportTransferHandler;
import ru.biosoft.access.subaction.DynamicActionFactory;
import ru.biosoft.graph.Layouter;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.editor.ViewEditorHelper;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.DocumentManager;
import ru.biosoft.gui.DocumentViewAccessProvider;
import ru.biosoft.gui.RedoAction;
import ru.biosoft.gui.UndoAction;
import ru.biosoft.gui.ZoomInAction;
import ru.biosoft.gui.ZoomOutAction;

@ClassIcon(value="resources/diagramDocument.gif")
public class DiagramDocument
extends Document
implements PropertyChangeListener {
    protected DocumentViewAccessProvider diagramViewAccessProvider = null;
    private static boolean actionInitialized = false;
    public static final int X_VIEWPANE_OFFSET = 10;
    public static final int Y_VIEWPANE_OFFSET = 10;

    public DiagramDocument(Diagram diagram, DocumentViewAccessProvider diagramViewAccessProvider) {
        this(diagram, diagramViewAccessProvider, true);
    }

    public DiagramDocument(Diagram diagram) {
        this(diagram, DocumentManager.getDocumentViewAccessProvider(), true);
    }

    public DiagramDocument(Diagram diagram, boolean isMutable) {
        this(diagram, DocumentManager.getDocumentViewAccessProvider(), isMutable);
    }

    public DiagramDocument(Diagram diagram, DocumentViewAccessProvider diagramViewAccessProvider, boolean isMutable) {
        super((Object)diagram);
        this.diagramViewAccessProvider = diagramViewAccessProvider;
        if (diagram != null) {
            DiagramFilter[] filterList;
            String layouterName;
            DataCollectionInfo info;
            if (diagram.getOrigin() != null && diagram.getPathLayouter() == null && (info = diagram.getOrigin().getInfo()).getProperties() != null && (layouterName = info.getProperty("defaultLayouter")) != null) {
                String pluginNames = info.getProperty("plugins");
                try {
                    Class layouterClass = ClassLoading.loadSubClass((String)layouterName, (String)pluginNames, Layouter.class);
                    boolean notificationEnabled = diagram.isNotificationEnabled();
                    diagram.setNotificationEnabled(false);
                    diagram.setPathLayouter((Layouter)layouterClass.newInstance());
                    diagram.setNotificationEnabled(notificationEnabled);
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "Can not load default layouter", t);
                }
            }
            DiagramToGraphTransformer.layoutIfNeeded((Diagram)diagram);
            DiagramViewBuilder builder = diagram.getType().getDiagramViewBuilder();
            Graphics gg = Application.getApplicationFrame().getGraphics();
            gg.translate(10, 10);
            CompositeView diagramView = builder.createDiagramView(diagram, gg);
            for (DiagramFilter filter : filterList = diagram.getFilterList()) {
                if (filter == null || !filter.isEnabled()) continue;
                filter.apply(diagram);
            }
            if (!isMutable) {
                this.viewPane = new ViewPane();
            } else {
                this.viewPane = new ViewEditorPane((ViewEditorHelper)new DiagramEditorHelper(diagram));
                ((ViewEditorPane)this.viewPane).addTransactionListener((TransactionListener)this.undoManager);
                ((ViewEditorPane)this.viewPane).getPanel().setTransferHandler((TransferHandler)new DataElementImportTransferHandler((path, point) -> {
                    Diagram diagram1 = this.getDiagram();
                    DiagramEditorHelper helper = new DiagramEditorHelper(diagram1);
                    SemanticController semanticController = diagram1.getType().getSemanticController();
                    Compartment parent = (Compartment)helper.getOrigin(point);
                    if (parent == null) {
                        parent = diagram1;
                    }
                    try {
                        DiagramElementGroup diagramElements = semanticController.addInstanceFromElement(parent, path.getDataElement(), point, (ViewEditorPane)this.viewPane);
                        if (diagramElements.getElement() == null) {
                            throw new Exception("Element is not supported");
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        JOptionPane.showMessageDialog(null, "Cannot add element '" + path + "' of type " + DataCollectionUtils.getElementType((DataElementPath)path) + ": " + e.getMessage());
                        return false;
                    }
                    return true;
                }));
            }
            this.viewPane.setView(diagramView);
            this.viewPane.addViewPaneListener(diagramViewAccessProvider.getDocumentViewListener());
            this.viewPane.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    DocumentManager.setActiveDocument((Document)DiagramDocument.this, (Component)DiagramDocument.this.viewPane);
                }
            });
            this.viewPane.setGridOptions(diagram.getViewOptions().getGridOptions());
            if (diagram.getLabelLayouter() != null) {
                DiagramToGraphTransformer.layoutLabels((Diagram)diagram);
                this.update();
            }
            this.viewPane.setPopupActionsProvider((ActionsProvider)new PopupActionsProvider());
            diagram.addPropertyChangeListener(this);
        }
    }

    public Diagram getDiagram() {
        this.applyEditorChanges();
        return (Diagram)((Object)this.getModel());
    }

    public String getDisplayName() {
        Diagram diagram = this.getDiagram();
        Module module = Module.optModule((DataElement)diagram);
        if (module != null) {
            return module.getName() + " : " + diagram.getName();
        }
        return diagram.getName();
    }

    public List<DataElement> getSelectedItems() {
        Object[] objs;
        ArrayList<DataElement> results = new ArrayList<DataElement>();
        for (Object obj : objs = this.viewPane.getSelectionManager().getSelectedModels()) {
            if (!(obj instanceof DataElement)) continue;
            results.add((DataElement)obj);
        }
        return results;
    }

    public Action[] getActions(Document.ActionType actionType) {
        Object[] actions = DiagramDocument.getActionsByStaticWay(actionType);
        if (actionType == Document.ActionType.TOOLBAR_ACTION) {
            return (Action[])StreamEx.of((Object[])actions).append((Object)null).append((Collection)DynamicActionFactory.getEnabledActions((Object)((Object)this.getDiagram()))).toArray(Action[]::new);
        }
        return actions;
    }

    public static Action[] getActionsByStaticWay(Document.ActionType actionType) {
        ActionManager actionManager = Application.getActionManager();
        if (!actionInitialized) {
            actionInitialized = true;
            ActionInitializer initializer = new ActionInitializer(new Class[]{MessageBundle.class});
            AbstractAction action = new ViewOptionsAction(true);
            actionManager.addAction("View options", (Action)action);
            initializer.initAction((Action)action, "View options");
            action = new UndoAction(true);
            actionManager.addAction("Undo", (Action)action);
            initializer.initAction((Action)action, "Undo");
            action = new RedoAction(true);
            actionManager.addAction("Redo", (Action)action);
            initializer.initAction((Action)action, "Redo");
            action = new ZoomInAction(true);
            actionManager.addAction("Zoom in", (Action)action);
            initializer.initAction((Action)action, "Zoom in");
            action = new ZoomOutAction(true);
            actionManager.addAction("Zoom out", (Action)action);
            initializer.initAction((Action)action, "Zoom out");
            action = new FitToScreenAction(true);
            actionManager.addAction("Fit to screen", (Action)action);
            initializer.initAction((Action)action, "Fit to screen");
        }
        if (actionType == Document.ActionType.MENU_ACTION) {
            return new Action[0];
        }
        if (actionType == Document.ActionType.TOOLBAR_ACTION) {
            Action undoAction = actionManager.getAction("Undo");
            Action redoAction = actionManager.getAction("Redo");
            Action zoomInAction = actionManager.getAction("Zoom in");
            Action zoomOutAction = actionManager.getAction("Zoom out");
            Action fitToScreenAction = actionManager.getAction("Fit to screen");
            Action convertDiagramAction = actionManager.getAction("Convert diagram");
            Action viewOptionsAction = actionManager.getAction("View options");
            return new Action[]{undoAction, redoAction, zoomInAction, zoomOutAction, fitToScreenAction, null, convertDiagramAction, null, viewOptionsAction};
        }
        if (actionType == Document.ActionType.ENABLED_ACTIONS) {
            Action printAction = actionManager.getAction("Print diagram");
            Action printPreviewAction = actionManager.getAction("Print preview");
            return new Action[]{printAction, printPreviewAction};
        }
        return null;
    }

    public void setActive(boolean isActive) {
        super.setActive(isActive);
        if (isActive) {
            this.diagramViewAccessProvider.updateSelection(this.getViewPane());
        }
    }

    public void save() {
        Diagram diagram = this.getDiagram();
        if (!ModelDefinition.isDefindInModelDefinition(diagram)) {
            try {
                State currentState = diagram.getCurrentState();
                diagram.restore();
                CollectionFactoryUtils.save((DataElement)diagram);
                if (currentState != null) {
                    diagram.setStateEditingMode(currentState);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Saving diagram error", e);
            }
        }
        super.save();
    }

    public void close() {
        Diagram diagram = this.getDiagram();
        diagram.removePropertyChangeListener(this);
        this.viewPane.removeViewPaneListener(this.diagramViewAccessProvider.getDocumentViewListener());
        if (this.viewPane instanceof ViewEditorPane) {
            ((ViewEditorPane)this.viewPane).removeTransactionListener((TransactionListener)this.undoManager);
        }
        if (diagram.getOrigin() != null) {
            diagram.getOrigin().release(diagram.getName());
        }
        super.close();
    }

    protected synchronized void doUpdate() {
        DiagramFilter[] filterList;
        Diagram diagram = this.getDiagram();
        DiagramViewBuilder builder = diagram.getType().getDiagramViewBuilder();
        Graphics gg = Application.getApplicationFrame().getGraphics();
        gg.translate(10, 10);
        builder.createDiagramView(diagram, gg);
        for (DiagramFilter filter : filterList = diagram.getFilterList()) {
            if (filter == null || !filter.isEnabled()) continue;
            filter.apply(diagram);
        }
        CompositeView diagramView = (CompositeView)diagram.getView();
        this.viewPane.setView(diagramView);
    }

    public void updateViewPane() {
        if (this.viewPane instanceof ViewEditorPane) {
            Diagram diagram = this.getDiagram();
            ((ViewEditorPane)this.viewPane).fillToolbar((ViewEditorHelper)new DiagramEditorHelper(diagram));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Property changed: " + pce.getPropertyName() + ", propagated by " + pce.getPropagationId());
        }
        if (pce.getPropagationId() instanceof DiagramFilter) {
            Diagram diagram = this.getDiagram();
            DiagramFilter filter = diagram.getFilter();
            if (filter != null) {
                filter.restoreView(diagram);
                if (filter.isEnabled()) {
                    filter.apply(diagram);
                }
            }
            this.viewPane.repaint();
            return;
        }
        if (this.canUpdate()) {
            this.update();
        }
        if (Document.getActiveDocument() == this && this.isMutable()) {
            Application.getActionManager().enableActions(true, new String[]{"Save document"});
        }
    }

    public boolean canUpdate() {
        StateUndoManager stUndoManager;
        Diagram diagram = (Diagram)((Object)this.getModel());
        if (diagram.getCurrentState() != null && ((stUndoManager = diagram.getCurrentState().getStateUndoManager()).isRedo() || stUndoManager.isUndo())) {
            return false;
        }
        return !this.undoManager.hasTransaction() && !this.undoManager.isUndo() && !this.undoManager.isRedo();
    }

    public boolean isMutable() {
        Diagram diagram = (Diagram)((Object)this.getModel());
        if (diagram != null && diagram.getOrigin() != null) {
            return diagram.getOrigin().isMutable();
        }
        return true;
    }

    public void refreshEdges() {
        Diagram diagram = this.getDiagram();
        boolean listenerEnabled = diagram.isNotificationEnabled();
        diagram.setNotificationEnabled(false);
        this.updateEdgeConnections(diagram, diagram);
        diagram.setNotificationEnabled(listenerEnabled);
        this.update();
    }

    protected void updateEdgeConnections(Diagram diagram, Compartment compartment) {
        compartment.recursiveStream().select(Edge.class).forEach(diagram.getType().getSemanticController()::recalculateEdgePath);
    }

    static void updateDiagram(ViewPane viewPane, DiagramElement de) {
        DiagramFilter[] filterList;
        Diagram diagram = Diagram.getDiagram(de);
        DiagramViewBuilder builder = diagram.getType().getDiagramViewBuilder();
        Graphics gg = Application.getApplicationFrame().getGraphics();
        gg.translate(10, 10);
        builder.createDiagramView(diagram, gg);
        for (DiagramFilter filter : filterList = diagram.getFilterList()) {
            if (filter == null || !filter.isEnabled()) continue;
            filter.apply(diagram);
        }
        CompositeView diagramView = (CompositeView)diagram.getView();
        viewPane.setView(diagramView);
    }

    public ViewPane getDiagramViewPane() {
        return this.viewPane;
    }
}

