/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.DiagramElement;
import biouml.model.Module;
import biouml.standard.type.Base;
import ru.biosoft.access.core.DataElement;

public class DataElementInfo {
    private DataElement dataElement;

    public DataElementInfo(DataElement dataElement) {
        this.dataElement = dataElement;
    }

    public String toString() {
        return "DiagramElementInfo, module=" + this.getModuleName() + ", name=" + this.getKernelName() + ", type=" + this.getKernelType() + ", title=" + this.getKernelTitle();
    }

    public DataElement getDataElement() {
        return this.dataElement;
    }

    public String getModuleName() {
        Module module = Module.optModule(this.dataElement);
        if (module != null) {
            return module.getName();
        }
        return null;
    }

    public Base getKernel() {
        if (this.dataElement instanceof DiagramElement) {
            return ((DiagramElement)this.dataElement).getKernel();
        }
        if (this.dataElement instanceof Base) {
            return (Base)this.dataElement;
        }
        return null;
    }

    public String getKernelName() {
        return this.getKernel() == null ? this.getDataElement().getName() : this.getKernel().getName();
    }

    public String getKernelTitle() {
        return this.getKernel() == null ? null : this.getKernel().getTitle();
    }

    public String getKernelType() {
        return this.getKernel() == null ? null : this.getKernel().getType();
    }
}

