/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Node;
import biouml.model.SemanticController;
import com.developmentontheedge.application.ApplicationUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPaneAdapter;
import ru.biosoft.graphics.editor.ViewPaneEvent;
import ru.biosoft.graphics.editor.ViewPaneListener;

public class CopyNodeAction
extends AbstractAction {
    public static final String KEY = "Copy";
    public static final String NODE = "node";
    public static final String VIEWPANE = "viewPane";

    public CopyNodeAction() {
        this(true);
    }

    public CopyNodeAction(Boolean enabled) {
        super(KEY);
        this.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        final Node node = (Node)((Object)this.getValue(NODE));
        final ViewEditorPane viewPane = (ViewEditorPane)this.getValue(VIEWPANE);
        ViewPaneAdapter adapter = new ViewPaneAdapter(){

            public void mousePressed(ViewPaneEvent e) {
                Object model = e.getViewSource().getModel();
                Compartment parent = null;
                if (model instanceof Compartment) {
                    parent = (Compartment)((Object)model);
                } else if (model instanceof DiagramElement && ((DiagramElement)((Object)model)).getOrigin() instanceof Compartment) {
                    parent = (Compartment)((DiagramElement)((Object)model)).getOrigin();
                }
                if (parent == null) {
                    return;
                }
                try {
                    CopyNodeAction.this.createCopyElement(parent, node, e.getPoint(), viewPane);
                }
                catch (Exception ex) {
                    String message = "Error copying " + node.getName() + ": " + ex.getMessage();
                    ApplicationUtils.errorBox((String)"Error", (String)message);
                }
                viewPane.removeViewPaneListener((ViewPaneListener)this);
                viewPane.getSelectionManager().clearSelection();
            }
        };
        viewPane.addViewPaneListener((ViewPaneListener)adapter);
    }

    private DiagramElement createCopyElement(Compartment compartment, Node node, Point point, ViewEditorPane viewEditor) throws Exception {
        String newName;
        SemanticController controller = Diagram.getDiagram(compartment).getType().getSemanticController();
        Node result = controller.copyNode(node, newName = this.generateName(node.getName(), compartment), compartment, point);
        if (result != null && controller.canAccept(compartment, result)) {
            viewEditor.add((Object)result, point);
        }
        return null;
    }

    private String generateName(String oldName, Compartment compartment) {
        String baseName = oldName;
        int index = 1;
        if (oldName.matches(".*_\\d\\d*")) {
            int i = oldName.lastIndexOf("_");
            index = Integer.parseInt(oldName.substring(i + 1));
            baseName = oldName.substring(0, i);
        }
        String newName = baseName + "_" + index;
        while (compartment.contains(newName)) {
            newName = baseName + "_" + ++index;
        }
        return newName;
    }
}

