/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Diagram;
import biouml.model.DiagramContainer;
import biouml.model.DiagramFilter;
import biouml.model.DiagramViewBuilder;
import biouml.model.SubDiagram;
import biouml.standard.state.StateUndoManager;
import biouml.workbench.diagram.DiagramDocument;
import biouml.workbench.diagram.SaveCompositeDiagramDialog;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.undo.TransactionListener;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import one.util.streamex.StreamEx;
import ru.biosoft.access.DataCollectionListenerSupport;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataCollectionVetoException;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.editor.DefaultViewEditorHelper;
import ru.biosoft.graphics.editor.ViewEditorHelper;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.graphics.editor.ViewPaneAdapter;
import ru.biosoft.graphics.editor.ViewPaneEvent;
import ru.biosoft.graphics.editor.ViewPaneListener;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.DocumentTransactionUndoManager;

public class CompositeDiagramDocument
extends DiagramDocument {
    protected JSplitPane splitPane = new JSplitPane(0);
    protected ViewPane diagramViewPane;
    protected ViewPane subdiagramViewPane;
    protected Map<String, DiagramDocument> subdiagramDocuments = new HashMap<String, DiagramDocument>();
    protected DiagramDocument currentSubdiagramDocument = null;
    protected DataCollectionListener diagramCollectionListener;

    public CompositeDiagramDocument(Diagram diagram) {
        super(diagram);
        this.initDiagramViewPane(diagram);
        this.initSubdiagramViewPane(null);
        this.splitPane.setTopComponent((Component)this.diagramViewPane);
        this.splitPane.setDividerLocation(500);
        this.viewPane = new ViewEditorPane((ViewEditorHelper)new DefaultViewEditorHelper()){

            public void scale(double sx, double sy) {
                CompositeDiagramDocument.this.diagramViewPane.scale(sx, sy);
            }
        };
        this.viewPane.add((Component)this.splitPane);
        this.diagramCollectionListener = new DataCollectionListenerSupport(){

            public void elementWillRemove(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
                if (e.getDataElement() instanceof DiagramContainer) {
                    CompositeDiagramDocument.this.subdiagramDocuments.remove(((DiagramContainer)e.getDataElement()).getName());
                    CompositeDiagramDocument.this.initSubdiagramViewPane(null);
                }
            }
        };
        diagram.addDataCollectionListener(this.diagramCollectionListener);
    }

    public int getDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    public void setDividerLocation(int location) {
        this.splitPane.setDividerLocation(location);
    }

    protected void refreshSplitPane() {
        int location = this.splitPane.getDividerLocation();
        this.splitPane.setBottomComponent((Component)this.subdiagramViewPane);
        this.splitPane.setDividerLocation(location);
    }

    private void initDiagramViewPane(Diagram diagram) {
        this.diagramViewPane = this.viewPane;
        this.diagramViewPane.addViewPaneListener((ViewPaneListener)new ViewPaneAdapter(){

            public void mousePressed(ViewPaneEvent e) {
                if (e.getViewSource() instanceof CompositeView) {
                    Object model = ((CompositeView)e.getViewSource()).getModel();
                    if (model instanceof DiagramContainer) {
                        CompositeDiagramDocument.this.initSubdiagramViewPane((DiagramContainer)((Object)model));
                    } else {
                        CompositeDiagramDocument.this.initSubdiagramViewPane(null);
                    }
                }
            }
        });
    }

    private void initSubdiagramViewPane(DiagramContainer subdiagram) {
        if (subdiagram != null) {
            if (this.subdiagramDocuments.get(subdiagram.getName()) != null) {
                this.currentSubdiagramDocument = this.subdiagramDocuments.get(subdiagram.getName());
                if (!subdiagram.isDiagramMutable()) {
                    this.currentSubdiagramDocument.setModel((Object)subdiagram.getDiagram());
                    this.currentSubdiagramDocument.doUpdate();
                    this.update();
                }
            } else {
                this.currentSubdiagramDocument = new DiagramDocument(subdiagram.getDiagram(), subdiagram.isDiagramMutable()){

                    public void update() {
                        super.doUpdate();
                        CompositeDiagramDocument.this.update();
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent pce) {
                        SubDiagram source;
                        DiagramDocument diagramDocument;
                        if (pce.getPropertyName().equals("subDiagramIsMutable") && pce.getSource() instanceof SubDiagram && (diagramDocument = CompositeDiagramDocument.this.subdiagramDocuments.get((source = (SubDiagram)((Object)pce.getSource())).getName())) != null) {
                            source.getDiagram().removePropertyChangeListener(diagramDocument);
                            CompositeDiagramDocument.this.subdiagramDocuments.remove(source.getName());
                            CompositeDiagramDocument.this.initSubdiagramViewPane(source);
                        }
                        super.propertyChange(pce);
                    }
                };
                this.subdiagramDocuments.put(subdiagram.getName(), this.currentSubdiagramDocument);
            }
            this.subdiagramViewPane = this.currentSubdiagramDocument.getViewPane();
            this.refreshSplitPane();
        } else {
            this.subdiagramViewPane = new ViewPane();
            this.subdiagramViewPane.removeAll();
            this.subdiagramViewPane.setLayout((LayoutManager)new GridBagLayout());
            JLabel text = new JLabel("Select child diagram");
            this.subdiagramViewPane.add((Component)text, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.currentSubdiagramDocument = null;
            this.refreshSplitPane();
        }
    }

    public boolean isChanged() {
        for (DiagramDocument childDocumet : this.subdiagramDocuments.values()) {
            if (!childDocumet.isChanged()) continue;
            return true;
        }
        return !this.justSaved && this.undoManager.canUndo();
    }

    @Override
    protected void doUpdate() {
        DiagramFilter[] filterList;
        Diagram diagram = this.getDiagram();
        DiagramViewBuilder builder = diagram.getType().getDiagramViewBuilder();
        Graphics gg = Application.getApplicationFrame().getGraphics();
        gg.translate(10, 10);
        builder.createDiagramView(diagram, gg);
        for (DiagramFilter filter : filterList = diagram.getFilterList()) {
            if (filter == null || !filter.isEnabled()) continue;
            filter.apply(diagram);
        }
        CompositeView diagramView = (CompositeView)diagram.getView();
        this.diagramViewPane.setView(diagramView);
    }

    @Override
    public boolean canUpdate() {
        if (this.undoManager.hasTransaction() || this.undoManager.isUndo() || this.undoManager.isRedo()) {
            return false;
        }
        for (DiagramDocument childDocumet : this.subdiagramDocuments.values()) {
            StateUndoManager stUndoManager;
            DocumentTransactionUndoManager childUndoManager = childDocumet.getUndoManager();
            if (childUndoManager.hasTransaction() || childUndoManager.isUndo() || childUndoManager.isRedo()) {
                return false;
            }
            Diagram diagram = childDocumet.getDiagram();
            if (diagram.getCurrentState() == null || !(stUndoManager = diagram.getCurrentState().getStateUndoManager()).isRedo() && !stUndoManager.isUndo()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void save() {
        List changedSubdiagramNames = StreamEx.ofKeys(this.subdiagramDocuments, Document::isChanged).toList();
        if (changedSubdiagramNames.isEmpty()) {
            super.save();
            return;
        }
        List<String> savedSubdiagramNames = null;
        SaveCompositeDiagramDialog dialog = new SaveCompositeDiagramDialog(changedSubdiagramNames);
        if (dialog.doModal()) {
            savedSubdiagramNames = dialog.getSubdiagramNamesToBeSaved();
            for (String name : savedSubdiagramNames) {
                if (name.equals(this.getDiagram().getName())) {
                    super.save();
                    continue;
                }
                DiagramDocument childDocument = this.subdiagramDocuments.get(name);
                if (childDocument.getDiagram().getOrigin() instanceof DiagramContainer) continue;
                childDocument.save();
            }
        }
        if (savedSubdiagramNames == null || savedSubdiagramNames.size() != changedSubdiagramNames.size()) {
            Application.getActionManager().enableActions(true, new String[]{"Save document"});
        }
    }

    @Override
    public ViewPane getDiagramViewPane() {
        return this.diagramViewPane;
    }

    public DiagramDocument getCurrentSubiagramDocument() {
        return this.currentSubdiagramDocument;
    }

    public Map<String, DiagramDocument> getSubiagramDocuments() {
        return this.subdiagramDocuments;
    }

    @Override
    public void close() {
        Diagram diagram = this.getDiagram();
        diagram.removeDataCollectionListener(this.diagramCollectionListener);
        this.diagramViewPane.removeViewPaneListener(this.diagramViewAccessProvider.getDocumentViewListener());
        if (this.diagramViewPane instanceof ViewEditorPane) {
            ((ViewEditorPane)this.diagramViewPane).removeTransactionListener((TransactionListener)this.undoManager);
        }
        for (DiagramDocument childDocument : this.subdiagramDocuments.values()) {
            Diagram subdiagram = childDocument.getDiagram();
            DynamicProperty baseOriginIDProperty = subdiagram.getAttributes().getProperty("baseOriginID");
            if (baseOriginIDProperty != null) {
                String baseOriginID = (String)baseOriginIDProperty.getValue();
                DataCollection newParent = CollectionFactory.getDataCollection((String)baseOriginID);
                subdiagram.setOrigin(newParent);
            }
            childDocument.close();
        }
        super.close();
    }

    @Override
    public List<DataElement> getSelectedItems() {
        Object[] objs;
        ArrayList<DataElement> results = new ArrayList<DataElement>();
        for (Object obj : objs = this.diagramViewPane.getSelectionManager().getSelectedModels()) {
            if (!(obj instanceof DataElement)) continue;
            results.add((DataElement)obj);
        }
        return results;
    }
}

