/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Node;
import biouml.model.util.AddElementsUtils;
import biouml.standard.type.Base;
import biouml.workbench.diagram.DataElementInfo;
import biouml.workbench.resources.MessageBundle;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.application.action.ActionInitializer;
import com.developmentontheedge.beans.swing.TabularPropertyInspector;
import com.developmentontheedge.beans.swing.table.ColumnModel;
import com.developmentontheedge.beans.swing.table.DefaultRowModel;
import com.developmentontheedge.beans.swing.table.RowModel;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import ru.biosoft.access.biohub.Element;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.repository.DataElementDroppable;
import ru.biosoft.access.repository.DataElementImportTransferHandler;
import ru.biosoft.access.repository.DataElementPathTransferable;
import ru.biosoft.graphics.editor.SelectionManager;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.graphics.editor.ViewPaneEvent;
import ru.biosoft.graphics.editor.ViewPaneListener;
import ru.biosoft.gui.GUI;

public class ClipboardPane
extends TabularPropertyInspector
implements ViewPaneListener,
ListSelectionListener {
    protected static final Logger log = Logger.getLogger(ClipboardPane.class.getName());
    protected DefaultRowModel clipboardModel = new DefaultRowModel();
    public static final String COPY = "clipboard-copy";
    public static final String PASTE = "clipboard-paste";
    public static final String DELETE = "clipboard-delete";
    protected Action copyAction = new CopyAction("clipboard-copy");
    protected Action pasteAction = new PasteAction("clipboard-paste");
    protected Action deleteAction = new DeleteAction("clipboard-delete");
    protected List<DataElementInfo> items4add = new ArrayList<DataElementInfo>();
    protected Diagram diagram;
    protected ViewPane viewPane;
    protected Action[] actions;
    private static ClipboardPane clipboardObject = null;

    public static ClipboardPane getClipboard() {
        if (clipboardObject == null) {
            clipboardObject = new ClipboardPane();
        }
        return clipboardObject;
    }

    protected ClipboardPane() {
        DataElementInfo templateBean = new DataElementInfo((DataElement)new Node(null, "test", null));
        this.explore((RowModel)this.clipboardModel, new ColumnModel((Object)templateBean));
        this.copyAction.setEnabled(false);
        this.pasteAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.getTable().setTransferHandler(new ClipboardTransferHandler());
        this.getTable().setDragEnabled(true);
        this.setTransferHandler((TransferHandler)new DataElementImportTransferHandler((DataElementDroppable)new ClipboardDroppable()));
        this.getTable().getSelectionModel().addListSelectionListener(this);
    }

    public void explore(Diagram diagram, ViewPane viewPane) {
        this.diagram = diagram;
        this.viewPane = viewPane;
    }

    public void addElement(DataElementInfo dei) {
        this.clipboardModel.add(0, (Object)dei);
        this.explore((RowModel)this.clipboardModel, new ColumnModel((Object)dei));
        this.repaint();
    }

    public Action[] getActions() {
        if (this.actions == null) {
            ActionInitializer initializer = new ActionInitializer(new Class[]{MessageBundle.class});
            initializer.initAction(this.copyAction);
            initializer.initAction(this.pasteAction);
            initializer.initAction(this.deleteAction);
            this.actions = new Action[]{this.copyAction, this.pasteAction, this.deleteAction};
        }
        return this.actions;
    }

    public void mouseClicked(ViewPaneEvent e) {
        if (this.diagram != null && this.viewPane != null) {
            this.diagramSelectionChanged();
        }
    }

    public void mousePressed(ViewPaneEvent event) {
        if (this.diagram != null && this.viewPane != null) {
            this.diagramSelectionChanged();
            Object model = event.getViewSource().getModel();
            Compartment parent = null;
            if (model instanceof Compartment) {
                parent = (Compartment)((Object)model);
            } else if (model instanceof DiagramElement && ((DiagramElement)((Object)model)).getOrigin() instanceof Compartment) {
                parent = (Compartment)((DiagramElement)((Object)model)).getOrigin();
            }
            if (parent == null) {
                return;
            }
            for (DataElementInfo deInfo : this.items4add) {
                DataElement de = deInfo.getDataElement();
                try {
                    AddElementsUtils.addElements(parent, new Element[]{new Element(DataElementPath.create((DataElement)de))}, event.getPoint());
                }
                catch (Exception e) {
                    String message = "Error pasting " + de.getName() + ": " + e.getMessage();
                    log.log(Level.SEVERE, message);
                    ApplicationUtils.errorBox((String)"Error", (String)message);
                }
            }
            this.items4add.clear();
        }
    }

    public void mouseReleased(ViewPaneEvent e) {
        if (this.diagram != null && this.viewPane != null) {
            this.diagramSelectionChanged();
        }
    }

    public void mouseEntered(ViewPaneEvent e) {
    }

    public void mouseExited(ViewPaneEvent e) {
    }

    public void mouseDragged(ViewPaneEvent e) {
    }

    public void mouseMoved(ViewPaneEvent e) {
    }

    protected void diagramSelectionChanged() {
        SelectionManager sm = this.viewPane.getSelectionManager();
        if (sm.getSelectedModels() != null && sm.getSelectedModels().length > 0 && sm.getSelectedModels()[0] instanceof Diagram) {
            this.copyAction.setEnabled(false);
            return;
        }
        this.copyAction.setEnabled(sm.getSelectedViewCount() > 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = this.getTable().getSelectionModel();
        this.pasteAction.setEnabled(!lsm.isSelectionEmpty());
        this.deleteAction.setEnabled(!lsm.isSelectionEmpty());
        if (!lsm.isSelectionEmpty() && lsm.getMinSelectionIndex() == lsm.getMaxSelectionIndex()) {
            DataElement de = this.getModelForRow(lsm.getMinSelectionIndex()).getDataElement();
            GUI.getManager().explore((Object)de);
        }
    }

    public DataElementInfo getModelForRow(int row) {
        return (DataElementInfo)super.getModelForRow(row);
    }

    class PasteAction
    extends AbstractAction {
        public PasteAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selectedItems;
            ListSelectionModel lsm = ClipboardPane.this.getTable().getSelectionModel();
            if (lsm == null) {
                return;
            }
            ClipboardPane.this.items4add = selectedItems = IntStreamEx.range((int)ClipboardPane.this.clipboardModel.size()).filter(lsm::isSelectedIndex).mapToObj(ClipboardPane.this::getModelForRow).toList();
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClipboardPane.this.items4add.clear();
            ListSelectionModel lsm = ClipboardPane.this.getTable().getSelectionModel();
            List selectedItems = IntStreamEx.range((int)ClipboardPane.this.clipboardModel.size()).filter(lsm::isSelectedIndex).mapToObj(ClipboardPane.this::getModelForRow).toList();
            block0: while (selectedItems.size() > 0) {
                Object obj = selectedItems.remove(0);
                for (int i = 0; i < ClipboardPane.this.clipboardModel.size(); ++i) {
                    if (ClipboardPane.this.clipboardModel.getBean(i) != obj) continue;
                    ClipboardPane.this.clipboardModel.remove(i);
                    continue block0;
                }
            }
        }
    }

    class CopyAction
    extends AbstractAction {
        public CopyAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClipboardPane.this.items4add.clear();
            try {
                SelectionManager sm = ClipboardPane.this.viewPane.getSelectionManager();
                Object[] elements = sm.getSelectedModels();
                if (elements == null) {
                    return;
                }
                for (DiagramElement de : (StreamEx)StreamEx.of((Object[])elements).select(DiagramElement.class).remove(element -> element instanceof Diagram)) {
                    Base kernel = de.getKernel();
                    if (kernel == null) continue;
                    for (int j = 0; j < ClipboardPane.this.clipboardModel.size(); ++j) {
                        DataElementInfo dei = (DataElementInfo)ClipboardPane.this.clipboardModel.getBean(j);
                        if (dei.getKernel() != kernel) continue;
                        return;
                    }
                    DataElementInfo dei = new DataElementInfo((DataElement)de);
                    ClipboardPane.this.clipboardModel.add(0, (Object)dei);
                    ClipboardPane.this.explore((RowModel)ClipboardPane.this.clipboardModel, new ColumnModel((Object)dei));
                    ClipboardPane.this.repaint();
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Error: " + ex.getMessage(), ex);
            }
        }
    }

    private class ClipboardTransferHandler
    extends TransferHandler {
        private ClipboardTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JTable table = ClipboardPane.this.getTable();
            if (table.getSelectedRowCount() == 0) {
                return null;
            }
            try {
                return new DataElementPathTransferable(DataElementPath.create((DataElement)((DataElementInfo)ClipboardPane.this.clipboardModel.getBean(table.getSelectedRow())).getDataElement()));
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private class ClipboardDroppable
    implements DataElementDroppable {
        private ClipboardDroppable() {
        }

        public boolean doImport(DataElementPath path, Point point) {
            for (int j = 0; j < ClipboardPane.this.clipboardModel.size(); ++j) {
                DataElementInfo dei = (DataElementInfo)ClipboardPane.this.clipboardModel.getBean(j);
                if (!DataElementPath.create((DataElement)dei.getKernel()).equals((Object)path) && !DataElementPath.create((DataElement)dei.getDataElement()).equals((Object)path)) continue;
                return false;
            }
            ClipboardPane.this.addElement(new DataElementInfo(path.optDataElement()));
            return true;
        }
    }
}

