/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Edge;
import biouml.workbench.diagram.DiagramDocument;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import ru.biosoft.graph.Path;
import ru.biosoft.graphics.PathUtils;
import ru.biosoft.graphics.SimplePath;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPane;

public class AddVertexAction
extends AbstractAction {
    public static final String KEY = "Add vertex";
    public static final String EDGE = "edge";
    public static final String POINT = "point";
    public static final String VIEWPANE = "viewPane";

    public AddVertexAction() {
        this(true);
    }

    public AddVertexAction(boolean enabled) {
        super(KEY);
        this.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Edge edge = (Edge)((Object)this.getValue(EDGE));
        Point point = (Point)this.getValue(POINT);
        ViewEditorPane viewPane = (ViewEditorPane)this.getValue(VIEWPANE);
        SimplePath oldPath = edge.getSimplePath();
        if (oldPath != null) {
            int i;
            int pos = PathUtils.getNearestSegment((SimplePath)oldPath, (Point)point);
            Path newPath = new Path();
            for (i = 0; i <= pos; ++i) {
                newPath.addPoint(oldPath.xpoints[i], oldPath.ypoints[i], oldPath.pointTypes[i]);
            }
            newPath.addPoint(point.x, point.y);
            for (i = pos + 1; i < oldPath.npoints; ++i) {
                newPath.addPoint(oldPath.xpoints[i], oldPath.ypoints[i], oldPath.pointTypes[i]);
            }
            viewPane.startTransaction(KEY);
            edge.setPath(newPath);
            DiagramDocument.updateDiagram((ViewPane)viewPane, edge);
            viewPane.completeTransaction();
        }
    }
}

