/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench.diagram;

import biouml.model.Diagram;
import biouml.workbench.diagram.DiagramTextRepresentation;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataCollectionListener;

public abstract class AbstractDiagramTextRepresentation
implements DiagramTextRepresentation {
    protected final Diagram diagram;
    private boolean updating = false;

    public AbstractDiagramTextRepresentation(Diagram diagram) {
        this.diagram = diagram;
    }

    @Override
    public void setContent(String text) {
        this.updating = true;
        try {
            this.doSetContent(text);
        }
        finally {
            this.updating = false;
        }
    }

    protected abstract void doSetContent(String var1);

    @Override
    public void addTextChangeListener(PropertyChangeListener l) {
        DiagramChangeListener listener = new DiagramChangeListener(l);
        this.diagram.addDataCollectionListener(listener);
        this.diagram.addPropertyChangeListener(listener);
    }

    private class DiagramChangeListener
    implements PropertyChangeListener,
    DataCollectionListener {
        private final WeakReference<PropertyChangeListener> delegateRef;
        private String text;

        public DiagramChangeListener(PropertyChangeListener delegate) {
            this.delegateRef = new WeakReference<PropertyChangeListener>(delegate);
            this.text = AbstractDiagramTextRepresentation.this.getContent();
        }

        public void elementAdded(DataCollectionEvent e) {
            this.handleTextChange();
        }

        public void elementWillAdd(DataCollectionEvent e) {
        }

        public void elementChanged(DataCollectionEvent e) {
            this.handleTextChange();
        }

        public void elementWillChange(DataCollectionEvent e) {
        }

        public void elementRemoved(DataCollectionEvent e) {
            this.handleTextChange();
        }

        public void elementWillRemove(DataCollectionEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.handleTextChange();
        }

        private void handleTextChange() {
            PropertyChangeListener delegate = (PropertyChangeListener)this.delegateRef.get();
            if (delegate == null) {
                AbstractDiagramTextRepresentation.this.diagram.removeDataCollectionListener(this);
                AbstractDiagramTextRepresentation.this.diagram.removePropertyChangeListener(this);
                return;
            }
            if (AbstractDiagramTextRepresentation.this.updating) {
                return;
            }
            String newText = AbstractDiagramTextRepresentation.this.getContent();
            if (!this.text.equals(newText)) {
                PropertyChangeEvent pce = new PropertyChangeEvent((Object)AbstractDiagramTextRepresentation.this.diagram, "text", this.text, newText);
                this.text = newText;
                delegate.propertyChange(pce);
            }
        }
    }
}

