/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench;

import biouml.model.Module;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import ru.biosoft.access.QuerySystemWithIndexRebuilder;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.QuerySystem;
import ru.biosoft.access.repository.RepositoryPane;
import ru.biosoft.gui.GUI;
import ru.biosoft.gui.ViewPart;
import ru.biosoft.gui.ViewPartRegistry;

public class SearchPane
extends JPanel {
    protected static final Logger log = Logger.getLogger(SearchPane.class.getName());
    public static final String LUCENE_PLUGIN = "biouml.plugins.lucene";
    public static final String LUCENE_FORMATTER_PREFIX = "<b>";
    public static final String LUCENE_FORMATTER_POSTFIX = "</b>";
    public static final String RESULT_VIEW_PART_NAME = "Search results";
    protected JTextField searchString;
    protected JButton searchButton;
    protected Bundle bundle;
    protected RepositoryPane repositoryPane;

    public SearchPane(RepositoryPane repositoryPane) {
        super(new BorderLayout());
        this.setPreferredSize(new Dimension(100, 25));
        this.repositoryPane = repositoryPane;
        this.bundle = Platform.getBundle((String)LUCENE_PLUGIN);
        if (this.bundle != null) {
            this.searchString = new JTextField();
            this.add((Component)this.searchString, "Center");
            URL resURL = SearchPane.class.getResource("resources/search.gif");
            this.searchButton = new JButton(new ImageIcon(resURL));
            this.add((Component)this.searchButton, "East");
            this.searchButton.addActionListener(e -> this.searchActionPerformed());
        }
    }

    protected void searchActionPerformed() {
        ViewPart resultPane;
        if (this.bundle == null) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Lucene plugin (biouml.plugins.lucene) is necessary to search", "Warning", 1);
            return;
        }
        String queryString = this.searchString.getText();
        if (queryString == null) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Search string can't be null", "Warning", 1);
            return;
        }
        DataElement element = this.repositoryPane.getSelectedNode();
        if (element == null) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "No selected database to search", "Warning", 1);
            return;
        }
        DataElementPath completePath = DataElementPath.create((DataElement)element);
        Module module = Module.optModule(element);
        if (module == null) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Select database in repository tree for search", "Warning", 1);
            return;
        }
        String relativeName = element == module ? null : CollectionFactory.getRelativeName((DataElement)element, (DataCollection)module);
        Object luceneFacade = this.getSearchFacade(module);
        if (luceneFacade == null) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Search is not available for database " + module.getName(), "Warning", 1);
            return;
        }
        if (luceneFacade instanceof QuerySystemWithIndexRebuilder) {
            try {
                if (!((QuerySystemWithIndexRebuilder)luceneFacade).testHaveIndex()) {
                    ((QuerySystemWithIndexRebuilder)luceneFacade).showRebuildIndexesUI((JFrame)Application.getApplicationFrame());
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((resultPane = ViewPartRegistry.getViewPart((String)"search.results")) != null) {
            try {
                Class luceneResultPaneClass = this.bundle.loadClass("biouml.plugins.lucene.LuceneSearchViewPart");
                if (luceneResultPaneClass.isInstance(resultPane)) {
                    Method setInfoMethod = luceneResultPaneClass.getMethod("setInfo", String.class, String.class);
                    setInfoMethod.invoke((Object)resultPane, queryString, completePath.toString());
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can't print results in Search results view part", e);
            }
            GUI.getManager().showViewPart(resultPane);
        }
        Thread thread = new Thread(new SearchProcess(luceneFacade, relativeName, queryString));
        thread.setPriority(1);
        thread.start();
    }

    protected Object getSearchFacade(Module module) {
        try {
            Class luceneQuerySystemClass = this.bundle.loadClass("biouml.plugins.lucene.LuceneQuerySystem");
            if (luceneQuerySystemClass.isInstance(module.getInfo().getQuerySystem())) {
                QuerySystem luceneFacade = module.getInfo().getQuerySystem();
                Method testMethod = luceneQuerySystemClass.getMethod("testHaveLuceneDir", new Class[0]);
                boolean testResult = (Boolean)testMethod.invoke((Object)luceneFacade, new Object[0]);
                if (testResult) {
                    return luceneFacade;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not get lucene facade");
        }
        return null;
    }

    class SearchProcess
    implements Runnable {
        protected Object luceneFacade;
        protected String relativeName;
        protected String queryString;

        public SearchProcess(Object luceneFacade, String relativeName, String queryString) {
            this.luceneFacade = luceneFacade;
            this.relativeName = relativeName;
            this.queryString = queryString;
        }

        @Override
        public void run() {
            DynamicPropertySet[] dps = null;
            try {
                Class luceneFormatterClass = SearchPane.this.bundle.loadClass("biouml.plugins.lucene.Formatter");
                Object formatter = luceneFormatterClass.getConstructor(String.class, String.class).newInstance(SearchPane.LUCENE_FORMATTER_PREFIX, SearchPane.LUCENE_FORMATTER_POSTFIX);
                Method searchMethod = this.luceneFacade.getClass().getMethod("searchRecursive", String.class, String.class, luceneFormatterClass, Integer.TYPE, Integer.TYPE);
                Integer minValue = 0;
                Integer maxValue = (Integer)this.luceneFacade.getClass().getField("MAX_DEFAULT_SEARCH_RESULTS_COUNT").get(null);
                dps = (DynamicPropertySet[])searchMethod.invoke(this.luceneFacade, this.relativeName, this.queryString, formatter, minValue, maxValue);
                Collections.reverse(Arrays.asList(dps));
            }
            catch (Exception pe) {
                log.log(Level.SEVERE, "Lucene search failed", pe);
                return;
            }
            ViewPart resultPane = ViewPartRegistry.getViewPart((String)"search.results");
            if (resultPane != null) {
                try {
                    Class luceneResultPaneClass = SearchPane.this.bundle.loadClass("biouml.plugins.lucene.LuceneSearchViewPart");
                    if (luceneResultPaneClass.isInstance(resultPane)) {
                        Method setResultsMethod = luceneResultPaneClass.getMethod("setResults", DynamicPropertySet[].class);
                        setResultsMethod.invoke((Object)resultPane, new Object[]{dps});
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Can't print results in Search results view part", e);
                }
            }
        }
    }
}

