/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench;

import biouml.model.Diagram;
import biouml.model.Module;
import biouml.standard.type.DiagramInfo;
import biouml.workbench.BioUMLApplication;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.action.ActionManager;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.undo.TransactionListener;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.logging.Level;
import javax.swing.Action;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.undo.DataCollectionUndoListener;
import ru.biosoft.access.repository.RepositoryListener;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.DocumentManager;
import ru.biosoft.gui.EditorPart;
import ru.biosoft.gui.ExplorerPane;
import ru.biosoft.gui.GUI;
import ru.biosoft.gui.ViewPart;

class RepositoryDocument
extends Document
implements RepositoryListener,
PropertyChangeListener {
    BioUMLApplication application;

    public RepositoryDocument(BioUMLApplication application, Component repositoryPane) {
        super((Object)repositoryPane);
        this.application = application;
        repositoryPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DocumentManager.setActiveRepositoryDocument((Document)RepositoryDocument.this, (Component)((Component)RepositoryDocument.this.getModel()));
            }
        });
        DocumentManager.setActiveRepositoryDocument((Document)this, (Component)((Component)this.getModel()));
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        Object source;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Property changed: " + pce.getPropertyName() + ", propagated by " + pce.getPropagationId());
        }
        if ((source = pce.getSource()) != null) {
            if (source instanceof Diagram && pce.getPropertyName().equals("currentStateName")) {
                return;
            }
            if (source instanceof DataElement) {
                this.autoSave((DataElement)source);
            } else if (source instanceof Option) {
                Option de = (Option)source;
                ((StreamEx)((StreamEx)StreamEx.iterate((Object)de, Option::getParent).takeWhile(Objects::nonNull)).filter(DataElement.class::isInstance)).map(DataElement.class::cast).findFirst().ifPresent(this::autoSave);
            }
        }
    }

    protected void autoSave(DataElement de) {
        try {
            boolean needAutoSave = true;
            DataCollection origin = de.getOrigin();
            if (origin != null && origin.contains(de)) {
                if (de instanceof DiagramInfo) {
                    de = origin.get(de.getName());
                }
                for (Document document : GUI.getManager().getDocuments()) {
                    if (!document.getModel().equals(de)) continue;
                    needAutoSave = false;
                    break;
                }
                if (needAutoSave && de.getClass().isAssignableFrom(origin.getDataElementType())) {
                    origin.put(de);
                }
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Can't save data element", t);
        }
    }

    public void nodeClicked(DataElement de, int clickCount) {
    }

    public void selectionChanged(DataElement de) {
        DocumentManager.setActiveRepositoryDocument((Document)this, (Component)((Component)this.getModel()));
        ExplorerPane explorerPane = (ExplorerPane)this.application.getPanelManager().getPanel("explorer");
        explorerPane.removeBeanPropertyChangeListener((PropertyChangeListener)this);
        explorerPane.explore((Object)de, (Document)this);
        explorerPane.getPropertiesEditor().explore((Object)de);
        explorerPane.addBeanPropertyChangeListener((PropertyChangeListener)this);
        boolean isDiagram = de instanceof Diagram;
        ActionManager actionManager = Application.getActionManager();
        Action generateHTMLAction = actionManager.getAction("Generate HTML");
        if (isDiagram && generateHTMLAction != null) {
            DataElementPath path = DataElementPath.create((DataElement)de);
            generateHTMLAction.putValue("Parameter", path);
        }
    }

    public String getDisplayName() {
        return "Repository";
    }

    public void setActive(boolean isActive) {
        if (!isActive) {
            this.removeListeners();
            ExplorerPane explorerPane = (ExplorerPane)this.application.getPanelManager().getPanel("explorer");
            explorerPane.removeBeanPropertyChangeListener((PropertyChangeListener)this);
            this.undoManager.discardAllEdits();
            return;
        }
        ExplorerPane explorerPane = (ExplorerPane)this.application.getPanelManager().getPanel("explorer");
        explorerPane.addBeanPropertyChangeListener((PropertyChangeListener)this);
        DocumentManager manager = DocumentManager.getDocumentManager();
        for (ViewPart viewPart : manager.getEditorList()) {
            if (!(viewPart instanceof EditorPart)) continue;
            ((EditorPart)viewPart).addTransactionListener((TransactionListener)this.undoManager);
        }
        this.updateActionsState();
    }

    public static class RepositoryUndoListener
    extends DataCollectionUndoListener {
        protected RepositoryDocument repositoryDocument;

        public RepositoryUndoListener(RepositoryDocument repositoryDocument) {
            super((TransactionListener)repositoryDocument.getUndoManager());
            this.repositoryDocument = repositoryDocument;
        }

        public void elementRemoved(DataCollectionEvent e) throws Exception {
            if (this.elementToRemove instanceof Module) {
                this.repositoryDocument.getUndoManager().discardAllEdits();
                this.repositoryDocument.updateActionsState();
                return;
            }
            super.elementRemoved(e);
        }
    }
}

