/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench;

import biouml.model.Diagram;
import biouml.model.Module;
import biouml.workbench.module.xml.XmlModule;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.action.ActionManager;
import com.developmentontheedge.beans.ActionsProvider;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.swing.Action;
import ru.biosoft.access.DataCollectionUtils;
import ru.biosoft.access.DataElementImporterRegistry;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.FolderCollection;
import ru.biosoft.access.file.FileBasedCollection;
import ru.biosoft.util.TextUtil;

public class RepositoryActionsProvider
implements ActionsProvider {
    @Nonnull
    private static final DataElementPath ANALYSES_PATH = DataElementPath.create((String)"analyses");

    public Action[] getActions(Object obj) {
        Action removeDataElementAction;
        if (!(obj instanceof DataElement)) {
            return null;
        }
        DataElement de = (DataElement)obj;
        ActionManager actionManager = Application.getActionManager();
        if (de.getOrigin() == null || de.getOrigin().getCompletePath().isDescendantOf(ANALYSES_PATH)) {
            return null;
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        Action importDocumentAction = actionManager.getAction("Import document");
        if (de instanceof DataCollection && DataElementImporterRegistry.isImportAvailableForCollection((DataCollection)((DataCollection)de))) {
            importDocumentAction.putValue("Database", de);
            importDocumentAction.setEnabled(true);
        } else {
            importDocumentAction.setEnabled(false);
            importDocumentAction = null;
        }
        if (TextUtil.isFullPath((String)de.getName())) {
            actions.add(actionManager.getAction("New module"));
            actions.add(actionManager.getAction("New composite database"));
        } else if (de instanceof Module) {
            Action removeModuleAction = actionManager.getAction("Remove module");
            removeModuleAction.putValue("Database", de);
            actions.add(removeModuleAction);
            Action exportModuleAction = actionManager.getAction("Export module");
            exportModuleAction.putValue("Database", de);
            actions.add(exportModuleAction);
            if (importDocumentAction != null) {
                actions.add(importDocumentAction);
                importDocumentAction = null;
            }
            if (de instanceof XmlModule) {
                Action editModuleAction = actionManager.getAction("Edit module");
                editModuleAction.putValue("Module", de);
                actions.add(editModuleAction);
            }
        } else if (de.getOrigin().getName().equalsIgnoreCase("Images")) {
            removeDataElementAction = actionManager.getAction("Remove Data Element");
            removeDataElementAction.putValue("Data element", de);
            actions.add(removeDataElementAction);
        } else if (de.getName().equalsIgnoreCase("Images")) {
            Action importImageDataAction = actionManager.getAction("Import Image Data Element");
            importImageDataAction.putValue("Images data collection", de);
            actions.add(importImageDataAction);
        } else if (!de.getName().equalsIgnoreCase("graphic notations")) {
            if (de instanceof DataCollection && !de.getName().equalsIgnoreCase("Diagrams") && (de.getOrigin().getName().equals("Data") || de.getOrigin().getName().equals("Dictionaries")) && ((DataCollection)de).isMutable()) {
                Action newDataElementAction = actionManager.getAction("New Data Element");
                newDataElementAction.putValue("Data Collection (parent)", de);
                actions.add(newDataElementAction);
            } else if (de instanceof Diagram) {
                if (importDocumentAction != null) {
                    actions.add(importDocumentAction);
                    importDocumentAction = null;
                }
                removeDataElementAction = actionManager.getAction("Remove Data Element");
                removeDataElementAction.putValue("Data element", de);
                actions.add(removeDataElementAction);
            }
        }
        if (DataCollectionUtils.isAcceptable((DataElementPath)DataElementPath.create((DataElement)de), Diagram.class, null) && Module.optModule(de) != null && de instanceof DataCollection && ((DataCollection)de).isMutable()) {
            Action newDiagramAction = actionManager.getAction("New diagram");
            newDiagramAction.putValue("Collection", de);
            actions.add(newDiagramAction);
        }
        if (de.getOrigin() instanceof FileBasedCollection || de.getOrigin() instanceof FolderCollection || de.getOrigin().getOrigin() != null && (de.getOrigin().getOrigin().getName().equals("Data") || de.getOrigin().getOrigin().getName().equals("Dictionaries")) && de.getOrigin().isMutable()) {
            removeDataElementAction = actionManager.getAction("Remove Data Element");
            removeDataElementAction.putValue("Data element", de);
            actions.add(removeDataElementAction);
        }
        if (importDocumentAction != null) {
            actions.add(importDocumentAction);
        }
        return actions.toArray(new Action[actions.size()]);
    }
}

