/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.standard.type.Base;
import biouml.workbench.BioUMLApplication;
import com.developmentontheedge.application.Application;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.gui.GUI;

public class RemoveDataElementAction
extends AbstractAction {
    protected Logger log = Logger.getLogger(RemoveDataElementAction.class.getName());
    public static final String KEY = "Remove Data Element";
    public static final String DATA_ELEMENT = "Data element";

    public RemoveDataElementAction() {
        super(KEY);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String message;
        DataElement de = (DataElement)this.getValue(DATA_ELEMENT);
        DataCollection dc = DataElementPath.create((DataElement)de).getParentCollection();
        if (!dc.isMutable()) {
            String message2 = BioUMLApplication.getMessageBundle().getResourceString("ERROR_CANNOT_REMOVE");
            message2 = MessageFormat.format(message2, de.getName(), dc.getCompletePath());
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), message2);
            return;
        }
        if (de instanceof Diagram) {
            message = BioUMLApplication.getMessageBundle().getResourceString("CONFIRM_REMOVE_DIAGRAM");
            message = MessageFormat.format(message, de.getName());
            int res = JOptionPane.showConfirmDialog((Component)Application.getApplicationFrame(), message);
            if (res != 0) {
                return;
            }
        } else {
            message = BioUMLApplication.getMessageBundle().getResourceString("CONFIRM_REMOVE_ELEMENT");
            message = MessageFormat.format(message, de.getName(), dc.getCompletePath());
            int res = JOptionPane.showConfirmDialog((Component)Application.getApplicationFrame(), message);
            if (res != 0) {
                return;
            }
        }
        try {
            dc.remove(de.getName());
            GUI.getManager().getRepositoryTabs().selectElement(dc.getCompletePath(), true);
        }
        catch (Throwable t) {
            this.log.log(Level.SEVERE, ExceptionRegistry.log((Throwable)t));
        }
    }

    protected boolean checkContainKernel(Compartment compartment, Base kernel) throws Exception {
        return compartment.recursiveStream().select(Compartment.class).anyMatch(c -> c.containsKernel(kernel));
    }
}

