/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench;

import biouml.workbench.BioUMLApplication;
import biouml.workbench.resources.MessageBundle;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import com.developmentontheedge.log.PatternFormatter;
import com.developmentontheedge.log.TextPaneAppender;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class ProcessElementDialog
extends OkCancelDialog {
    private static final String[] CATEGORY_LIST = new String[]{"biouml.diagram", "biouml.workbench", "biouml.plugins"};
    protected Logger log;
    protected TextPaneAppender appender;
    protected MessageBundle messageBundle = BioUMLApplication.getMessageBundle();

    public ProcessElementDialog(String titleKey) {
        this((JFrame)Application.getApplicationFrame(), titleKey);
    }

    public ProcessElementDialog(JFrame parent, String titleKey) {
        super(parent, "");
        this.setTitle(this.messageBundle.getResourceString(titleKey));
    }

    protected void initAppender(String title, String initialMessage) {
        this.appender = new TextPaneAppender((Formatter)new PatternFormatter("[%4$-7s] :  %5$s%n"), title);
        this.appender.setLevel(Level.INFO);
        this.appender.addToCategories(CATEGORY_LIST);
        this.appender.getLogTextPanel().setPreferredSize(new Dimension(350, 150));
        if (initialMessage != null) {
            this.appender.getLogTextPanel().setText(initialMessage);
        }
    }

    protected void info(String messageBundleKey, Object ... params) {
        String message = this.messageBundle.getResourceString(messageBundleKey);
        message = MessageFormat.format(message, params);
        this.log.info(message);
    }

    protected void warn(String messageBundleKey, Object ... params) {
        String message = this.messageBundle.getResourceString(messageBundleKey);
        message = MessageFormat.format(message, params);
        this.log.warning(message);
    }

    protected void error(String messageBundleKey, Object ... params) {
        String message = this.messageBundle.getResourceString(messageBundleKey);
        message = MessageFormat.format(message, params);
        this.log.log(Level.SEVERE, message);
    }
}

