/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench;

import biouml.workbench.BioUMLApplication;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.eclipse.core.runtime.IConfigurationElement;
import ru.biosoft.util.ExtensionRegistrySupport;

public class MenuItemRegistry
extends ExtensionRegistrySupport<ItemInfo> {
    private static final MenuItemRegistry instance = new MenuItemRegistry();
    public static final String TITLE = "title";
    public static final String ACTION_CLASS = "action";
    public static final String PARENT = "parent";

    private MenuItemRegistry() {
        super("biouml.workbench.menuItem", TITLE);
    }

    public static List<ItemInfo> getMenuItems() {
        return instance.stream().toList();
    }

    protected ItemInfo loadElement(IConfigurationElement element, String title) throws Exception {
        Class actionClass = this.getClassAttribute(element, ACTION_CLASS, AbstractAction.class);
        String parent = element.getAttribute(PARENT);
        if (parent == null) {
            parent = BioUMLApplication.getMessageBundle().getResourceString("MENU_FILE");
        }
        return new ItemInfo(actionClass, title, parent);
    }

    public static class ItemInfo {
        protected Class<? extends Action> action;
        protected String title;
        protected String parent;

        public ItemInfo(Class<? extends Action> action, String title, String parent) {
            this.action = action;
            this.title = title;
            this.parent = parent;
        }

        public Action getAction() throws Exception {
            return this.action.newInstance();
        }

        public String getTitle() {
            return this.title;
        }

        public String getParent() {
            return this.parent;
        }
    }
}

