/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench;

import biouml.workbench.BioUMLApplication;
import biouml.workbench.resources.MessageBundle;
import com.developmentontheedge.application.Application;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import one.util.streamex.StreamEx;
import ru.biosoft.access.ImageDataElement;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.util.TextUtil;

public class ImportImageDataElementAction
extends AbstractAction {
    public static final String KEY = "Import Image Data Element";
    public static final String IMAGES_COLLECTION = "Images data collection";
    private static final MessageBundle mb = BioUMLApplication.getMessageBundle();
    protected static final Component component = new Component(){};
    protected static final MediaTracker tracker = new MediaTracker(component);

    public ImportImageDataElementAction() {
        super(KEY);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = this.getValue(IMAGES_COLLECTION);
        if (!(o instanceof DataCollection)) {
            return;
        }
        DataCollection dc = (DataCollection)o;
        if (!dc.isMutable()) {
            String message = mb.getResourceString("ERROR_CANNOT_IMPORT");
            message = MessageFormat.format(message, dc.getCompletePath());
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), message);
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (file.isFile() && null != file.getName()) {
                    String[] extensions;
                    String fileName = file.getName().toLowerCase();
                    for (String extension : extensions = TextUtil.split((String)mb.getResourceString("PIC_EXTENSIONS"), (char)' ')) {
                        if (!fileName.endsWith(extension)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public String getDescription() {
                return mb.getResourceString("PIC_EXTENSIONS_TITLE");
            }
        });
        chooser.setMultiSelectionEnabled(true);
        int res = chooser.showOpenDialog((Component)Application.getApplicationFrame());
        if (res == 0) {
            File[] files;
            for (File file : files = chooser.getSelectedFiles()) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                try {
                    BufferedImage image = this.getBufferedImageFromImage(toolkit.getImage(file.getPath()));
                    dc.put((DataElement)new ImageDataElement(file.getName(), dc, image));
                }
                catch (Exception ex) {
                    ExceptionRegistry.log((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getBufferedImageFromImage(Image image) throws Exception {
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            boolean error = tracker.isErrorID(0);
            Object[] errors = tracker.getErrorsID(0);
            tracker.removeImage(image, 0);
            if (error) {
                throw new Exception("Error during get buffered image occurred: " + StreamEx.of((Object[])errors).joining((CharSequence)"\n"));
            }
        }
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }
}

