/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench;

import biouml.workbench.ProcessElementDialog;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.Option;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import one.util.streamex.StreamEx;
import ru.biosoft.access.DataElementImporterRegistry;
import ru.biosoft.access.DataElementRegistry;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementImporter;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.repository.RepositoryTabs;
import ru.biosoft.gui.DocumentManager;
import ru.biosoft.gui.GUI;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.jobcontrol.JobControlEvent;
import ru.biosoft.jobcontrol.JobControlListener;
import ru.biosoft.journal.Journal;
import ru.biosoft.journal.JournalRegistry;
import ru.biosoft.tasks.TaskInfo;
import ru.biosoft.util.ApplicationUtils;
import ru.biosoft.util.DPSUtils;
import ru.biosoft.util.PropertiesDialog;
import ru.biosoft.util.TextUtil;

public class ImportElementDialog
extends ProcessElementDialog
implements JobControlListener {
    protected JTextField tfPath = new JTextField(30);
    protected JLabel currentType = new JLabel();
    protected JComboBox<String> formatComboBox = new JComboBox();
    protected JProgressBar progressBar = new JProgressBar();
    private FunctionJobControl jobControl;
    protected DataCollection<?> parent;
    public static final String PREFERENCES_IMPORT_DIRECTORY = "importDialog.importDirectory";
    protected String importDirectory;

    public ImportElementDialog(DataCollection<?> parent) {
        super("IMPORT_ELEMENT_DIALOG_TITLE");
        this.setSize(500, 300);
        this.log = Logger.getLogger(ImportElementDialog.class.getName());
        this.parent = parent;
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        contentPane.add((Component)new JLabel(this.messageBundle.getResourceString("DIALOG_FILE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        contentPane.add((Component)this.tfPath, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        JButton browseButton = new JButton("...");
        contentPane.add((Component)browseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.tfPath.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ImportElementDialog.this.update();
            }
        });
        browseButton.addActionListener(e -> {
            JFileChooser chooser = new JFileChooser(new File(this.importDirectory));
            chooser.setMultiSelectionEnabled(true);
            int res = chooser.showOpenDialog((Component)Application.getApplicationFrame());
            if (res == 0) {
                Object[] files = chooser.getSelectedFiles();
                this.tfPath.setText(StreamEx.of((Object[])files).joining((CharSequence)";"));
                this.update();
                this.importDirectory = chooser.getCurrentDirectory().getAbsolutePath();
            }
        });
        contentPane.add((Component)new JLabel(this.messageBundle.getResourceString("DIALOG_FORMAT")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        contentPane.add(this.formatComboBox, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.progressBar.setMaximum(100);
        contentPane.add((Component)this.progressBar, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.initAppender("Element import log", this.messageBundle.getResourceString("IMPORT_ELEMENT_DIALOG_INFO"));
        contentPane.add((Component)new JLabel(this.messageBundle.getResourceString("DIALOG_INFO")), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        contentPane.add((Component)this.appender.getLogTextPanel(), new GridBagConstraints(0, 6, 3, 3, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.setContent(contentPane);
        this.okButton.setText(this.messageBundle.getResourceString("IMPORT_ELEMENT_DIALOG_IMPORT"));
        this.okButton.setPreferredSize(this.okButton.getMinimumSize());
        this.okButton.setEnabled(false);
        this.cancelButton.setText(this.messageBundle.getResourceString("DIALOG_CLOSE"));
        this.initFormats();
        this.loadPreferences();
    }

    protected void initFormats() {
        ((StreamEx)DataElementImporterRegistry.importers().filter(info -> info.getImporter().accept(this.parent, null) > 0)).map(DataElementRegistry.RegistryElementInfo::getFormat).prepend((Object)"autodetect").forEach(this.formatComboBox::addItem);
    }

    protected void loadPreferences() {
        this.importDirectory = Application.getPreferences().getStringValue("dialogs/importDialog.importDirectory", ".");
    }

    protected void savePreferences() {
        Application.getPreferences().addValue("dialogs/importDialog.importDirectory", (Object)this.importDirectory, "Default import directory", "Directory for file chooser to specify file for import.");
    }

    protected void update() {
        String fileName = this.tfPath.getText();
        this.okButton.setEnabled(fileName != null && fileName.length() > 0);
    }

    protected void okPressed() {
        final String[] fileNames = TextUtil.split((String)this.tfPath.getText(), (char)';');
        this.savePreferences();
        try {
            new Thread(){

                @Override
                public void run() {
                    try {
                        long totalStart = System.currentTimeMillis();
                        Integer totalOk = 0;
                        Integer totalFiles = 0;
                        for (JComponent c : new JComponent[]{ImportElementDialog.this.tfPath, ImportElementDialog.this.formatComboBox, ImportElementDialog.this.okButton}) {
                            c.setEnabled(false);
                        }
                        ImportElementDialog.this.cancelButton.setText(ImportElementDialog.this.messageBundle.getResourceString("DIALOG_CANCEL"));
                        for (String fileName : fileNames) {
                            PropertiesDialog dialog;
                            DataElementImporter importer;
                            Integer n = totalFiles;
                            Integer n2 = totalFiles = Integer.valueOf(totalFiles + 1);
                            File file = new File(fileName);
                            if (!file.exists()) {
                                ImportElementDialog.this.error("INVALID_FILE_NAME", fileName);
                                continue;
                            }
                            ImportElementDialog.this.info("IMPORT_ELEMENT_IMPORTING_FILE", fileName);
                            String format = (String)ImportElementDialog.this.formatComboBox.getSelectedItem();
                            if (format.equals("autodetect")) {
                                DataElementImporterRegistry.ImporterInfo[] importerInfos = DataElementImporterRegistry.getAutoDetectImporter((File)file, ImportElementDialog.this.parent, (boolean)false);
                                if (importerInfos == null || importerInfos.length == 0) {
                                    ImportElementDialog.this.error("NO_IMPORTERS_AVAILABLE", fileName);
                                    continue;
                                }
                                if (importerInfos.length > 1) {
                                    StringBuffer formats = new StringBuffer();
                                    for (DataElementImporterRegistry.ImporterInfo importerInfo : importerInfos) {
                                        formats.append("\n\t");
                                        formats.append(importerInfo.getFormat());
                                    }
                                    ImportElementDialog.this.error("MORE_THAN_ONE_IMPORTER_AVAILABLE", fileName, formats.toString());
                                    continue;
                                }
                                format = importerInfos[0].getFormat();
                                ImportElementDialog.this.info("IMPORTER_CHOSEN", fileName, format);
                            }
                            if ((importer = DataElementImporterRegistry.getImporter((File)file, (String)format, ImportElementDialog.this.parent)) == null) {
                                ImportElementDialog.this.error("NO_IMPORTERS_AVAILABLE", fileName, format);
                                continue;
                            }
                            Object properties = importer.getProperties(ImportElementDialog.this.parent, file, ApplicationUtils.getFileNameWithoutExtension((String)file.getName()));
                            if (properties instanceof Option && !(dialog = ImportElementDialog.this.createPropertiesDialog((Option)properties)).doModal()) {
                                ImportElementDialog.this.cancelPressed();
                                return;
                            }
                            long start = System.currentTimeMillis();
                            ImportElementDialog.this.info("IMPORT_ELEMENT_IMPORT_STARTED", new Object[0]);
                            try {
                                ImportElementDialog.this.jobControl = new FunctionJobControl(null);
                                ImportElementDialog.this.jobControl.addListener((JobControlListener)ImportElementDialog.this);
                                String finalFormat = format;
                                Journal journal = JournalRegistry.getCurrentJournal();
                                TaskInfo task = journal == null ? null : journal.getEmptyAction();
                                DataElement importedDE = importer.doImport(ImportElementDialog.this.parent, file, ApplicationUtils.getFileNameWithoutExtension((String)file.getName()), ImportElementDialog.this.jobControl, ImportElementDialog.this.log);
                                if (ImportElementDialog.this.jobControl.getStatus() == 4) {
                                    ImportElementDialog.this.info("IMPORT_ELEMENT_IMPORT_CANCELLED", new Object[0]);
                                    break;
                                }
                                if (ImportElementDialog.this.jobControl.getStatus() == 3) {
                                    if (task != null) {
                                        task.setType("import");
                                        task.setData(file.getAbsolutePath());
                                        task.getAttributes().add(new DynamicProperty("outputPath", String.class, (Object)DataElementPath.create(ImportElementDialog.this.parent, (String)ApplicationUtils.getFileNameWithoutExtension((String)file.getName())).toString()));
                                        task.getAttributes().add(new DynamicProperty(TaskInfo.IMPORT_FORMAT_PROPERTY_DESCRIPTOR, String.class, (Object)format));
                                        if (properties != null) {
                                            DPSUtils.writeBeanToDPS((Object)properties, (DynamicPropertySet)task.getAttributes(), (String)"parameter.");
                                        }
                                        task.setEndTime();
                                        journal.addAction(task);
                                    }
                                    Integer n3 = totalOk;
                                    Integer n4 = totalOk = Integer.valueOf(totalOk + 1);
                                    String time = String.valueOf(System.currentTimeMillis() - start);
                                    ImportElementDialog.this.info("IMPORT_ELEMENT_DIALOG_SUCCESS", finalFormat, file.getAbsolutePath(), time);
                                    if (importedDE == null) continue;
                                    GUI.getManager().getRepositoryTabs().selectElement(importedDE.getCompletePath());
                                    continue;
                                }
                                ImportElementDialog.this.log.info(ImportElementDialog.this.jobControl.getTextStatus());
                            }
                            catch (Throwable t) {
                                ImportElementDialog.this.error("IMPORT_ELEMENT_FAILED", t.toString());
                            }
                        }
                        String time = String.valueOf(System.currentTimeMillis() - totalStart);
                        ImportElementDialog.this.info("IMPORT_ELEMENT_COMPLETE", time, totalOk.toString(), String.valueOf(totalFiles - totalOk));
                    }
                    catch (Exception ex) {
                        ImportElementDialog.this.error("ERROR_IMPORTING_ELEMENT", ImportElementDialog.this.tfPath.getText(), ImportElementDialog.this.formatComboBox.getSelectedItem(), ex.getMessage());
                    }
                    for (JComponent c : new JComponent[]{ImportElementDialog.this.tfPath, ImportElementDialog.this.formatComboBox, ImportElementDialog.this.okButton}) {
                        c.setEnabled(true);
                    }
                    ImportElementDialog.this.cancelButton.setText(ImportElementDialog.this.messageBundle.getResourceString("DIALOG_CLOSE"));
                }
            }.start();
        }
        catch (Exception ex) {
            this.error("ERROR_IMPORTING_ELEMENT", this.tfPath.getText(), this.formatComboBox.getSelectedItem(), ex.getMessage());
        }
    }

    protected void cancelPressed() {
        if (this.jobControl != null && this.jobControl.getStatus() == 1) {
            this.jobControl.terminate();
        } else {
            super.cancelPressed();
        }
    }

    public void jobPaused(JobControlEvent event) {
    }

    public void jobResumed(JobControlEvent event) {
    }

    public void jobStarted(JobControlEvent event) {
    }

    public void jobTerminated(JobControlEvent event) {
        if (event.getJobControl().getStatus() == 5) {
            this.error("ERROR_IMPORTING_EXCEPTION", event.getMessage());
        }
    }

    public void resultsReady(JobControlEvent event) {
        DocumentManager documentManager = DocumentManager.getDocumentManager();
        RepositoryTabs repositoryTabs = GUI.getManager().getRepositoryTabs();
        for (Object result : event.getResults()) {
            if (!(result instanceof DataElement)) continue;
            DataElement de = (DataElement)result;
            documentManager.openDocument(de);
            repositoryTabs.selectElement(de.getCompletePath());
        }
    }

    public void valueChanged(JobControlEvent event) {
        this.progressBar.setValue(event.getPreparedness());
    }

    protected PropertiesDialog createPropertiesDialog(Option properties) {
        return new PropertiesDialog((JDialog)((Object)this), "Import properties", (Object)properties);
    }
}

