/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import javax.imageio.ImageIO;
import one.util.streamex.StreamEx;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.ImageView;
import ru.biosoft.graphics.TextView;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.font.ColorFont;

class GenerateSplash {
    public static final int WIDTH = 405;
    public static final int HEIGHT = 247;

    GenerateSplash() {
    }

    public static void main(String[] args) throws IOException {
        String paths;
        if (args.length < 3) {
            return;
        }
        String version = args[0];
        String fileName = args[1];
        boolean expanded = false;
        if (args.length == 4) {
            expanded = args[2].equals("true");
            paths = args[3];
        } else {
            paths = args[2];
        }
        int height = expanded ? 268 : 247;
        int textLocation = 237;
        BufferedImage image = new BufferedImage(405, height, 1);
        Graphics2D graphics = image.createGraphics();
        CompositeView result = new CompositeView();
        result.add((View)new ImageView((Image)ImageIO.read(GenerateSplash.class.getResource("resources/splash_base.png").openStream()), 0, 0, 405, height));
        Font font = new Font("Verdana", 1, 26);
        result.add((View)new TextView("Version " + version, new Point(204, 142), 2, new ColorFont(font, new Color(200, 200, 200)), (Graphics)graphics));
        result.add((View)new TextView("Version " + version, new Point(202, 140), 2, new ColorFont(font, new Color(0, 166, 81)), (Graphics)graphics));
        result.add((View)new TextView("\u00a9 2002-" + Calendar.getInstance().get(1) + " Institute of Systems Biology, Novosibirsk, Russia", new Point(202, textLocation), 2, new ColorFont(new Font("Tahoma", 1, 12), new Color(24, 2, 104)), (Graphics)graphics));
        Rectangle shape = new Rectangle(new Point(0, 0), new Dimension(405, height));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setClip(shape);
        graphics.setColor(Color.WHITE);
        graphics.fill(shape);
        result.paint(graphics);
        for (String s2 : StreamEx.of((Object)paths).flatMap(s -> StreamEx.split((CharSequence)s, (char)';'))) {
            ImageIO.write((RenderedImage)image, "PNG", new FileOutputStream(new File(s2 + fileName)));
        }
    }
}

