/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench;

import biouml.workbench.ProcessElementDialog;
import biouml.workbench.diagram.DiagramDocument;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Preferences;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.Property;
import com.developmentontheedge.beans.swing.PropertyInspector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import ru.biosoft.access.DataElementExporter;
import ru.biosoft.access.DataElementExporterRegistry;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.gui.Document;

public class ExportElementDialog
extends ProcessElementDialog {
    protected JTextField tfPath = new JTextField(30);
    protected DataElement dataElement;
    protected JLabel currentType = new JLabel();
    protected JComboBox<String> formatComboBox = new JComboBox();
    protected static final String PREFERENCES_EXPORT_DIRECTORY = "exportDialog.exportDirectory";
    protected String exportDirectory;

    public ExportElementDialog(JFrame parent, DataElement dataElement) {
        super(parent, "EXPORT_ELEMENT_DIALOG_TITLE");
        this.log = Logger.getLogger(ExportElementDialog.class.getName());
        this.dataElement = dataElement;
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        contentPane.add((Component)new JLabel(this.messageBundle.getResourceString("DIALOG_FILE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        contentPane.add((Component)this.tfPath, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        JButton browseButton = new JButton("...");
        contentPane.add((Component)browseButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.tfPath.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ExportElementDialog.this.update();
            }
        });
        browseButton.addActionListener(e -> {
            JFileChooser chooser = new JFileChooser(new File(this.exportDirectory));
            int res = chooser.showOpenDialog((Component)Application.getApplicationFrame());
            if (res == 0) {
                File file = chooser.getSelectedFile();
                this.tfPath.setText(file.getPath());
                this.update();
                this.exportDirectory = chooser.getCurrentDirectory().getAbsolutePath();
            }
        });
        contentPane.add((Component)new JLabel(this.messageBundle.getResourceString("DIALOG_FORMAT")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        contentPane.add(this.formatComboBox, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.initFormats();
        this.initAppender("Element export log", "");
        contentPane.add((Component)new JLabel(this.messageBundle.getResourceString("DIALOG_INFO")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        contentPane.add((Component)this.appender.getLogTextPanel(), new GridBagConstraints(0, 4, 3, 3, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.setContent(contentPane);
        this.okButton.setText(this.messageBundle.getResourceString("EXPORT_ELEMENT_DIALOG_EXPORT"));
        this.okButton.setPreferredSize(this.okButton.getMinimumSize());
        this.okButton.setEnabled(false);
        this.cancelButton.setText(this.messageBundle.getResourceString("DIALOG_CLOSE"));
        this.loadPreferences();
    }

    protected void initFormats() {
        List formats = DataElementExporterRegistry.getExporterFormats((DataElement)this.dataElement);
        if (formats.size() == 0) {
            this.info("EXPORT_ELEMENT_DIALOG_NO_EXPORTERS", new Object[0]);
        }
        for (String format : formats) {
            this.formatComboBox.addItem(format);
        }
    }

    protected void loadPreferences() {
        String key = "dialogs/exportDialog.exportDirectory";
        this.exportDirectory = Application.getPreferences().getStringValue(key, ".");
    }

    protected void savePreferences() {
        String key = "dialogs/exportDialog.exportDirectory";
        if (Application.getPreferences().getProperty(key) != null) {
            Application.getPreferences().setValue(key, (Object)this.exportDirectory);
        } else {
            try {
                Preferences preferences = Application.getPreferences().getPreferencesValue("dialogs");
                preferences.add(new DynamicProperty(PREFERENCES_EXPORT_DIRECTORY, this.messageBundle.getResourceString("EXPORT_ELEMENT_DIALOG_PREFERENCES_DIR_PN"), this.messageBundle.getResourceString("EXPORT_ELEMENT_DIALOG_PREFERENCES_DIR_PD"), String.class, (Object)this.exportDirectory));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void update() {
        String fileName = this.tfPath.getText();
        this.okButton.setEnabled(fileName != null && fileName.length() > 0 && this.formatComboBox.getItemCount() > 0);
    }

    protected void okPressed() {
        String format = (String)this.formatComboBox.getSelectedItem();
        String fileName = this.tfPath.getText();
        this.savePreferences();
        try {
            String suffix;
            DataElementExporterRegistry.ExporterInfo[] exporterInfo = DataElementExporterRegistry.getExporterInfo((String)format, (DataElement)this.dataElement);
            if (exporterInfo == null) {
                this.error("EXPORT_ELEMENT_DIALOG_NO_EXPORTER", new Object[0]);
                return;
            }
            if (exporterInfo.length > 1) {
                this.info("There are more than one exporters available for the given format:", new Object[0]);
                for (int i = 0; i < exporterInfo.length; ++i) {
                    this.info(i + 1 + ". " + exporterInfo[i].getExporter().getClass().getName(), new Object[0]);
                }
                this.info("The first one " + exporterInfo[0].getExporter().getClass().getName() + " will be used.", new Object[0]);
            }
            if ((suffix = exporterInfo[0].getSuffix()).indexOf(46) == -1) {
                suffix = "." + suffix;
            }
            if (fileName.endsWith(suffix)) {
                suffix = "";
            }
            File file = new File(fileName + suffix);
            DataElementExporter exporter = exporterInfo[0].cloneExporter();
            Object exportProperties = exporter.getProperties(this.dataElement, file);
            if (exportProperties != null) {
                OkCancelDialog dialog;
                Document document;
                Property scaleProperty = ComponentFactory.getModel((Object)exportProperties).findProperty("scale");
                if (scaleProperty != null && (document = Document.getCurrentDocument()) instanceof DiagramDocument && ((DiagramDocument)document).getDiagram() == this.dataElement) {
                    scaleProperty.setValue((Object)((DiagramDocument)document).getViewPane().getScaleX());
                }
                if (!(dialog = this.createPropertiesDialog(exportProperties)).doModal()) {
                    this.cancelPressed();
                    return;
                }
            }
            long start = System.currentTimeMillis();
            exporter.doExport(this.dataElement, file);
            String time = "" + (System.currentTimeMillis() - start);
            this.info("EXPORT_ELEMENT_DIALOG_SUCCESS", this.dataElement.getName(), format, file.getAbsolutePath(), time);
        }
        catch (Exception e) {
            this.error("EXPORT_ELEMENT_DIALOG_ERROR", this.dataElement.getName(), format, e.getMessage());
        }
    }

    protected OkCancelDialog createPropertiesDialog(Object properties) {
        PropertyInspector propertyInspector = new PropertyInspector();
        propertyInspector.explore(properties);
        OkCancelDialog dialog = new OkCancelDialog((JDialog)((Object)this), "Export properties");
        dialog.add((Component)propertyInspector);
        return dialog;
    }
}

