/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench;

import biouml.model.Diagram;
import biouml.model.DiagramTypeConverter;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.workbench.ProcessElementDialog;
import biouml.workbench.diagram.DiagramDocument;
import biouml.workbench.diagram.DiagramTypeConverterRegistry;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.GUI;

public class ConvertDiagramDialog
extends ProcessElementDialog {
    protected static final Logger log = Logger.getLogger(ConvertDiagramDialog.class.getName());
    protected JLabel currentType = new JLabel();
    protected JTextField diagramName = new JTextField();
    protected JComboBox<String> diagramType = new JComboBox();
    protected DiagramTypeConverterRegistry.Conversion[] conversions;
    protected Diagram diagram;
    private Document document;
    private boolean notification;

    public ConvertDiagramDialog(Diagram diagram) {
        super("CONVERT_DIAGRAM_DIALOG_TITLE");
        this.diagram = diagram;
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        contentPane.add((Component)new JLabel(this.messageBundle.getResourceString("DIAGRAM_DIALOG_DIAGRAM")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        contentPane.add((Component)new JLabel(diagram.getName() + " (" + diagram.getTitle() + ")"), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        contentPane.add((Component)new JLabel(this.messageBundle.getResourceString("CONVERT_DIAGRAM_DIALOG_TYPE")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        contentPane.add((Component)this.currentType, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        contentPane.add((Component)new JLabel(this.messageBundle.getResourceString("CONVERT_DIAGRAM_DIALOG_NEW_NAME")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        contentPane.add((Component)this.diagramName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.diagramName.setText(diagram.getName() + "(converted)");
        contentPane.add((Component)new JLabel(this.messageBundle.getResourceString("CONVERT_DIAGRAM_DIALOG_NEW_TYPE")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        contentPane.add(this.diagramType, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.initAppender("Converter log", "");
        contentPane.add((Component)new JLabel(this.messageBundle.getResourceString("DIAGRAM_DIALOG_INFO")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        contentPane.add((Component)this.appender.getLogTextPanel(), new GridBagConstraints(0, 5, 2, 2, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.init(true);
        this.setContent(contentPane);
        this.okButton.setText(this.messageBundle.getResourceString("CONVERT_DIAGRAM_DIALOG_CONVERT"));
        this.okButton.setPreferredSize(this.okButton.getMinimumSize());
        this.cancelButton.setText(this.messageBundle.getResourceString("DIAGRAM_DIALOG_CLOSE"));
        this.okButton.setEnabled(true);
    }

    protected void init(boolean isFirst) {
        String type = this.diagram.getType().getClass().getName();
        try {
            BeanInfo info = Introspector.getBeanInfo(this.diagram.getType().getClass());
            type = info.getBeanDescriptor().getDisplayName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentType.setText(type);
        if (!isFirst) {
            this.diagramType.removeAllItems();
        }
        this.conversions = DiagramTypeConverterRegistry.getPossibleConversions(this.diagram.getType().getClass().getName());
        if (this.conversions == null || this.conversions.length == 0) {
            if (isFirst) {
                log.info(this.messageBundle.getResourceString("CONVERT_DIAGRAM_DIALOG_NO_CONVERSIONS"));
            } else {
                log.info(this.messageBundle.getResourceString("CONVERT_DIAGRAM_DIALOG_NO_FURTHER_CONVERSIONS"));
            }
            this.okButton.setEnabled(false);
        } else {
            for (DiagramTypeConverterRegistry.Conversion conversion : this.conversions) {
                this.diagramType.addItem(conversion.getDiagramTypeDisplayName());
            }
            this.diagramType.setSelectedIndex(0);
        }
    }

    protected void okPressed() {
        DiagramTypeConverterRegistry.Conversion conversion = this.conversions[this.diagramType.getSelectedIndex()];
        log.info(MessageFormat.format(this.messageBundle.getResourceString("CONVERT_DIAGRAM_DIALOG_START"), this.diagram.getName(), this.diagram.getTitle(), this.currentType.getText(), conversion.getDiagramTypeDisplayName()));
        try {
            DataElementPath path = DataElementPath.create((DataCollection)this.diagram.getOrigin(), (String)this.diagramName.getText());
            Diagram newDiagram = this.diagram.clone(path.getParentCollection(), path.getName());
            DiagramTypeConverter converter = conversion.getConverter().newInstance();
            this.startTransaction();
            newDiagram = converter.convert(newDiagram, conversion.getDiagramType());
            CollectionFactoryUtils.save((DataElement)newDiagram);
            this.completeTransaction();
            this.updateDiagramPane();
            log.info(this.messageBundle.getResourceString("CONVERT_DIAGRAM_DIALOG_SUCCESS"));
            this.init(false);
        }
        catch (IllegalArgumentException iae) {
            log.info(MessageFormat.format(this.messageBundle.getResourceString("CONVERT_DIAGRAM_DIALOG_ILLEGAL"), iae.getMessage()));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Creating new diagram ", e);
        }
    }

    protected void updateDiagramPane() {
        if (this.document != null) {
            this.document.update();
            this.document.updateViewPane();
        }
    }

    protected void startTransaction() {
        Role role;
        for (Document document : GUI.getManager().getDocuments()) {
            if (!(document instanceof DiagramDocument) || ((DiagramDocument)document).getDiagram() != this.diagram) continue;
            this.document = document;
            ((ViewEditorPane)document.getViewPane()).startTransaction("Convert");
            break;
        }
        if ((role = this.diagram.getRole()) instanceof EModel) {
            EModel emodel = (EModel)role;
            this.notification = emodel.isNotificationEnabled();
            emodel.setNotificationEnabled(false);
            ((ViewEditorPane)this.document.getViewPane()).addEdit((UndoableEdit)new NotificationUndo((EModel)role, this.notification, false));
        }
    }

    protected void completeTransaction() {
        Role role = this.diagram.getRole();
        if (role instanceof EModel) {
            EModel emodel = (EModel)role;
            boolean oldNotification = emodel.isNotificationEnabled();
            emodel.setNotificationEnabled(this.notification);
            ((ViewEditorPane)this.document.getViewPane()).addEdit((UndoableEdit)new NotificationUndo(emodel, oldNotification, this.notification));
        }
        if (this.document != null) {
            ((ViewEditorPane)this.document.getViewPane()).completeTransaction();
        }
    }

    public static class NotificationUndo
    extends AbstractUndoableEdit {
        protected boolean oldNotification;
        protected boolean newNotification;
        protected EModel emodel = null;

        public NotificationUndo(EModel emodel, boolean oldNotification, boolean newNotification) {
            this.emodel = emodel;
            this.oldNotification = oldNotification;
            this.newNotification = newNotification;
        }

        @Override
        public void undo() throws CannotUndoException {
            this.emodel.setNotificationEnabled(this.oldNotification);
        }

        @Override
        public void redo() throws CannotRedoException {
            this.emodel.setNotificationEnabled(this.newNotification);
        }

        @Override
        public String getPresentationName() {
            return "Change executable model notification";
        }
    }
}

