/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench;

import biouml.model.Node;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.graphics.editor.SelectionManager;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.graphics.editor.ViewPaneAdapter;
import ru.biosoft.graphics.editor.ViewPaneEvent;
import ru.biosoft.graphics.editor.ViewPaneListener;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.DocumentManager;
import ru.biosoft.gui.DocumentViewAccessProvider;
import ru.biosoft.gui.GUI;

public class BioUMLDocumentViewAccessProvider
implements DocumentViewAccessProvider {
    protected static final Logger log = Logger.getLogger(BioUMLDocumentViewAccessProvider.class.getName());
    protected DiagramViewListener diagramViewListener;

    public ViewPaneListener getDocumentViewListener() {
        if (this.diagramViewListener == null) {
            this.diagramViewListener = new DiagramViewListener();
        }
        return this.diagramViewListener;
    }

    public void updateSelection(ViewPane viewPane) {
        SelectionManager sm = viewPane.getSelectionManager();
        if (sm.getSelectedViewCount() != 1) {
            return;
        }
        Object model = sm.getSelectedView(0).getModel();
        GUI.getManager().explore(model);
    }

    public void enableDocumentActions(boolean b) {
    }

    public void stateChanged(ChangeEvent e) {
    }

    public void closeCurrentDocument() {
    }

    public boolean saveDocumentCurrentApplicationConfirmDialog(Document document, String displayName) {
        return false;
    }

    public void saveDocument() {
    }

    public boolean askSaveConfirmation(Document doc) {
        return doc.isChanged();
    }

    class DiagramViewListener
    extends ViewPaneAdapter {
        DiagramViewListener() {
        }

        public void openElement(ViewPane viewPane) {
            DataElement de;
            Object path;
            SelectionManager sm = viewPane.getSelectionManager();
            if (sm.getSelectedViewCount() != 1) {
                return;
            }
            Object model = sm.getSelectedView(0).getModel();
            if (model instanceof Node && (path = ((Node)((Object)model)).getAttributes().getValue("completeName")) != null && (de = CollectionFactory.getDataElement((String)path.toString())) != null && DocumentManager.getDocumentManager().openDocument(de) == null) {
                log.log(Level.SEVERE, "Cannot open: " + path);
            }
        }

        public void mousePressed(ViewPaneEvent e) {
            BioUMLDocumentViewAccessProvider.this.updateSelection(e.getViewPane());
            if (e.getClickCount() > 1) {
                this.openElement(e.getViewPane());
            }
        }
    }
}

