/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench;

import biouml.model.Module;
import biouml.workbench.BioUMLDocumentViewAccessProvider;
import biouml.workbench.ImportElementAction;
import biouml.workbench.ImportImageDataElementAction;
import biouml.workbench.MenuItemRegistry;
import biouml.workbench.NewDataElementAction;
import biouml.workbench.PreferencesAction;
import biouml.workbench.ProxyTester;
import biouml.workbench.RemoveDataElementAction;
import biouml.workbench.RepositoryDocument;
import biouml.workbench.diagram.DiagramDocument;
import biouml.workbench.diagram.NewDiagramAction;
import biouml.workbench.diagram.SaveAsDocumentAction;
import biouml.workbench.module.ExportModuleAction;
import biouml.workbench.module.ModuleSetupAction;
import biouml.workbench.module.NewModuleAction;
import biouml.workbench.module.RemoveModuleAction;
import biouml.workbench.module.xml.EditModuleAction;
import biouml.workbench.module.xml.NewCompositeModuleAction;
import biouml.workbench.perspective.Perspective;
import biouml.workbench.perspective.PerspectiveRegistry;
import biouml.workbench.perspective.PerspectiveUI;
import biouml.workbench.resources.MessageBundle;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationFrame;
import com.developmentontheedge.application.ApplicationMenu;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.application.PanelInfo;
import com.developmentontheedge.application.PanelManager;
import com.developmentontheedge.application.action.ActionInitializer;
import com.developmentontheedge.application.action.ActionManager;
import com.developmentontheedge.application.action.TogglePanelAction;
import com.developmentontheedge.beans.ActionsProvider;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Preferences;
import com.developmentontheedge.print.PrintAction;
import com.developmentontheedge.print.PrintManager;
import com.developmentontheedge.print.PrintPreviewAction;
import com.developmentontheedge.print.PrintSetupAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyDescriptor;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.Platform;
import ru.biosoft.access.AccessCoreInit;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.DataCollectionListenerRegistry;
import ru.biosoft.access.QuerySystemRegistry;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.exception.BiosoftExceptionTranslator;
import ru.biosoft.access.history.HistoryFacade;
import ru.biosoft.access.repository.PluginActions;
import ru.biosoft.access.repository.RepositoryListener;
import ru.biosoft.access.repository.RepositoryTabs;
import ru.biosoft.access.security.LoginAction;
import ru.biosoft.access.security.LoginDialog;
import ru.biosoft.access.security.LogoutAction;
import ru.biosoft.access.security.RegisterAction;
import ru.biosoft.access.security.SecurityManager;
import ru.biosoft.access.security.SingleSignOnSupport;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.exception.ExceptionTranslator;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.access.DataElementModelResolver;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.graphics.editor.ViewPaneListener;
import ru.biosoft.gui.CloseAllDocumentAction;
import ru.biosoft.gui.CloseDocumentAction;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.DocumentManager;
import ru.biosoft.gui.DocumentViewAccessProvider;
import ru.biosoft.gui.DocumentsPane;
import ru.biosoft.gui.ExplorerPane;
import ru.biosoft.gui.ExportDocumentAction;
import ru.biosoft.gui.GUI;
import ru.biosoft.gui.OpenPathAction;
import ru.biosoft.gui.PluggedEditorsTabbedPane;
import ru.biosoft.gui.SaveDocumentAction;
import ru.biosoft.gui.ViewPart;
import ru.biosoft.gui.setupwizard.OpenSetupWizardAction;
import ru.biosoft.gui.setupwizard.SetupWizardDialog;
import ru.biosoft.gui.setupwizard.SetupWizardSupport;
import ru.biosoft.gui.setupwizard.WizardPageRegistry;
import ru.biosoft.journal.JournalProperties;
import ru.biosoft.journal.JournalRegistry;
import ru.biosoft.plugins.Plugins;
import ru.biosoft.server.servlets.webservices.HttpServer;
import ru.biosoft.tasks.TaskManager;
import ru.biosoft.util.BeanUtil;
import ru.biosoft.util.JULBeanLogger;
import ru.biosoft.util.NetworkConfigurator;
import ru.biosoft.workbench.AboutAction;
import ru.biosoft.workbench.Framework;
import ru.biosoft.workbench.HelpAction;
import ru.biosoft.workbench.LookAndFeelManager;

public class BioUMLApplication
extends ApplicationFrame
implements ChangeListener,
DocumentViewAccessProvider {
    protected static final int GROUP_FILE = 1;
    protected static final int GROUP_EDIT = 2;
    protected static final int GROUP_DOCUMENT = 3;
    protected static final int GROUP_PANE = 4;
    protected static final int GROUP_SETUP = 5;
    protected static final int GROUP_HELP = 6;
    public static final String CONFIG_FILE = "preferences.xml";
    public static final String JAVA_LIBRARY_PATH = "JAVA_LIBRARY_PATH";
    public static final String SETUP_WIZARD_LOGO = "biouml/workbench/resources/logo.png";
    public static final String HOME_HOST = "http://biouml.org";
    public static final String LOCATION_PROPERTY_NAME = "Window location";
    protected static final Logger log = Logger.getLogger(BioUMLApplication.class.getName());
    private final DocumentViewAccessProvider accessProvider = new BioUMLDocumentViewAccessProvider();
    private static final View.ModelResolver viewModelResolver = new DataElementModelResolver();
    private static final ExceptionTranslator translator = new BiosoftExceptionTranslator();
    protected JComboBox<String> journalBox = null;
    private static MessageBundle messageBundle = (MessageBundle)ResourceBundle.getBundle(MessageBundle.class.getName());

    public BioUMLApplication(Image icon, String[] dataPath) {
        super(new ActionManager(), (com.developmentontheedge.application.DocumentManager)new DocumentManager(null), new PanelManager(), "");
        try {
            AccessCoreInit.init();
            QuerySystemRegistry.initQuerySystems();
            DataCollectionListenerRegistry.initDataCollectionListeners();
            JULBeanLogger.install();
            this.setDefaultCloseOperation(0);
            ExceptionRegistry.setExceptionRegistry((ExceptionTranslator)translator);
            this.loadPreferences();
            NetworkConfigurator.initNetworkConfiguration();
            this.setTitle(Application.getGlobalValue((String)"ApplicationTitle"));
            Rectangle rect = this.getWindowRect();
            this.setLocation(rect.x, rect.y);
            this.setSize(rect.width, rect.height);
            if (icon != null) {
                this.setIconImage(icon);
            }
            int threadCount = Thread.activeCount();
            Thread[] threads = new Thread[threadCount];
            Thread.enumerate(threads);
            for (int i = 0; i < threadCount; ++i) {
                if (threads[i] == null) continue;
                try {
                    threads[i].setContextClassLoader(Thread.currentThread().getContextClassLoader());
                    threads[i].setPriority(1);
                    continue;
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "Could not assign thread priority", t);
                }
            }
            try {
                CollectionFactoryUtils.init();
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not initialize: " + ExceptionRegistry.log((Throwable)t));
            }
            try {
                Framework.initRepository((String[])dataPath);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not initialize repository: " + ExceptionRegistry.log((Throwable)t));
            }
            try {
                Plugins.getPlugins();
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Failed to init plugins", t);
                System.out.println("Failed to init plugins: " + t);
            }
            BioUMLApplication.initActions();
            this.initPanels();
            this.initToolbar();
            this.initMenubar();
            this.initHTTPServer();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (BioUMLApplication.this.closeApplication()) {
                        BioUMLApplication.this.setVisible(false);
                        BioUMLApplication.this.dispose();
                        Preferences locPreferences = Application.getPreferences().getPreferencesValue(BioUMLApplication.LOCATION_PROPERTY_NAME);
                        if (locPreferences != null) {
                            Point location = BioUMLApplication.this.getLocation();
                            locPreferences.getProperty("x").setValue((Object)location.x);
                            locPreferences.getProperty("y").setValue((Object)location.y);
                            Dimension dimension = BioUMLApplication.this.getSize();
                            locPreferences.getProperty("width").setValue((Object)dimension.width);
                            locPreferences.getProperty("height").setValue((Object)dimension.height);
                        }
                        BioUMLApplication.this.savePreferences();
                        System.exit(0);
                    }
                }
            });
            DocumentsPane.getDocumentsPane().addChangeListener((ChangeListener)this);
            View.setModelResolver((View.ModelResolver)viewModelResolver);
            this.setVisible(true);
            PerspectiveUI.initPerspective();
            this.validate();
            this.login();
            BioUMLApplication.showSetupWizard();
            ProxyTester.testServer(HOME_HOST, 10000, result -> {
                if (result == -1L) {
                    ApplicationUtils.errorBox((String)"Proxy error", (String)BioUMLApplication.getMessageBundle().getResourceString("PROXY_ERROR_MESSAGE"));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void loadPreferences() {
        String fileName = Platform.getInstallLocation().getURL().getPath() + CONFIG_FILE;
        Preferences preferences = new Preferences();
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            preferences.load(fileName, cl);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Load preferences error", t);
        }
        Application.setPreferences((Preferences)preferences);
        if (preferences.getValue("dialogs") == null) {
            PropertyDescriptor descriptor = BeanUtil.createDescriptor((String)"dialogs");
            descriptor.setExpert(true);
            preferences.add(new DynamicProperty(descriptor, Preferences.class, (Object)new Preferences()));
        }
        if (preferences.getValue(JAVA_LIBRARY_PATH) != null) {
            ClassLoading.addJavaLibraryPath((String)preferences.getStringValue(JAVA_LIBRARY_PATH, null));
        }
        LookAndFeelManager.loadLookAndFeel((String)UIManager.getSystemLookAndFeelClassName());
    }

    protected void savePreferences() {
        try {
            Application.getPreferences().save(CONFIG_FILE);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Save preferences error", t);
        }
    }

    protected Rectangle getWindowRect() {
        int y;
        int x;
        int height;
        int width;
        Preferences locPreferences = Application.getPreferences().getPreferencesValue(LOCATION_PROPERTY_NAME);
        if (locPreferences == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            DisplayMode mode = gd.getDisplayMode();
            width = 1200;
            height = 750;
            x = (mode.getWidth() - width) / 2;
            y = (mode.getHeight() - height) / 2;
            try {
                locPreferences = new Preferences();
                locPreferences.add(new DynamicProperty("x", Integer.class, (Object)x));
                locPreferences.add(new DynamicProperty("y", Integer.class, (Object)y));
                locPreferences.add(new DynamicProperty("width", Integer.class, (Object)width));
                locPreferences.add(new DynamicProperty("height", Integer.class, (Object)height));
                DynamicProperty locProperty = new DynamicProperty(LOCATION_PROPERTY_NAME, Preferences.class, (Object)locPreferences);
                locProperty.setHidden(true);
                Application.getPreferences().add(locProperty);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Cannot create properties to save window location");
            }
        } else {
            x = (Integer)locPreferences.getValue("x");
            y = (Integer)locPreferences.getValue("y");
            width = (Integer)locPreferences.getValue("width");
            height = (Integer)locPreferences.getValue("height");
        }
        return new Rectangle(x, y, width, height);
    }

    protected void initHTTPServer() {
        int port;
        Random random = new Random();
        int minPort = 20000;
        int maxPort = 25000;
        String sessionId = SecurityManager.generateSessionId();
        int tryNum = 0;
        while (true) {
            try {
                port = random.nextInt(maxPort - minPort) + minPort;
                new HttpServer(port, sessionId).startServer();
            }
            catch (Exception e) {
                if (tryNum++ <= 100) continue;
                log.log(Level.SEVERE, "Unable to start HTTP server", e);
                return;
            }
            break;
        }
        Application.getPreferences().getPreferencesValue("Global").addValue("ServerPath", (Object)("http://localhost:" + port + "/biouml"));
        Application.getPreferences().getPreferencesValue("Global").addValue("ServerSession", (Object)sessionId);
    }

    public static void initActions() {
        ActionManager actionManager = Application.getActionManager();
        actionManager.addAction("Preferences", (Action)new PreferencesAction());
        actionManager.addAction("Login", (Action)new LoginAction(true));
        actionManager.addAction("Register", (Action)new RegisterAction(true));
        actionManager.addAction("Logout", (Action)new LogoutAction(false));
        actionManager.addAction("Setup wizard", (Action)new OpenSetupWizardAction());
        actionManager.addAction("New module", (Action)new NewModuleAction());
        actionManager.addAction("New composite database", (Action)new NewCompositeModuleAction());
        actionManager.addAction("Module Setup", (Action)new ModuleSetupAction());
        actionManager.addAction("Remove module", (Action)new RemoveModuleAction());
        actionManager.addAction("Export module", (Action)new ExportModuleAction());
        actionManager.addAction("Edit module", (Action)new EditModuleAction());
        actionManager.addAction("New diagram", (Action)new NewDiagramAction());
        actionManager.addAction("Import document", (Action)new ImportElementAction(false));
        actionManager.addAction("Open path", (Action)new OpenPathAction(true));
        actionManager.addAction("Save document", (Action)new SaveDocumentAction(false));
        actionManager.addAction("Save document as", (Action)new SaveAsDocumentAction(false));
        actionManager.addAction("Close document", (Action)new CloseDocumentAction(false));
        actionManager.addAction("Close all diagrams", (Action)new CloseAllDocumentAction(false));
        actionManager.addAction("Export document", (Action)new ExportDocumentAction());
        PanelManager panelManager = Application.getApplicationFrame().getPanelManager();
        actionManager.addAction("repository", (Action)new TogglePanelAction("repository", panelManager));
        actionManager.addAction("document", (Action)new TogglePanelAction("document", panelManager));
        actionManager.addAction("explorer", (Action)new TogglePanelAction("explorer", panelManager));
        actionManager.addAction("editor", (Action)new TogglePanelAction("editor", panelManager));
        actionManager.addAction("New Data Element", (Action)new NewDataElementAction());
        actionManager.addAction("Remove Data Element", (Action)new RemoveDataElementAction());
        actionManager.addAction("Import Image Data Element", (Action)new ImportImageDataElementAction());
        actionManager.addAction("About", (Action)new AboutAction());
        actionManager.addAction("Help", (Action)new HelpAction("introduction"));
        Object action = new PrintAction(){

            public void actionPerformed(ActionEvent e) {
                Document activeDocument = Document.getActiveDocument();
                if (activeDocument != null) {
                    ViewPane viewPane = activeDocument instanceof DiagramDocument ? ((DiagramDocument)activeDocument).getDiagramViewPane() : activeDocument.getViewPane();
                    PrintManager.getPrintManager().print(viewPane.getContent());
                }
            }
        };
        action.setEnabled(false);
        actionManager.addAction("Print diagram", (Action)action);
        action = new PrintPreviewAction(){

            public void actionPerformed(ActionEvent e) {
                Document activeDocument = Document.getActiveDocument();
                if (activeDocument != null) {
                    ViewPane viewPane = activeDocument instanceof DiagramDocument ? ((DiagramDocument)activeDocument).getDiagramViewPane() : activeDocument.getViewPane();
                    viewPane.resetScrollBars();
                    PrintManager.getPrintManager().preview(viewPane.getContent());
                }
            }
        };
        action.setEnabled(false);
        actionManager.addAction("Print preview", (Action)action);
        actionManager.addAction("Print setup", (Action)new PrintSetupAction());
        actionManager.initActions(new Class[]{MessageBundle.class});
    }

    protected void initToolbar() {
        this.toolBar.addAction("New diagram");
        this.toolBar.addAction("Save document");
        this.toolBar.addAction("Close document");
        this.toolBar.addSeparator(1);
        this.toolBar.addAction("Print diagram");
        this.toolBar.addAction("Print preview");
        this.toolBar.addAction("Print setup");
        this.toolBar.addSeparator(3);
        this.toolBar.addSeparator(4);
        this.fillToolbarPaneActions();
        this.toolBar.addAction("Preferences");
        this.toolBar.addSeparator(5);
        AboutAction.setStartupPluginName((String)Application.getGlobalValue((String)"StartupPlugin", (String)"biouml.workbench"));
        this.toolBar.addAction("About");
        this.toolBar.addSeparator(6);
        this.fillToolbarJournalPane();
        this.fillToolbarPerspectivePane();
    }

    private void fillToolbarPerspectivePane() {
        if (PerspectiveRegistry.perspectives().count() <= 1L) {
            return;
        }
        JPanel perspectivePanel = new JPanel();
        JComboBox perspectivesBox = new JComboBox();
        PerspectiveRegistry.perspectives().map(Perspective::getTitle).forEach(perspectivesBox::addItem);
        perspectivesBox.setSelectedItem(PerspectiveUI.getCurrentPerspective().toString());
        perspectivesBox.addActionListener(e -> Application.getPreferences().setValue("Perspective", perspectivesBox.getSelectedItem()));
        perspectivePanel.add(new JLabel(BioUMLApplication.getMessageBundle().getResourceString("PERSPECTIVE_PROMPT")));
        perspectivePanel.add(perspectivesBox);
        this.toolBar.add((Component)perspectivePanel);
    }

    protected void fillToolbarPaneActions() {
        ActionManager actionManager = Application.getActionManager();
        Action action = null;
        action = actionManager.getAction("repository");
        this.toolBar.addToggleButtonAt(action, 4, true);
        action = actionManager.getAction("document");
        this.toolBar.addToggleButtonAt(action, 4, true);
        action = actionManager.getAction("explorer");
        this.toolBar.addToggleButtonAt(action, 4, true);
        action = actionManager.getAction("editor");
        this.toolBar.addToggleButtonAt(action, 4, true);
    }

    protected void fillToolbarJournalPane() {
        JPanel rightPanel = new JPanel(new BorderLayout());
        String[] journalNames = JournalRegistry.getJournalNames();
        if (journalNames != null) {
            JPanel journalPanel = new JPanel();
            journalPanel.add(new JLabel(BioUMLApplication.getMessageBundle().getResourceString("JOURNAL_USE")));
            JCheckBox useJournalBox = new JCheckBox();
            useJournalBox.setSelected(true);
            useJournalBox.addChangeListener(e -> JournalRegistry.setJournalUse((boolean)useJournalBox.isSelected()));
            journalPanel.add(useJournalBox);
            journalPanel.add(new JLabel(BioUMLApplication.getMessageBundle().getResourceString("JOURNAL_NAME")));
            this.journalBox = new JComboBox();
            this.updateJournalBox(journalNames);
            JournalRegistry.setCurrentJournal((String)((String)this.journalBox.getSelectedItem()));
            this.journalBox.addActionListener(e -> {
                if ("comboBoxChanged".equals(e.getActionCommand())) {
                    String selectedJournal = (String)this.journalBox.getSelectedItem();
                    JournalRegistry.setCurrentJournal((String)selectedJournal);
                }
            });
            journalPanel.add(this.journalBox);
            rightPanel.add((Component)journalPanel, "East");
        }
        this.toolBar.add((Component)rightPanel);
    }

    public void updateJournalBox(String[] journalNames) {
        if (this.journalBox != null && journalNames != null) {
            this.journalBox.removeAllItems();
            for (String journalName : journalNames) {
                this.journalBox.addItem(journalName);
            }
            String currentJournal = JournalProperties.getCurrentJournal();
            if (currentJournal != null) {
                this.journalBox.setSelectedItem(currentJournal);
            }
        }
    }

    protected void initMenubar() {
        ActionManager actionManager = Application.getActionManager();
        Action action = null;
        try {
            OpenSetupWizardAction wizardAction = (OpenSetupWizardAction)actionManager.getAction("Setup wizard");
            URL logoURL = this.getClass().getClassLoader().getResource(SETUP_WIZARD_LOGO);
            wizardAction.init(WizardPageRegistry.getWizardPages(), BioUMLApplication.getMessageBundle().getResourceString("SETUP_WIZARD_TITLE"), SetupWizardSupport.getSetupPreferences(), (Icon)new ImageIcon(logoURL));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not init setup wizard properties", e);
        }
        HashSet<String> topNames = new HashSet<String>();
        ApplicationMenu fileMenu = new ApplicationMenu(BioUMLApplication.getMessageBundle().getResourceString("MENU_FILE"));
        fileMenu.addAction("New diagram");
        fileMenu.addSeparator();
        fileMenu.addAction("Close document");
        fileMenu.addAction("Close all diagrams");
        fileMenu.addSeparator();
        fileMenu.addAction("Open path");
        fileMenu.addAction("Save document");
        fileMenu.addAction("Save document as");
        fileMenu.addAction("Export document");
        fileMenu.addAction("Import document");
        fileMenu.addSeparator();
        fileMenu.addAction("Login");
        fileMenu.addAction("Register");
        fileMenu.addAction("Logout");
        fileMenu.addSeparator();
        fileMenu.addAction("Setup wizard");
        fileMenu.addSeparator();
        fileMenu.addAction("Print diagram");
        fileMenu.addAction("Print preview");
        fileMenu.addAction("Print setup");
        BioUMLApplication.initExtendedMenuItems(fileMenu, actionManager, true);
        action = actionManager.getAction("Export module");
        DataCollection dc = null;
        try {
            dc = CollectionFactoryUtils.getDatabases();
        }
        catch (Exception exception) {
            // empty catch block
        }
        action.setEnabled(dc != null && dc.getSize() != 0);
        this.menuBar.add((JMenu)fileMenu);
        topNames.add(fileMenu.getText());
        DiagramDocument.getActionsByStaticWay(Document.ActionType.MENU_ACTION);
        ApplicationMenu moduleMenu = BioUMLApplication.createDatabasesMenu();
        this.menuBar.add((JMenu)moduleMenu);
        topNames.add(moduleMenu.getText());
        for (MenuItemRegistry.ItemInfo info : MenuItemRegistry.getMenuItems()) {
            String parent = info.getParent();
            if (topNames.contains(parent)) continue;
            ApplicationMenu newMenu = new ApplicationMenu(parent);
            BioUMLApplication.initExtendedMenuItems(newMenu, actionManager, false);
            this.menuBar.add((JMenu)newMenu);
            topNames.add(newMenu.getText());
        }
        ApplicationMenu helpMenu = new ApplicationMenu(BioUMLApplication.getMessageBundle().getResourceString("MENU_HELP"));
        helpMenu.addAction(actionManager.getAction("Help"));
        helpMenu.addAction(actionManager.getAction("About"));
        this.menuBar.add((JMenu)helpMenu);
    }

    public static ApplicationMenu createDatabasesMenu() {
        ApplicationMenu moduleMenu = new ApplicationMenu(BioUMLApplication.getMessageBundle().getResourceString("MENU_DATABASE"));
        moduleMenu.addAction("New module");
        moduleMenu.addAction("New composite database");
        moduleMenu.addSeparator();
        moduleMenu.addAction("Module Setup");
        moduleMenu.addAction("Export module");
        BioUMLApplication.initExtendedMenuItems(moduleMenu, Application.getActionManager(), true);
        return moduleMenu;
    }

    public static void initExtendedMenuItems(ApplicationMenu menu, ActionManager actionManager, boolean needSeparator) {
        boolean isFirst = needSeparator;
        for (MenuItemRegistry.ItemInfo info : MenuItemRegistry.getMenuItems()) {
            try {
                if (!info.getParent().equals(menu.getText())) continue;
                if (isFirst) {
                    menu.addSeparator();
                    isFirst = false;
                }
                Action action = info.getAction();
                try {
                    Class<?> bundle = action.getClass().getClassLoader().loadClass(action.getClass().getPackage().getName() + ".MessageBundle");
                    ActionInitializer initializer = new ActionInitializer(new Class[]{bundle});
                    initializer.initAction(action);
                }
                catch (ClassNotFoundException e) {
                    log.info("No message bundle defined for action " + action.getClass().getName());
                }
                actionManager.addAction(info.getTitle(), action);
                menu.addAction(info.getTitle());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, ExceptionRegistry.log((Throwable)e));
            }
        }
    }

    protected void initPanels() {
        try {
            RepositoryTabs repositoryTabs = new RepositoryTabs();
            RepositoryDocument repositoryDocument = new RepositoryDocument(this, (Component)repositoryTabs);
            RepositoryDocument.RepositoryUndoListener repositoryUndoListener = new RepositoryDocument.RepositoryUndoListener(repositoryDocument);
            PluginActions actionsProvider = new PluginActions();
            repositoryTabs.setActionsProvider((ActionsProvider)actionsProvider);
            repositoryTabs.addListener((RepositoryListener)actionsProvider);
            CollectionFactoryUtils.getDatabases().addDataCollectionListener((DataCollectionListener)repositoryUndoListener);
            repositoryTabs.addListener((RepositoryListener)repositoryDocument);
            repositoryTabs.addListener((RepositoryListener)new ModuleHandler());
            PanelInfo repositoryPanelInfo = new PanelInfo("repository", (JComponent)repositoryTabs, true, null);
            this.panelManager.addPanel(repositoryPanelInfo, null, 0);
            ExplorerPane explorerPane = new ExplorerPane();
            explorerPane.getPropertiesView().setPropertyShowMode(0);
            explorerPane.setModelActionProvider((ActionsProvider)actionsProvider);
            PanelInfo explorerPaneInfo = new PanelInfo("explorer", (JComponent)explorerPane, true, null);
            this.panelManager.addPanel(explorerPaneInfo, "repository", 4, 400);
            PluggedEditorsTabbedPane editorsPane = new PluggedEditorsTabbedPane();
            explorerPane.addViewPart(editorsPane.getEditorsManager(), true);
            PanelInfo editorsPaneInfo = new PanelInfo("editor", (JComponent)editorsPane, true, null);
            this.panelManager.addPanel(editorsPaneInfo, "explorer", 2, 500);
            DocumentsPane documentsPane = new DocumentsPane();
            PanelInfo documentsPaneInfo = new PanelInfo("document", (JComponent)documentsPane, true, null);
            this.panelManager.addPanel(documentsPaneInfo, "repository", 2, 300);
            DocumentManager manager = (DocumentManager)this.getDocumentManager();
            manager.registerEditorPart((ViewPart)explorerPane);
            manager.registerEditorPart((ViewPart)editorsPane);
            manager.setActiveDocument(null);
        }
        catch (Exception t) {
            log.log(Level.SEVERE, "Error during init panels", t);
        }
    }

    public void saveDocument() {
        Document document = Document.getCurrentDocument();
        if (document == null) {
            return;
        }
        BioUMLApplication.saveDocument(document);
    }

    public static void saveDocument(Document document) {
        if (document.getModel() instanceof DataElement && HistoryFacade.needComment((DataElement)((DataElement)document.getModel()))) {
            String message = messageBundle.getString("COMMENT_INPUT");
            String comment = JOptionPane.showInputDialog((Component)Application.getApplicationFrame(), (Object)message);
            if (comment != null) {
                HistoryFacade.addComment((DataElement)((DataElement)document.getModel()), (String)comment);
            }
        }
        document.save();
        document.update();
    }

    public boolean closeApplication() {
        try {
            Document document = null;
            while ((document = GUI.getManager().getCurrentDocument()) != null) {
                if (!this.askSaveConfirmation(document)) {
                    GUI.getManager().removeDocument(document);
                    continue;
                }
                if (BioUMLApplication.saveDocumentConfirmDialog()) continue;
                return false;
            }
            if (TaskManager.getInstance().hasIncompleteTasks()) {
                if (BioUMLApplication.closeTasksConfirmDialog()) {
                    TaskManager.getInstance().stopAllTasks();
                } else {
                    return false;
                }
            }
            Plugins.getPlugins().close();
            Framework.closeRepositories();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, t.getMessage(), t);
        }
        return true;
    }

    protected static boolean saveDocumentConfirmDialog() {
        Document document = GUI.getManager().getCurrentDocument();
        if (!document.isChanged() || BioUMLApplication.saveDocumentConfirmDialog(document, document.getDisplayName())) {
            GUI.getManager().removeDocument(document);
            return true;
        }
        return false;
    }

    public static boolean saveDocumentConfirmDialog(Document document, String name) {
        String title = BioUMLApplication.getMessageBundle().getResourceString("CLOSE_CONFIRM_TITLE");
        if (document.isMutable()) {
            String message = MessageFormat.format(BioUMLApplication.getMessageBundle().getResourceString("CLOSE_CONFIRM_MESSAGE"), name);
            int answer = JOptionPane.showConfirmDialog((Component)Application.getApplicationFrame(), message, title, 1);
            switch (answer) {
                case 0: {
                    BioUMLApplication.saveDocument(document);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return false;
                }
            }
        } else {
            String message = MessageFormat.format(BioUMLApplication.getMessageBundle().getResourceString("CLOSE_CONFIRM_MESSAGE_2"), name);
            int answer = JOptionPane.showConfirmDialog((Component)Application.getApplicationFrame(), message, title, 0);
            switch (answer) {
                case 0: {
                    break;
                }
                case 1: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean closeTasksConfirmDialog() {
        String title = BioUMLApplication.getMessageBundle().getResourceString("CLOSE_CONFIRM_TITLE");
        String message = BioUMLApplication.getMessageBundle().getResourceString("CLOSE_CONFIRM_TASKS");
        int answer = JOptionPane.showConfirmDialog((Component)Application.getApplicationFrame(), message, title, 0);
        return answer == 0;
    }

    public void closeCurrentDocument() {
        if (BioUMLApplication.saveDocumentConfirmDialog()) {
            this.enableDocumentActions(!GUI.getManager().getDocuments().isEmpty());
            this.stateChanged(null);
        }
    }

    public void enableDocumentActions(boolean flag) {
        Application.getActionManager().enableActions(flag, new String[]{"Close document", "Close all diagrams", "Save document as", "Export document"});
        this.enableSaveDocumentActions(flag);
    }

    protected void enableSaveDocumentActions(boolean flag) {
        Application.getActionManager().enableActions(flag, new String[]{"Save document"});
    }

    public void updateSelection(ViewPane viewPane) {
        this.accessProvider.updateSelection(viewPane);
    }

    public ViewPaneListener getDocumentViewListener() {
        return this.accessProvider.getDocumentViewListener();
    }

    public static MessageBundle getMessageBundle() {
        return messageBundle;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.enableDocumentActions(!GUI.getManager().getDocuments().isEmpty());
        boolean diagramSaveActionsEnabled = false;
        Document document = GUI.getManager().getCurrentDocument();
        if (document != null && document.isMutable()) {
            diagramSaveActionsEnabled = true;
        }
        if (document != null && !document.getUndoManager().canUndo()) {
            diagramSaveActionsEnabled = false;
        }
        this.enableSaveDocumentActions(diagramSaveActionsEnabled);
    }

    public boolean saveDocumentCurrentApplicationConfirmDialog(Document document, String displayName) {
        return BioUMLApplication.saveDocumentConfirmDialog(document, displayName);
    }

    public boolean askSaveConfirmation(Document doc) {
        return this.accessProvider.askSaveConfirmation(doc);
    }

    protected void login() {
        LoginDialog loginDialog;
        if (SingleSignOnSupport.isSSOUsed() && (loginDialog = new LoginDialog((Component)((Object)this), "Login", "<html>Enter username and password to<br> login or click Cancel otherwise")).doModal()) {
            if (SingleSignOnSupport.login((String)loginDialog.getUsername(), (String)loginDialog.getPassword())) {
                Application.getActionManager().enableActions(false, new String[]{"Login", "Register"});
                Application.getActionManager().enableActions(true, new String[]{"Logout"});
            } else {
                ApplicationUtils.errorBox((String)"Login failed", (String)"Incorrect user name or password");
                this.login();
            }
        }
    }

    public static void showSetupWizard() {
        try {
            Preferences setupPreferences = SetupWizardSupport.getSetupPreferences();
            if (SetupWizardSupport.isActive()) {
                URL logoURL = BioUMLApplication.class.getClassLoader().getResource(SETUP_WIZARD_LOGO);
                SetupWizardDialog wizard = new SetupWizardDialog((Component)Application.getApplicationFrame(), WizardPageRegistry.getWizardPages(), BioUMLApplication.getMessageBundle().getResourceString("SETUP_WIZARD_TITLE"), setupPreferences, (Icon)new ImageIcon(logoURL));
                wizard.showWizard();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not init setup wizard preferences", e);
        }
    }

    private static class ModuleHandler
    implements RepositoryListener {
        private ModuleHandler() {
        }

        public void nodeClicked(DataElement node, int clickCount) {
            if (node != null) {
                Module module = Module.optModule(node);
                boolean enable = false;
                if (node instanceof Module || module != null) {
                    enable = true;
                }
                Application.getActionManager().enableActions(enable, new String[]{"Import document"});
            }
        }

        public void selectionChanged(DataElement node) {
        }
    }
}

