/*
 * Decompiled with CFR 0.152.
 */
package biouml.workbench;

import biouml.workbench.BioUMLApplication;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationFrame;
import com.developmentontheedge.application.DocumentFactory;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import ru.biosoft.access.repository.PluginActions;
import ru.biosoft.gui.Document;
import ru.biosoft.gui.DocumentManager;

public class ActionsInfoBuilder
implements IApplication {
    public Object start(IApplicationContext arg0) {
        try {
            File configFile = new File("biouml.lcf");
            try (FileInputStream fis = new FileInputStream(configFile);){
                LogManager.getLogManager().readConfiguration(fis);
            }
            catch (Exception e1) {
                Logger.getGlobal().log(Level.SEVERE, "Error init logging", e1);
            }
            Object appArgs = arg0.getArguments().get("application.args");
            if (!(appArgs instanceof String[])) {
                if (appArgs == null) {
                    appArgs = "null";
                }
                System.out.println("Can not start: incorrect input application arguments (" + appArgs + ")");
                return IApplication.EXIT_OK;
            }
            String[] args = (String[])appArgs;
            System.out.println("-----------------------------");
            if (args.length < 1) {
                System.out.println("Missing output folder name");
            } else {
                this.exportActions(args[0]);
            }
            System.out.println("-----------------------------");
        }
        catch (Throwable t) {
            System.err.println("Can not start action exporter: " + t);
            t.printStackTrace();
            System.out.println("\nPress any key to continue");
            try {
                System.in.read();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }

    protected void exportActions(String folderName) throws Exception {
        File folder = new File(folderName);
        folder.delete();
        folder.mkdirs();
        try (PrintWriter pw = new PrintWriter(new File(folder, "index.html"));){
            BioUMLApplication applicationFrame = new BioUMLApplication(null, new String[0]);
            applicationFrame.setVisible(false);
            this.initRepositoryActions();
            this.initDocumentsActions(applicationFrame);
            Hashtable actions = Application.getActionManager().getActions();
            System.out.println("Actions size: " + actions.size());
            System.out.println("Writing to " + folderName + " ...");
            this.printActions(pw, folder, actions);
        }
    }

    protected void initRepositoryActions() {
        new PluginActions().getActions(new Object());
    }

    protected void initDocumentsActions(ApplicationFrame applicationFrame) {
        com.developmentontheedge.application.DocumentManager documentManager = applicationFrame.getDocumentManager();
        if (documentManager instanceof DocumentManager) {
            ((DocumentManager)documentManager).documentFactories().map(DocumentFactory::createDocument).select(Document.class).forEach(ad -> ad.getActions(null));
        }
    }

    protected void printActions(PrintWriter pw, File images, Hashtable<String, Action> actions) throws Exception {
        pw.println("<html>");
        pw.println("<body>");
        pw.println("<table border=1>");
        pw.println("<tr><th></th><th>Key</th><th>Icon</th><th>Short description</th><th>Full description</th></tr>");
        int ind = 1;
        for (Map.Entry<String, Action> entry : actions.entrySet()) {
            String name = entry.getKey();
            Action action = entry.getValue();
            Object icon = action.getValue("SmallIcon");
            String iconStr = "";
            if (icon instanceof ImageIcon) {
                ImageIcon imageIcon = (ImageIcon)icon;
                Image image = imageIcon.getImage();
                RenderedImage rendered = null;
                if (image instanceof RenderedImage) {
                    rendered = (RenderedImage)((Object)image);
                } else {
                    BufferedImage buffered = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
                    Graphics2D g = buffered.createGraphics();
                    g.drawImage(image, 0, 0, null);
                    g.dispose();
                    rendered = buffered;
                }
                ImageIO.write(rendered, "PNG", new File(images, name + ".png"));
                iconStr = "<img src='" + name + ".png'/>";
            }
            pw.println("<tr>");
            pw.println("<td>" + ind++ + "</td>");
            pw.println("<td>" + name + "</td>");
            pw.println("<td>" + iconStr + "</td>");
            pw.println("<td>" + action.getValue("ShortDescription") + "</td>");
            pw.println("<td>" + action.getValue("LongDescription") + "</td>");
            pw.println("</tr>");
        }
        pw.println("</table>");
        pw.println("</body>");
        pw.println("</html>");
    }
}

