/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type.access;

import biouml.standard.type.access.TitleIndex;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import ru.biosoft.access.SqlDataCollection;
import ru.biosoft.access.SqlTransformer;
import ru.biosoft.access.SqlTransformerSupport;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.sql.SqlConnectionHolder;

public class TitleSqlIndex
extends TitleIndex {
    public static final String INDEX_TITLE_TABLE = "index.title.table";
    public static final String INDEX_TITLE_QUERY = "index.title.query";

    public TitleSqlIndex(DataCollection<?> dc, String indexName) throws Exception {
        super(dc, indexName);
    }

    protected String makeQuery(DataCollection<?> dc) throws Exception {
        SqlTransformer transformer;
        String table = dc.getInfo().getProperty(INDEX_TITLE_TABLE);
        String query = dc.getInfo().getProperty(INDEX_TITLE_QUERY);
        if (table == null && query == null && dc instanceof SqlDataCollection && (transformer = ((SqlDataCollection)dc).getTransformer()) instanceof SqlTransformerSupport) {
            table = ((SqlTransformerSupport)transformer).getTable();
        }
        if (table == null && query == null) {
            throw new Exception("Table name is missing (not specified in config file).");
        }
        if (query == null) {
            query = "SELECT id, title FROM " + table;
        }
        return query;
    }

    protected String sanitizeTitle(String title) {
        return title;
    }

    @Override
    protected void doInit() throws Exception {
        if (!(this.dc instanceof SqlConnectionHolder)) {
            super.doInit();
        } else {
            SqlConnectionHolder sqlDC = (SqlConnectionHolder)this.dc;
            Connection connection = sqlDC.getConnection();
            ArrayList<String> strings = new ArrayList<String>();
            HashSet<String> titles = new HashSet<String>();
            try (Statement statement = connection.createStatement();
                 ResultSet rs = statement.executeQuery(this.makeQuery(this.dc));){
                while (rs.next()) {
                    String id = rs.getString(1);
                    strings.add(id);
                    String title = this.sanitizeTitle(rs.getString(2));
                    if (titles.contains(title)) {
                        title = TitleSqlIndex.getCompositeName(title, id);
                    }
                    strings.add(title);
                    titles.add(title);
                }
                rs.close();
            }
            for (List slide : StreamEx.ofSubLists(strings, (int)2)) {
                this.id2title.put(slide.get(0), slide.get(1));
                this.title2id.put(slide.get(1), slide.get(0));
            }
        }
    }
}

