/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type.access;

import biouml.standard.type.Base;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import one.util.streamex.EntryStream;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataCollectionVetoException;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.Index;
import ru.biosoft.access.core.Key;
import ru.biosoft.access.exception.IndexCreateException;
import ru.biosoft.exception.ExceptionRegistry;

public class TitleIndex
extends DefaultComboBoxModel<String>
implements DataCollectionListener,
Index<String> {
    public static final String INDEX_TITLE = "index.title";
    public static final String INDEX_TITLE_PROPERTY = "index.title.property";
    protected static final Logger log = Logger.getLogger(TitleIndex.class.getName());
    protected String indexName;
    protected Method methodGetTitle;
    protected DataCollection<?> dc;
    private volatile boolean init;
    protected Map<String, String> id2title = new HashMap<String, String>();
    protected Map<String, String> title2id = new HashMap<String, String>();
    private final Vector<String> constraintTitle = new Vector();
    private String constraint;
    private boolean valid = false;
    private String id;
    private String title;
    private boolean elementWillRemove = false;

    public TitleIndex(DataCollection<?> dc, String indexName) throws Exception {
        this.indexName = indexName;
        this.dc = dc;
        String property = dc.getInfo().getProperty(INDEX_TITLE_PROPERTY);
        if (property != null) {
            try {
                this.methodGetTitle = dc.getDataElementType().getMethod("get" + Character.toUpperCase(property.charAt(0)) + property.substring(1), new Class[0]);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not init method to get title, property=" + property + ", data element type=" + dc.getDataElementType() + ", error=" + e, e);
            }
        }
        dc.addDataCollectionListener((DataCollectionListener)this);
    }

    public DataCollection<?> getOwner() {
        return this.dc;
    }

    public String getTitle(DataElement de) {
        if (this.methodGetTitle != null) {
            try {
                return (String)this.methodGetTitle.invoke((Object)de, new Object[0]);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not get title for data element: name=" + de.getName() + ", error=" + e, e);
            }
        }
        if (de instanceof Base) {
            return ((Base)de).getTitle();
        }
        return de.getName();
    }

    protected void doInit() throws Exception {
        if (this.dc == null) {
            return;
        }
        for (DataElement de : this.dc) {
            this.putInternal(de.getName(), this.getTitle(de));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (!this.init) {
            TitleIndex titleIndex = this;
            synchronized (titleIndex) {
                if (!this.init) {
                    try {
                        this.doInit();
                    }
                    catch (Throwable t) {
                        ExceptionRegistry.log((Throwable)new IndexCreateException(t, this));
                    }
                    this.init = true;
                }
            }
        }
    }

    public String getName() {
        return this.indexName;
    }

    public void setConstraint(String constraint) {
        this.init();
        if (this.constraint != null && !this.constraint.equals(constraint)) {
            this.valid = false;
            this.constraint = constraint;
        } else if (this.constraint == null && constraint != null && constraint.length() != 0) {
            this.valid = false;
            this.constraint = constraint;
        }
    }

    public static String getCompositeName(Object title, Object id) {
        if (((String)title).length() > 30) {
            title = ((String)title).substring(0, 30) + "...";
        }
        return "" + title + " (" + id + ")";
    }

    private void validate() {
        this.init();
        if (!this.valid) {
            this.constraintTitle.clear();
            Comparator comparator = String.CASE_INSENSITIVE_ORDER;
            for (String title : this.title2id.keySet()) {
                int index;
                boolean add = true;
                if (this.constraint != null && this.constraint.trim().length() > 0 && !title.toLowerCase().startsWith(this.constraint.toLowerCase())) {
                    add = false;
                }
                if (!add || (index = Collections.binarySearch(this.constraintTitle, title, comparator)) >= 0) continue;
                this.constraintTitle.add(-index - 1, title);
            }
            this.valid = true;
        }
    }

    public Iterator nodeIterator(Key key) {
        throw new UnsupportedOperationException("Method nodeIterator() not yet implemented.");
    }

    public boolean isValid() {
        return true;
    }

    public File getIndexFile() {
        return null;
    }

    public void close() throws Exception {
        this.dc.removeDataCollectionListener((DataCollectionListener)this);
    }

    @Override
    public int getSize() {
        this.validate();
        return this.constraintTitle.size();
    }

    @Override
    public String getElementAt(int index) {
        this.validate();
        return this.constraintTitle.get(index);
    }

    public void elementWillAdd(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
    }

    public void elementAdded(DataCollectionEvent e) throws Exception {
        try {
            DataElement de = e.getDataElement();
            if (de != null) {
                this.id = de.getName();
                this.title = this.getTitle(de);
                this.put(de.getName(), this.getTitle(de));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void elementWillRemove(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
        try {
            DataElement de = e.getDataElement();
            if (de != null) {
                this.id = de.getName();
                this.elementWillRemove = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void elementRemoved(DataCollectionEvent e) throws Exception {
        if (this.elementWillRemove) {
            this.elementWillRemove = false;
            this.remove(this.id);
        }
    }

    public void elementWillChange(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
        DataElement de = e.getDataElement();
        if (de != null) {
            this.id = de.getName();
            this.title = this.getTitle(de);
        }
    }

    public void elementChanged(DataCollectionEvent e) throws Exception {
        String newTitle;
        DataElement de = e.getDataElement();
        if (de != null && de.getName().equals(this.id) && !(newTitle = this.getTitle(de)).equals(this.title)) {
            this.remove(this.id);
            this.put(this.id, newTitle);
        }
    }

    public int size() {
        this.init();
        return this.id2title.size();
    }

    public boolean isEmpty() {
        this.init();
        return this.id2title.isEmpty();
    }

    public boolean containsKey(Object id) {
        this.init();
        return this.id2title.containsKey(id);
    }

    public boolean containsValue(Object title) {
        this.init();
        return this.id2title.containsValue(title);
    }

    public String get(Object id) {
        this.init();
        return this.id2title.get(id);
    }

    public String getIdByTitle(String title) {
        this.init();
        return this.title2id.get(title);
    }

    public String remove(Object id) {
        this.init();
        String title = this.id2title.remove(id);
        if (title != null) {
            this.title2id.remove(title);
            this.valid = false;
        }
        return title;
    }

    public String put(String id, String title) {
        this.init();
        return this.putInternal(id, title);
    }

    protected String putInternal(String id, String title) {
        String oldTitle = this.id2title.remove(id);
        if (title != null) {
            this.title2id.remove(oldTitle);
        }
        if (oldTitle == null && this.title2id.containsKey(title)) {
            String newTitle = TitleIndex.getCompositeName(title, id);
            this.id2title.put(id, newTitle);
            this.title2id.put(newTitle, id);
        } else {
            this.id2title.put(id, title);
            this.title2id.put(title, id);
        }
        this.valid = false;
        return oldTitle;
    }

    public void putAll(Map<? extends String, ? extends String> map) {
        this.init();
        EntryStream.of(map).forKeyValue(this::putInternal);
    }

    public void clear() {
        this.id2title.clear();
        this.title2id.clear();
        this.init = false;
        this.valid = false;
    }

    public Set<String> keySet() {
        this.init();
        return this.id2title.keySet();
    }

    public Collection<String> values() {
        this.init();
        return this.id2title.values();
    }

    public Set<Map.Entry<String, String>> entrySet() {
        this.init();
        return this.id2title.entrySet();
    }
}

