/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type.access;

import biouml.standard.type.Structure;
import biouml.standard.type.access.ReferrerSqlTransformer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ru.biosoft.access.SqlDataCollection;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.sql.SqlConnectionHolder;

public class StructureSqlTransformer
extends ReferrerSqlTransformer<Structure> {
    public boolean init(SqlDataCollection<Structure> owner) {
        this.table = "structures";
        this.owner = owner;
        this.checkAttributesColumn((SqlConnectionHolder)owner);
        return true;
    }

    public Class<Structure> getTemplateClass() {
        return Structure.class;
    }

    public String getSelectQuery() {
        return "SELECT id, type, title, description, comment,  format, data FROM " + this.table;
    }

    @Override
    protected Structure createElement(ResultSet resultSet, Connection connection) throws SQLException {
        Structure structure = new Structure((DataCollection)this.owner, resultSet.getString(1));
        structure.setFormat(resultSet.getString(6));
        structure.setData(resultSet.getString(7));
        return structure;
    }

    @Override
    protected String getSpecificFields(Structure de) {
        return ", format, data";
    }

    @Override
    protected String[] getSpecificValues(Structure structure) {
        return new String[]{structure.getFormat(), structure.getData()};
    }

    @Override
    public void addInsertCommands(Statement statement, Structure structure) throws Exception {
        super.addInsertCommands(statement, structure);
        String[] refs = structure.getMoleculeReferences();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                statement.addBatch("INSERT INTO structureReferences (structureId, moleculeId)VALUES(" + this.validateValue(structure.getName()) + ", " + this.validateValue(refs[i].trim()) + ")");
            }
        }
    }

    @Override
    public void addDeleteCommands(Statement statement, String name) throws Exception {
        super.addDeleteCommands(statement, name);
        statement.addBatch("DELETE FROM structureReferences WHERE structureId=" + this.validateValue(name));
    }

    public String[] getUsedTables() {
        return new String[]{"dbReferences", "publicationReferences", "publications", this.table};
    }

    @Override
    public String getCreateTableQuery(String tableName) {
        if (tableName.equals(this.table)) {
            return "CREATE TABLE `structures` (" + this.getIDFieldFormat() + ",  `type` varchar(50) default ''," + this.getTitleFieldFormat() + ",  `format` varchar(10) NOT NULL default '',  `description` text,  `comment` text,  `data` text  `attributes` text,) ENGINE=MyISAM";
        }
        return super.getCreateTableQuery(tableName);
    }
}

