/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type.access;

import biouml.standard.type.Referrer;
import biouml.standard.type.Species;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import ru.biosoft.access.biohub.BioHubSupport;
import ru.biosoft.access.biohub.Element;
import ru.biosoft.access.biohub.ReferenceType;
import ru.biosoft.access.biohub.ReferenceTypeRegistry;
import ru.biosoft.access.biohub.TargetOptions;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.util.Cache;

public class StandardMatchingHub
extends BioHubSupport {
    protected final Supplier<MatchingData> cache = Cache.soft(this::createMatchingData);
    protected ReferenceType sourceType;
    protected ReferenceType targetType;
    protected final DataElementPath hubCollection;
    protected Species species;

    protected MatchingData createMatchingData() {
        MatchingData data = new MatchingData();
        String dbId = this.targetType.getMiriamId();
        StreamEx.of((Stream)this.hubCollection.getDataCollection().stream()).select(Referrer.class).mapToEntry(ref -> ref.getDatabaseReferences()).nonNullValues().flatMapValues(Arrays::stream).filterValues(dbRef -> dbRef.getDatabaseName().equals(dbId)).forKeyValue((de, dbRef) -> data.accept(de.getName(), dbRef.getAc()));
        return data;
    }

    public StandardMatchingHub(Properties properties) {
        super(properties);
        this.hubCollection = this.getModulePath().getRelativePath(properties.getProperty("collection"));
        this.sourceType = ReferenceTypeRegistry.getReferenceType((String)this.hubCollection.getDataCollection().getInfo().getProperty("referenceType"));
        this.targetType = ReferenceTypeRegistry.getReferenceType((String)properties.getProperty("target"));
        this.species = Species.getDefaultSpecies(this.getModulePath().getDataCollection());
    }

    public int getPriority(TargetOptions dbOptions) {
        return 0;
    }

    public Element[] getReference(Element startElement, TargetOptions dbOptions, String[] relationTypes, int maxLength, int direction) {
        return null;
    }

    public Map<String, String[]> getReferences(String[] inputList, ReferenceType inputType, ReferenceType outputType, Properties properties, FunctionJobControl jobControl) {
        Map<String, Set<String>> data;
        MatchingData matchingData = this.cache.get();
        if (inputType == this.sourceType && outputType == this.targetType) {
            data = matchingData.forward;
        } else if (inputType == this.targetType && outputType == this.sourceType) {
            data = matchingData.backward;
        } else {
            return Collections.emptyMap();
        }
        return StreamEx.of((Object[])inputList).mapToEntry(data::get).nonNullValues().mapValues(list -> list.toArray(new String[0])).toMap();
    }

    public Properties[] getSupportedInputs() {
        return (Properties[])StreamEx.of((Object[])new ReferenceType[]{this.sourceType, this.targetType}).map(type -> StandardMatchingHub.createProperties((Species)this.species, (ReferenceType)type)).toArray(Properties[]::new);
    }

    public Properties[] getSupportedMatching(Properties input) {
        String speciesName = input.getProperty("Species");
        if (speciesName != null && !speciesName.equals("Any species") && !this.species.getLatinName().equals(speciesName)) {
            return new Properties[0];
        }
        String type = input.getProperty("ReferenceType");
        if (type.equals(this.sourceType.toString())) {
            return new Properties[]{StandardMatchingHub.createProperties((Species)this.species, (ReferenceType)this.targetType)};
        }
        if (type.equals(this.targetType.toString())) {
            return new Properties[]{StandardMatchingHub.createProperties((Species)this.species, (ReferenceType)this.sourceType)};
        }
        return new Properties[0];
    }

    public double getMatchingQuality(Properties input, Properties output) {
        String speciesName = input.getProperty("Species");
        if (speciesName != null && !speciesName.equals("Any species") && !this.species.getLatinName().equals(speciesName)) {
            return 0.0;
        }
        speciesName = output.getProperty("Species");
        if (speciesName != null && !speciesName.equals("Any species") && !this.species.getLatinName().equals(speciesName)) {
            return 0.0;
        }
        String inputType = input.getProperty("ReferenceType");
        String outputType = output.getProperty("ReferenceType");
        if (inputType.equals(this.sourceType.toString()) && outputType.equals(this.targetType.toString()) || inputType.equals(this.targetType.toString()) && outputType.equals(this.sourceType.toString())) {
            return 1.0;
        }
        return 0.0;
    }

    protected static class MatchingData {
        Map<String, Set<String>> forward = new HashMap<String, Set<String>>();
        Map<String, Set<String>> backward = new HashMap<String, Set<String>>();

        protected MatchingData() {
        }

        public void accept(String from, String to) {
            this.forward.computeIfAbsent(from, k -> new HashSet()).add(to);
            this.backward.computeIfAbsent(to, k -> new HashSet()).add(from);
        }
    }
}

