/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type.access;

import biouml.standard.type.Species;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ru.biosoft.access.SqlTransformerSupport;
import ru.biosoft.access.core.DataCollection;

public class SpeciesSqlTransformer
extends SqlTransformerSupport<Species> {
    public SpeciesSqlTransformer() {
        this.table = "species";
    }

    public Class<Species> getTemplateClass() {
        return Species.class;
    }

    public String getSelectQuery() {
        return "SELECT id, name, abreviation, description FROM " + this.table;
    }

    public Species create(ResultSet resultSet, Connection connection) throws Exception {
        Species species = new Species((DataCollection<?>)this.owner, resultSet.getString(1));
        species.setCommonName(resultSet.getString(2));
        species.setAbbreviation(resultSet.getString(3));
        species.setDescription(resultSet.getString(4));
        return species;
    }

    public void addInsertCommands(Statement statement, Species species) throws SQLException {
        statement.addBatch("INSERT INTO " + this.table + " (id, name, abreviation, description ) VALUES(" + this.validateValue(species.getName()) + ", " + this.validateValue(species.getCommonName()) + ", " + this.validateValue(species.getAbbreviation()) + ", " + this.validateValue(species.getDescription()) + ")");
    }

    public String[] getUsedTables() {
        return new String[]{this.table};
    }

    public String getCreateTableQuery(String tableName) {
        if (tableName.equals(this.table)) {
            return "CREATE TABLE `species` (  `ID` varchar(100) NOT NULL default '',  `name` varchar(100) default NULL,  `abreviation` varchar(5) default NULL,  `description` text,  UNIQUE KEY `IDX_UNIQUE_species_ID` (`ID`)) ENGINE=MyISAM";
        }
        return super.getCreateTableQuery(tableName);
    }
}

