/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type.access;

import biouml.standard.type.BaseSupport;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Option;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.support.SerializableAsText;
import ru.biosoft.access.support.TagCommand;
import ru.biosoft.access.support.TagEntryTransformer;
import ru.biosoft.util.TextUtil;
import ru.biosoft.util.bean.StaticDescriptor;

public class SetAttributeCommand
implements TagCommand {
    public static final int DEFAULT_IDENT = 12;
    protected static final Logger log = Logger.getLogger(SetAttributeCommand.class.getName());
    private static final String endl = System.getProperty("line.separator");
    protected String tag;
    protected String propertyName;
    protected Class<?> type;
    protected PropertyDescriptor descriptor;
    protected TagEntryTransformer<? extends BaseSupport> transformer;
    protected boolean duplicateTags = true;
    protected StringBuffer value;
    protected Object[] args = new Object[1];
    protected int indent = 12;
    private String tagStrWithIndent = null;

    public SetAttributeCommand(String tag, String propertyName, Class<?> type, TagEntryTransformer<? extends BaseSupport> transformer) {
        this.tag = tag;
        this.type = type;
        this.propertyName = propertyName;
        this.transformer = transformer;
        this.descriptor = StaticDescriptor.create((String)propertyName, (String)(propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1)));
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void start(String tag) {
        this.value = new StringBuffer();
    }

    public void addValue(String appendValue) {
        if (appendValue == null || appendValue.length() == 0) {
            return;
        }
        if (this.value.length() > 0) {
            this.value.append(endl);
        }
        this.value.append(appendValue);
    }

    public void complete(String tag) {
        BaseSupport obj = (BaseSupport)this.transformer.getProcessedObject();
        try {
            DynamicProperty property = new DynamicProperty(this.descriptor, this.type, this.stringToValue(this.value.toString()));
            obj.getAttributes().add(property);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Property parsing error: " + e + "\n  tag=" + tag + ":\n  object=" + obj + ", class=" + obj.getClass(), e);
        }
    }

    public String getTag() {
        return this.tag;
    }

    public String getTaggedValue() {
        StringBuilder taggedStr = new StringBuilder();
        BaseSupport obj = (BaseSupport)this.transformer.getProcessedObject();
        String str = this.valueToString(obj.getAttributes().getValue(this.propertyName));
        if (str == null || str.isEmpty()) {
            return null;
        }
        String tagStr = this.tag + TextUtil.whiteSpace((int)(this.indent - this.tag.length()));
        String indentStr = TextUtil.whiteSpace((int)this.indent);
        try (BufferedReader reader = new BufferedReader(new StringReader(str));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                taggedStr.append(tagStr).append(line).append(endl);
                if (this.duplicateTags) continue;
                tagStr = indentStr;
            }
        }
        catch (Exception exc) {
            log.log(Level.SEVERE, "Getting tagged value error", exc);
        }
        return taggedStr.toString();
    }

    public String getTaggedValue(String value) {
        StringBuilder taggedStr;
        block16: {
            taggedStr = new StringBuilder();
            try {
                if (value != null && value.length() != 0) {
                    try (BufferedReader reader = new BufferedReader(new StringReader(value));){
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            taggedStr.append(this.getTagStrWithIndent()).append(line).append(endl);
                        }
                        break block16;
                    }
                }
                taggedStr.append(this.getTagStrWithIndent()).append(endl);
            }
            catch (Exception exc) {
                log.log(Level.SEVERE, "Getting tagged value error", exc);
            }
        }
        return taggedStr.toString();
    }

    protected Object stringToValue(String str) throws Exception {
        if (this.type == String.class) {
            return str;
        }
        if (this.type == Boolean.TYPE) {
            return str.equalsIgnoreCase("true");
        }
        if (this.type == Integer.TYPE) {
            return Integer.valueOf(str);
        }
        if (this.type == Float.TYPE) {
            return Float.valueOf(str);
        }
        if (this.type == Double.TYPE) {
            return Double.valueOf(str);
        }
        try {
            Class[] params = new Class[]{String.class};
            Class<?> t = this.type;
            if (t.isArray()) {
                t = t.getComponentType();
            }
            Constructor<?> c = t.getConstructor(params);
            this.args[0] = str;
            Object obj = c.newInstance(this.args);
            DataElement parent = this.transformer.getProcessedObject();
            if (obj instanceof Option && parent instanceof Option) {
                ((Option)obj).setParent((Option)parent);
            }
            return obj;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Can not convert string value '" + str + "' to type " + this.type, t);
            return null;
        }
    }

    protected String valueToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof SerializableAsText) {
            return ((SerializableAsText)value).getAsText();
        }
        return "" + value;
    }

    private String getTagStrWithIndent() {
        if (this.tagStrWithIndent == null) {
            this.tagStrWithIndent = this.tag + TextUtil.whiteSpace((int)(this.indent - this.tag.length()));
        }
        return this.tagStrWithIndent;
    }
}

