/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type.access;

import biouml.model.Module;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.DatabaseReference;
import biouml.standard.type.GenericEntity;
import biouml.standard.type.Publication;
import biouml.standard.type.Referrer;
import com.developmentontheedge.beans.Option;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import ru.biosoft.access.SqlTransformerSupport;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;

abstract class ReferrerSqlTransformer<T extends Referrer>
extends SqlTransformerSupport<T> {
    ReferrerSqlTransformer() {
    }

    protected abstract T createElement(ResultSet var1, Connection var2) throws SQLException;

    public T create(ResultSet resultSet, Connection connection) throws Exception {
        Throwable throwable;
        T referrer = this.createElement(resultSet, connection);
        ((BaseSupport)referrer).setTitle(resultSet.getString(3));
        ((Referrer)referrer).setDescription(resultSet.getString(4));
        ((GenericEntity)referrer).setComment(resultSet.getString(5));
        this.getAttributes(connection, referrer.getName(), ((BaseSupport)referrer).getAttributes());
        try (Statement statement = connection.createStatement();){
            throwable = null;
            try (ResultSet dbRefSet = statement.executeQuery("SELECT ref.dbInfoId, ref.dbId, ref.dbAc, ref.comment, ref.relation FROM dbReferences ref WHERE ref.entityID=" + this.validateValue(referrer.getName()) + " ORDER BY ref.dbInfoId");){
                ArrayList<DatabaseReference> dbRefs = new ArrayList<DatabaseReference>();
                while (dbRefSet.next()) {
                    DatabaseReference ref = new DatabaseReference(dbRefSet.getString(1), dbRefSet.getString(2), dbRefSet.getString(3));
                    ref.setParent((Option)referrer);
                    ref.setComment(dbRefSet.getString(4));
                    ref.setRelationshipType(dbRefSet.getString(5));
                    dbRefs.add(ref);
                }
                if (dbRefs.size() > 0) {
                    ((Referrer)referrer).setDatabaseReferences(dbRefs.toArray(new DatabaseReference[dbRefs.size()]));
                }
            }
            catch (Throwable dbRefs) {
                throwable = dbRefs;
                throw dbRefs;
            }
        }
        statement = connection.createStatement();
        var5_5 = null;
        try {
            throwable = null;
            try (ResultSet literSet = statement.executeQuery("SELECT publicationId FROM publicationReferences ref WHERE ref.entityID = " + this.validateValue(referrer.getName()) + " ORDER BY publicationId");){
                DataCollection literature = null;
                try {
                    literature = Module.getModulePath((DataElement)this.owner).getChildPath(new String[]{"Data", "literature"}).getDataCollection(Publication.class);
                }
                catch (Exception ref) {
                    // empty catch block
                }
                ArrayList<String> liter = new ArrayList<String>();
                while (literSet.next()) {
                    Publication de = null;
                    try {
                        if (literature != null) {
                            de = (Publication)literature.get(literSet.getString(1));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (de != null) {
                        liter.add(de.getName());
                        continue;
                    }
                    liter.add(literSet.getString(1));
                }
                if (liter.size() > 0) {
                    ((Referrer)referrer).setLiteratureReferences(liter.toArray(new String[liter.size()]));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var5_5 = throwable3;
            throw throwable3;
        }
        finally {
            if (statement != null) {
                if (var5_5 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable4) {
                        var5_5.addSuppressed(throwable4);
                    }
                } else {
                    statement.close();
                }
            }
        }
        return referrer;
    }

    protected abstract String getSpecificFields(T var1);

    protected abstract String[] getSpecificValues(T var1);

    public void addInsertCommands(Statement statement, T referrer) throws Exception {
        StringBuffer result = new StringBuffer("INSERT INTO " + this.table + " (id, type, title, description, comment" + this.getSpecificFields(referrer) + ") VALUES(");
        result.append(this.validateValue(referrer.getName()));
        result.append(", " + this.validateValue(((BaseSupport)referrer).getType()));
        result.append(", " + this.validateValue(((BaseSupport)referrer).getTitle()));
        result.append(", " + this.validateValue(((Referrer)referrer).getDescription()));
        result.append(", " + this.validateValue(((GenericEntity)referrer).getComment()));
        String[] values = this.getSpecificValues(referrer);
        if (values != null) {
            for (String value : values) {
                result.append(", " + this.validateValue(value));
            }
        }
        result.append(")");
        statement.addBatch(result.toString());
        this.addInsertDBRefAndPublicationsCommands(statement, (Referrer)referrer);
        this.addInsertAttributesCommand(statement, referrer.getName(), this.getAttributesString(((BaseSupport)referrer).getAttributes()));
    }

    protected void addInsertDBRefAndPublicationsCommands(Statement statement, Referrer referrer) throws Exception {
        if (referrer.getDatabaseReferences() != null) {
            for (int i = 0; i < referrer.getDatabaseReferences().length; ++i) {
                DatabaseReference ref = referrer.getDatabaseReferences()[i];
                StringBuilder buf = new StringBuilder("INSERT INTO dbReferences (entityId, dbInfoId, dbId, dbAc, comment, relation) VALUES(");
                buf.append(this.validateValue(referrer.getName()));
                buf.append(", " + this.validateValue(ref.getDatabaseName()));
                buf.append(", " + this.validateValue(ref.getId()));
                buf.append(", " + this.validateValue(ref.getAc()));
                buf.append(", " + this.validateValue(ref.getComment()));
                buf.append(", " + this.validateValue(ref.getRelationshipType()));
                buf.append(")");
                statement.addBatch(buf.toString());
            }
        }
        if (referrer.getLiteratureReferences() != null) {
            for (String ref : referrer.getLiteratureReferences()) {
                statement.addBatch("INSERT INTO publicationReferences (entityId, publicationId) VALUES(" + this.validateValue(referrer.getName()) + ", " + this.validateValue(ref) + ")");
            }
        }
    }

    public void addUpdateCommands(Statement statement, T de) throws Exception {
        this.addDeleteCommands(statement, de.getName());
        this.addInsertCommands(statement, de);
    }

    public void addDeleteCommands(Statement statement, String name) throws Exception {
        statement.addBatch("DELETE FROM " + this.table + " WHERE id='" + name + "'");
        statement.addBatch("DELETE FROM dbReferences WHERE entityId='" + name + "'");
        statement.addBatch("DELETE FROM publicationReferences WHERE entityId='" + name + "'");
    }

    public String getCreateTableQuery(String tableName) {
        if (tableName.equals("dbReferences")) {
            return "CREATE TABLE `dbReferences` (  `ID` bigint(20) unsigned NOT NULL auto_increment," + this.getIDFieldFormat("entityID") + ",  `dbInfoId` char(20) NOT NULL default '',  `dbId` char(50) NOT NULL default '',  `dbAc` char(50) default NULL,  `comment` char(250) default NULL,  `relation` char(30) default NULL,  PRIMARY KEY  (`ID`),  KEY `IDX_DBREFS_entityID` (`entityID`)) ENGINE=MyISAM";
        }
        if (tableName.equals("publicationReferences")) {
            return "CREATE TABLE `publicationReferences` (  `ID` bigint(20) unsigned NOT NULL auto_increment," + this.getIDFieldFormat("entityID") + "," + this.getIDFieldFormat("publicationId") + ",  `comment` char(250) default NULL,  PRIMARY KEY  (`ID`),  KEY `IDX_PUBREFS_entityID` (`entityID`),  KEY `IDX_PUBREFS_publicationID` (`publicationId`)) ENGINE=MyISAM";
        }
        if (tableName.equals("publications")) {
            return "CREATE TABLE `publications` (" + this.getIDFieldFormat() + ",  `ref` text,  `PMID` bigint(20) unsigned default NULL,  `authors` text," + this.getTitleFieldFormat() + ",  `source` varchar(100) default NULL, `journalTitle` varchar(100) default NULL,  `year` int(10) unsigned default NULL,  `month` varchar(10) default NULL,  `volume` int(10) unsigned default NULL,  `issue` int(10) unsigned default NULL,  `pageFrom` varchar(10) default NULL,  `pageTo` varchar(10) default NULL,  `language` char(3) default NULL,  `publicationType` varchar(50) default NULL,  `abstract` text,  `url` varchar(512) default NULL,  `importance` int(11) default '3',  `keyWords` text,  `comment` text,  `affiliation` text,  `status` varchar(30) default NULL,  PRIMARY KEY  (`ID`),  UNIQUE KEY `IDX_UNIQUE_PUBLICATIONS_ID` (`ID`)) ENGINE=MyISAM";
        }
        return super.getCreateTableQuery(tableName);
    }

    protected String getIDFieldFormat() {
        return this.getIDFieldFormat("ID");
    }

    protected String getIDFieldFormat(String idName) {
        return "  `" + idName + "` VARCHAR(100) NOT NULL";
    }

    protected String getTitleFieldFormat() {
        return "  `title` TEXT NOT NULL";
    }
}

