/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type.access;

import biouml.standard.type.KineticLaw;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import ru.biosoft.access.Entry;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.support.BeanInfoEntryTransformer;
import ru.biosoft.access.support.TagCommand;
import ru.biosoft.util.TextUtil;

public class ReactionTransformer
extends BeanInfoEntryTransformer<Reaction> {
    protected BeanInfoEntryTransformer kineticLawTransformer;
    protected BeanInfoEntryTransformer<SpecieReference> specieReferenceTransformer;

    public void init(DataCollection primaryCollection, DataCollection transformedCollection) {
        super.init(primaryCollection, transformedCollection);
        this.initCommands(this.getOutputType());
        this.kineticLawTransformer = new BeanInfoEntryTransformer();
        this.kineticLawTransformer.initCommands(KineticLaw.class);
        this.specieReferenceTransformer = new BeanInfoEntryTransformer();
        this.specieReferenceTransformer.initCommands(SpecieReference.class);
    }

    protected String readSection(BufferedReader reader) throws Exception {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null && !line.startsWith("XX")) {
            buf.append(line);
            buf.append(endl);
        }
        return buf.toString();
    }

    public synchronized Reaction transformInput(Entry input) throws Exception {
        String name;
        Reader entryReader = input.getReader();
        BufferedReader reader = null;
        reader = entryReader instanceof BufferedReader ? (BufferedReader)entryReader : new BufferedReader(entryReader);
        String str = this.readSection(reader);
        Reaction reaction = new Reaction((DataCollection<?>)this.getTransformedCollection(), input.getName());
        this.readObject(reaction, new StringReader(str));
        str = this.readSection(reader);
        KineticLaw kineticLaw = new KineticLaw(reaction);
        this.kineticLawTransformer.readObject((Object)kineticLaw, (Reader)new StringReader(str));
        reaction.setKineticLaw(kineticLaw);
        while ((str = this.readSection(reader)) != null && (name = TextUtil.getField((String)str, (String)"NM")) != null) {
            SpecieReference specieReference = new SpecieReference(reaction, name);
            int index = name.indexOf(": ");
            if (index > 0) {
                specieReference.setTitle(name.substring(index + 2));
            }
            this.specieReferenceTransformer.readObject((Object)specieReference, (Reader)new StringReader(str));
            reaction.put(specieReference);
        }
        return reaction;
    }

    public Entry transformOutput(Reaction input) throws Exception {
        this.processedObject = input;
        String startTag = this.getStartTag();
        StringWriter data = new StringWriter();
        TagCommand command = (TagCommand)this.commands.get(startTag);
        if (command == null) {
            data.write(startTag + "  " + input.getName() + endl);
        } else {
            data.write(command.getTaggedValue(input.getName()));
        }
        this.writeObject(input, data);
        data.write("XX" + endl);
        Reaction reaction = input;
        this.kineticLawTransformer.writeObject((Object)reaction.getKineticLaw(), (Writer)data);
        data.write("XX" + endl);
        Iterator<SpecieReference> iterator = reaction.iterator();
        while (iterator.hasNext()) {
            SpecieReference specieReference = iterator.next();
            data.write("NM  " + specieReference.getName() + endl);
            this.specieReferenceTransformer.writeObject((Object)specieReference, (Writer)data);
            data.write("XX" + endl);
        }
        data.write(this.getEndTag() + endl);
        return new Entry(input.getOrigin(), input.getName(), data.toString());
    }
}

