/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type.access;

import biouml.standard.type.RNA;
import biouml.standard.type.access.BiopolymerSqlTransformer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.biosoft.access.SqlDataCollection;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.sql.SqlConnectionHolder;

public class RNASqlTransformer
extends BiopolymerSqlTransformer<RNA> {
    @Override
    public boolean init(SqlDataCollection<RNA> owner) {
        this.table = "rnas";
        this.owner = owner;
        this.checkAttributesColumn((SqlConnectionHolder)owner);
        return true;
    }

    @Override
    public Class<RNA> getTemplateClass() {
        return RNA.class;
    }

    @Override
    public String getSelectQuery() {
        return "SELECT id, type, title, description, comment, completeName, speciesId, geneId, rnaType FROM " + this.table;
    }

    @Override
    protected RNA createElement(ResultSet resultSet, Connection connection) throws SQLException {
        RNA rna = new RNA((DataCollection)this.owner, resultSet.getString(1));
        rna.setCompleteName(resultSet.getString(6));
        rna.setSpecies(resultSet.getString(7));
        rna.setGene(resultSet.getString(8));
        rna.setRnaType(resultSet.getString(9));
        return rna;
    }

    @Override
    protected String getSpecificFields(RNA rna) {
        return ", geneId, rnaType";
    }

    @Override
    protected String[] getSpecificValues(RNA rna) {
        return new String[]{rna.getGene(), rna.getRnaType()};
    }

    @Override
    public String[] getUsedTables() {
        return new String[]{"dbReferences", "publicationReferences", "publications", "synonyms", "structure2molecule", this.table};
    }

    @Override
    public String getCreateTableQuery(String tableName) {
        if (tableName.equals(this.table)) {
            return "CREATE TABLE `rnas` (" + this.getIDFieldFormat() + ",  `type` enum('unknown','semantic-concept','semantic-concept-function','semantic-concept-process','semantic-concept-state','molecule','molecule-gene','molecule-RNA','molecule-protein','molecule-substance','compartment','compartment-cell','reaction','relation','relation-semantic','relation-chemical','info-database','info-diagram','info-relation-type','info-species','info-unit','constant') NOT NULL default 'molecule-RNA'," + this.getTitleFieldFormat() + ",  `completeName` varchar(200) default NULL,  `description` text,  `comment` text,  `speciesID` varchar(50) default NULL,  `geneID` varchar(100) default NULL,  `rnaType` varchar(100) default NULL,  `attributes` text,  UNIQUE KEY `IDX_UNIQUE_rnas_ID` (`ID`)) ENGINE=MyISAM";
        }
        return super.getCreateTableQuery(tableName);
    }
}

