/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type.access;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramType;
import biouml.model.Module;
import biouml.model.util.DiagramXmlReader;
import biouml.model.util.DiagramXmlWriter;
import biouml.model.util.ImageGenerator;
import biouml.standard.type.DiagramInfo;
import biouml.standard.type.access.ReferrerSqlTransformer;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.access.SqlDataCollection;
import ru.biosoft.access.SqlTransformerSupport;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.sql.SqlConnectionHolder;

public class DiagramSqlTransformer
extends SqlTransformerSupport<Diagram> {
    private final ReferrerSqlTransformer<DiagramInfo> diagramInfoTransformer = new ReferrerSqlTransformer<DiagramInfo>(){

        public boolean init(SqlDataCollection<DiagramInfo> owner) {
            this.table = "diagrams";
            this.owner = owner;
            this.checkAttributesColumn((SqlConnectionHolder)owner);
            return true;
        }

        public Class<DiagramInfo> getTemplateClass() {
            return DiagramInfo.class;
        }

        @Override
        protected DiagramInfo createElement(ResultSet resultSet, Connection connection) throws SQLException {
            return new DiagramInfo((DataCollection)this.owner, resultSet.getString(1));
        }

        @Override
        protected String getSpecificFields(DiagramInfo de) {
            return " ";
        }

        @Override
        protected String[] getSpecificValues(DiagramInfo de) {
            return null;
        }
    };
    protected Logger log = Logger.getLogger(DiagramSqlTransformer.class.getName());

    public boolean init(SqlDataCollection<Diagram> owner) {
        this.table = "diagrams";
        this.owner = owner;
        this.checkAttributesColumn((SqlConnectionHolder)owner);
        this.diagramInfoTransformer.init(owner);
        return true;
    }

    public Class<Diagram> getTemplateClass() {
        return Diagram.class;
    }

    public String getSelectQuery() {
        return "SELECT id, type, title, description, comment, xml FROM " + this.table;
    }

    public Diagram create(ResultSet resultSet, Connection connection) throws Exception {
        DiagramInfo info = (DiagramInfo)this.diagramInfoTransformer.create(resultSet, connection);
        String xml = resultSet.getString(6);
        String name = resultSet.getString(1);
        Diagram diagram = null;
        Module module = Module.optModule((DataElement)this.owner);
        if (xml != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            diagram = DiagramXmlReader.readDiagram(info.getName(), is, info, (DataCollection)this.owner, module);
        }
        if (diagram == null) {
            this.log.info("Create new diagram");
            DiagramType diagramType = module.getType().getDiagramTypeObjects().findFirst().orElse(null);
            if (diagramType != null) {
                diagram = diagramType.createDiagram(module.getDiagrams(), name, null);
            } else {
                this.log.log(Level.SEVERE, "There is no available DiagramType for this database");
            }
        }
        return diagram;
    }

    protected void updateXmlValue(Diagram diagram) throws Exception {
        try {
            String sql = "UPDATE " + this.table + " SET  xml = ? , image = ?, map = ? WHERE ID=" + this.validateValue(diagram.getName());
            Connection connection = this.getConnection();
            try (PreparedStatement pstmt = connection.prepareStatement(sql);){
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DiagramXmlWriter writer = new DiagramXmlWriter(out);
                writer.write(diagram);
                byte[] xmlBytes = out.toString().getBytes(StandardCharsets.UTF_8);
                ByteArrayInputStream xmlStream = new ByteArrayInputStream(xmlBytes);
                pstmt.setBinaryStream(1, (InputStream)xmlStream, xmlBytes.length);
                out = new ByteArrayOutputStream();
                BufferedImage image = ImageGenerator.generateDiagramImage(diagram);
                ImageGenerator.encodeImage(image, "PNG", out);
                byte[] imageBytes = out.toByteArray();
                ByteArrayInputStream imageStream = new ByteArrayInputStream(imageBytes);
                pstmt.setBinaryStream(2, (InputStream)imageStream, imageBytes.length);
                String map = ImageGenerator.generateImageMap(diagram.getView(), new SqlReferenceGenerator(connection));
                byte[] mapBytes = map.getBytes(StandardCharsets.UTF_8);
                pstmt.setBinaryStream(3, (InputStream)new ByteArrayInputStream(mapBytes), mapBytes.length);
                pstmt.executeUpdate();
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "Can't save diagram '" + diagram.getName() + "'", ex);
        }
    }

    public void addUpdateCommands(Statement statement, Diagram diagram) throws Exception {
        DiagramInfo kernel = (DiagramInfo)diagram.getKernel();
        String updateQuery = "UPDATE " + this.table + " SET type=" + this.validateValue(kernel.getType()) + ", title=" + this.validateValue(kernel.getTitle()) + ", description=" + this.validateValue(kernel.getDescription()) + ", comment=" + this.validateValue(kernel.getComment()) + " WHERE id=" + this.validateValue(kernel.getName());
        statement.addBatch(updateQuery);
        statement.addBatch("DELETE FROM dbReferences WHERE entityId=" + this.validateValue(diagram.getName()));
        statement.addBatch("DELETE FROM publicationReferences WHERE entityId=" + this.validateValue(diagram.getName()));
        this.diagramInfoTransformer.addInsertDBRefAndPublicationsCommands(statement, kernel);
        statement.executeBatch();
        statement.clearBatch();
        this.updateXmlValue(diagram);
    }

    public void addInsertCommands(Statement statement, Diagram diagram) throws SQLException, Exception {
        DiagramInfo kernel = (DiagramInfo)diagram.getKernel();
        if (kernel == null) {
            kernel = new DiagramInfo(diagram.getName());
        }
        this.diagramInfoTransformer.addInsertCommands(statement, kernel);
        statement.executeBatch();
        statement.clearBatch();
        this.updateXmlValue(diagram);
    }

    public String[] getUsedTables() {
        return new String[]{"dbReferences", "publicationReferences", "publications", this.table};
    }

    public String getCreateTableQuery(String tableName) {
        if (tableName.equals(this.table)) {
            return "CREATE TABLE `diagrams` (" + this.diagramInfoTransformer.getIDFieldFormat() + ",  `type` enum('unknown','semantic-concept','semantic-concept-function','semantic-concept-process','semantic-concept-state','molecule','molecule-gene','molecule-RNA','molecule-protein','molecule-substance','compartment','compartment-cell','reaction','relation','relation-semantic','relation-chemical','info-database','info-diagram','info-relation-type','info-species','info-unit','constant') NOT NULL default 'info-diagram'," + this.diagramInfoTransformer.getTitleFieldFormat() + ",  `completeName` varchar(200) default NULL,  `description` text,  `comment` text,  `xml` mediumblob,  `mimeType` varchar(50) NOT NULL default 'image/png',  `image` mediumblob,  `map` mediumblob,  `attributes` text,  UNIQUE KEY `IDX_UNIQUE_diagrams_ID` (`ID`)) ENGINE=MyISAM CHARSET=utf8";
        }
        return super.getCreateTableQuery(tableName);
    }

    public static class SqlReferenceGenerator
    implements ImageGenerator.ReferenceGenerator {
        public SqlReferenceGenerator(Connection connection) {
        }

        @Override
        public String getReference(Object obj) {
            String type;
            DiagramElement de;
            if (obj instanceof DiagramElement && (de = (DiagramElement)((Object)obj)).getKernel() != null && (type = de.getKernel().getType()) != null && !type.startsWith("note") && !type.startsWith("math")) {
                return "view?type=" + de.getKernel().getType() + "&id=" + de.getKernel().getName();
            }
            return null;
        }

        @Override
        public String getTarget(Object obj) {
            return "entityView";
        }

        @Override
        public String getTitle(Object obj) {
            return null;
        }
    }
}

