/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type.access;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.standard.type.Base;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;

public class DiagramComponentsTable {
    protected static final Logger log = Logger.getLogger(DiagramComponentsTable.class.getName());

    public static void fillTable(Connection connection, DataCollection<Diagram> diagrams) {
        log.info("Filling diagram components table, diagrams db=" + diagrams.getCompletePath() + ", size=" + diagrams.getSize());
        for (Diagram diagram : diagrams) {
            try {
                DiagramComponentsTable.fillTable(connection, diagram);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error for diagram " + diagram.getName() + "(" + diagram.getTitle() + ")", e);
            }
        }
        log.info("Filling diagram components table was successfully completed.");
    }

    public static void fillTable(Connection connection, Diagram diagram) throws SQLException {
        log.info("  diagram: " + diagram.getName() + "(" + diagram.getTitle() + ")");
        try (Statement statement = connection.createStatement();){
            statement.execute("DELETE FROM diagramComponents WHERE diagramID='" + diagram.getName() + "'");
        }
        Map components = ((StreamEx)diagram.recursiveStream().map(DiagramElement::getKernel).nonNull()).toMap(DataElement::getName, Function.identity());
        try (Statement statement = connection.createStatement();){
            for (Map.Entry entry : components.entrySet()) {
                String name = (String)entry.getKey();
                Base kernel = (Base)entry.getValue();
                statement.addBatch("INSERT INTO diagramComponents(diagramID, entityID, type) VALUES('" + diagram.getName() + "', '" + name + "', '" + kernel.getType() + "')");
            }
            statement.executeBatch();
            log.info("    " + components.size() + " components were added.");
        }
    }
}

