/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type.access;

import biouml.standard.type.DatabaseInfo;
import biouml.standard.type.access.ReferrerSqlTransformer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.biosoft.access.SqlDataCollection;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.sql.SqlConnectionHolder;

public class DatabaseInfoSqlTransformer
extends ReferrerSqlTransformer<DatabaseInfo> {
    public boolean init(SqlDataCollection<DatabaseInfo> owner) {
        this.table = "dbInfos";
        this.owner = owner;
        this.checkAttributesColumn((SqlConnectionHolder)owner);
        return true;
    }

    public Class<DatabaseInfo> getTemplateClass() {
        return DatabaseInfo.class;
    }

    public String getSelectQuery() {
        return "SELECT id, type, title, description, comment,  url, queryById, queryByAc FROM " + this.table;
    }

    @Override
    protected DatabaseInfo createElement(ResultSet resultSet, Connection connection) throws SQLException {
        DatabaseInfo dbInfo = new DatabaseInfo((DataCollection)this.owner, resultSet.getString(1));
        dbInfo.setURL(resultSet.getString(6));
        dbInfo.setQueryById(resultSet.getString(7));
        dbInfo.setQueryByAc(resultSet.getString(8));
        return dbInfo;
    }

    @Override
    protected String getSpecificFields(DatabaseInfo de) {
        return ", url, queryById, queryByAc";
    }

    @Override
    protected String[] getSpecificValues(DatabaseInfo de) {
        DatabaseInfo dbInfo = de;
        return new String[]{dbInfo.getURL(), dbInfo.getQueryById(), dbInfo.getQueryByAc()};
    }

    public String[] getUsedTables() {
        return new String[]{"dbReferences", "publicationReferences", "publications", this.table};
    }

    @Override
    public String getCreateTableQuery(String tableName) {
        if (tableName.equals(this.table)) {
            return "CREATE TABLE `dbInfos` (" + this.getIDFieldFormat() + ",  `type` enum('unknown','semantic-concept','semantic-concept-function','semantic-concept-process','semantic-concept-state','molecule','molecule-gene','molecule-RNA','molecule-protein','molecule-substance','compartment','compartment-cell','reaction','relation','relation-semantic','relation-chemical','info-database','info-diagram','info-relation-type','info-species','info-unit','constant') NOT NULL default 'info-database'," + this.getTitleFieldFormat() + ",  `completeName` varchar(200) default NULL,  `description` text,  `comment` text,  `url` varchar(100) default NULL,  `attributes` text,  `queryById` varchar(200) default NULL,  `queryByAc` varchar(200) default NULL) ENGINE=MyISAM";
        }
        return super.getCreateTableQuery(tableName);
    }
}

