/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type.access;

import biouml.standard.type.Concept;
import biouml.standard.type.access.ReferrerSqlTransformer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import ru.biosoft.access.SqlDataCollection;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.sql.SqlConnectionHolder;
import ru.biosoft.access.sql.SqlUtil;

public class ConceptSqlTransformer<T extends Concept>
extends ReferrerSqlTransformer<T> {
    public boolean init(SqlDataCollection<T> owner) {
        super.init(owner);
        this.table = "concepts";
        this.checkAttributesColumn((SqlConnectionHolder)owner);
        return true;
    }

    public Class getTemplateClass() {
        return Concept.class;
    }

    public String getSelectQuery() {
        return "SELECT id, type, title, description, comment, completeName  FROM " + this.table;
    }

    @Override
    protected T createElement(ResultSet resultSet, Connection connection) throws SQLException {
        Concept concept = new Concept((DataCollection)this.owner, resultSet.getString(1));
        concept.setType(resultSet.getString(2));
        concept.setCompleteName(resultSet.getString(6));
        return (T)concept;
    }

    @Override
    public T create(ResultSet resultSet, Connection connection) throws Exception {
        Concept concept = (Concept)super.create(resultSet, connection);
        String synonyms = SqlUtil.stringStream((Connection)connection, (String)("SELECT synonym FROM synonyms s WHERE s.entityID=" + this.validateValue(concept.getName()) + " ORDER BY synonym")).joining((CharSequence)"; ");
        concept.setSynonyms(synonyms);
        return (T)concept;
    }

    @Override
    protected String getSpecificFields(T de) {
        return ", completeName";
    }

    @Override
    protected String[] getSpecificValues(T de) {
        return new String[]{((Concept)de).getCompleteName()};
    }

    @Override
    public void addInsertCommands(Statement statement, T concept) throws Exception {
        super.addInsertCommands(statement, concept);
        if (((Concept)concept).getSynonyms() != null) {
            StringTokenizer tokens = new StringTokenizer(((Concept)concept).getSynonyms(), ";");
            while (tokens.hasMoreTokens()) {
                statement.addBatch("INSERT INTO synonyms (entityId, synonym)VALUES('" + concept.getName() + "', '" + tokens.nextToken().trim().replaceAll("'", "`") + "')");
            }
        }
    }

    @Override
    public void addDeleteCommands(Statement statement, String name) throws Exception {
        super.addDeleteCommands(statement, name);
        statement.addBatch("DELETE FROM synonyms WHERE entityId='" + name + "'");
    }

    public String[] getUsedTables() {
        return new String[]{"dbReferences", "publicationReferences", "publications", "synonyms", this.table};
    }

    @Override
    public String getCreateTableQuery(String tableName) {
        if (tableName.equals(this.table)) {
            return "CREATE TABLE `concepts` (" + this.getIDFieldFormat() + ",  `type` enum('unknown','semantic-concept','semantic-concept-function','semantic-concept-process','semantic-concept-state','molecule','molecule-gene','molecule-RNA','molecule-protein','molecule-substance','compartment','compartment-cell','reaction','relation','relation-semantic','relation-chemical','info-database','info-diagram','info-relation-type','info-species','info-unit','constant') NOT NULL default 'semantic-concept'," + this.getTitleFieldFormat() + ",  `completeName` varchar(200) default NULL,  `description` text,  `comment` text,  `attributes` text,  UNIQUE KEY `IDX_UNIQUE_concepts_ID` (`ID`)) ENGINE=MyISAM";
        }
        if (tableName.equals("synonyms")) {
            return "CREATE TABLE `synonyms` (  `ID` bigint(20) unsigned NOT NULL auto_increment," + this.getIDFieldFormat("entityID") + ",  `synonym` text,  `comment` varchar(250) default NULL,  PRIMARY KEY  (`ID`),  KEY `IDX_SYNONYMS_entityID` (`entityID`)) ENGINE=MyISAM";
        }
        return super.getCreateTableQuery(tableName);
    }
}

