/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type.access;

import biouml.standard.type.Publication;
import biouml.standard.type.access.PublicationSqlTransformer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.access.SqlDataCollection;

public class Biblio2SqlTransformer
extends PublicationSqlTransformer {
    Logger log = Logger.getLogger(Biblio2SqlTransformer.class.getName());
    private final List<Integer> categoryIds = new ArrayList<Integer>();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean init(SqlDataCollection<Publication> owner) {
        if (!super.init(owner)) {
            return false;
        }
        String category = owner.getInfo().getProperty("category");
        if (category == null) {
            return false;
        }
        try {
            Connection conn = owner.getConnection();
            try (PreparedStatement ps = conn.prepareStatement("SELECT ID,parentID from categories WHERE name=?");){
                ps.setString(1, category);
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) {
                        boolean bl = false;
                        return bl;
                    }
                    this.categoryIds.add(rs.getInt(1));
                    int parentId = rs.getInt(2);
                    try (PreparedStatement ps2 = conn.prepareStatement("SELECT parentID from categories WHERE ID=?");){
                        Throwable throwable;
                        ResultSet rs2;
                        while (parentId != 1) {
                            block62: {
                                block60: {
                                    block61: {
                                        this.categoryIds.add(parentId);
                                        ps2.setInt(1, parentId);
                                        rs2 = ps2.executeQuery();
                                        throwable = null;
                                        if (rs2.next()) break block60;
                                        if (rs2 == null) return true;
                                        if (throwable == null) break block61;
                                        try {
                                            rs2.close();
                                            return true;
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                            return true;
                                        }
                                    }
                                    rs2.close();
                                    return true;
                                }
                                parentId = rs2.getInt(1);
                                if (rs2 == null) continue;
                                if (throwable == null) break block62;
                                try {
                                    rs2.close();
                                    continue;
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                    continue;
                                }
                            }
                            rs2.close();
                        }
                        return true;
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (rs2 == null) throw throwable5;
                                if (throwable != null) {
                                    try {
                                        rs2.close();
                                        throw throwable5;
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                        throw throwable5;
                                    }
                                }
                                rs2.close();
                                throw throwable5;
                            }
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
            this.categoryIds.add(-1);
            return false;
        }
    }

    @Override
    public String getSelectQuery() {
        return "SELECT t.ID, ref, PMID, authors, affiliation, title, journalTitle, year, month, volume, issue, pageFrom, pageTo, language, publicationType, abstract, url, importance, keyWords, comment, status FROM " + this.table + " t, classifications cl WHERE CONCAT('biblio2.publications.',t.ID)=cl.recordID and cl.categoryID=" + this.categoryIds.get(0);
    }

    public String getElementQuery(String name) {
        return this.getSelectQuery() + " AND t.ID=" + this.validateValue(name);
    }

    @Override
    public void addInsertCommands(Statement statement, Publication de) throws Exception {
        super.addInsertCommands(statement, de);
        String recordID = this.validateValue("biblio2.publications." + de.getName());
        for (Integer id : this.categoryIds) {
            statement.addBatch("INSERT INTO classifications(recordID,categoryID) VALUES(" + recordID + "," + id + ")");
        }
    }

    public String getCountQuery() {
        return "SELECT COUNT(*) FROM " + this.table + " t, classifications cl WHERE CONCAT('biblio2.publications.',t.ID)=cl.recordID and cl.categoryID=" + this.categoryIds.get(0);
    }

    public String getNameListQuery() {
        return "SELECT t.ID FROM " + this.table + " t, classifications cl WHERE CONCAT('biblio2.publications.',t.ID)=cl.recordID and cl.categoryID=" + this.categoryIds.get(0) + " ORDER BY t.ID";
    }

    public String getElementExistsQuery(String name) {
        return "SELECT t.ID FROM " + this.table + " t, classifications cl WHERE CONCAT('biblio2.publications.',t.ID)=cl.recordID and cl.categoryID=" + this.categoryIds.get(0) + " AND t.ID=" + this.validateValue(name);
    }

    public void addDeleteCommands(Statement statement, String name) throws Exception {
        super.addDeleteCommands(statement, name);
        String recordID = this.validateValue("biblio2.publications." + name);
        statement.addBatch("DELETE FROM classifications WHERE recordID=" + recordID);
    }

    public void addUpdateCommands(Statement statement, Publication de) throws Exception {
        super.addDeleteCommands(statement, de.getName());
        super.addInsertCommands(statement, de);
    }
}

