/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.model.dynamics.EModel;
import biouml.model.dynamics.util.EModelHelper;
import biouml.standard.type.BaseUnit;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetAsMap;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import com.developmentontheedge.beans.editors.StringTagEditorSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.MutableDataElementSupport;

@PropertyName(value="Unit")
@PropertyDescription(value="The unit expressed in base units. Constant, paremeter or varable unit.")
public class Unit
extends MutableDataElementSupport
implements PropertyChangeListener {
    public static final String UNDEFINED = "";
    private String title;
    private String comment;
    private BaseUnit[] baseUnits = new BaseUnit[0];
    protected DynamicPropertySet attributes;
    private String formula = null;
    private static List<String> baseUnitsList = ((StreamEx)StreamEx.of((Object[])new String[]{"ampere", "gram", "katal", "metre", "second", "watt", "becquerel", "gray", "kelvin", "mole", "siemens", "weber", "candela", "henry", "kilogram", "newton", "sievert", "coulomb", "hertz", "litre", "ohm", "steradian", "dimensionless", "item", "lumen", "pascal", "tesla", "farad", "joule", "lux", "radian", "volt"}).sorted()).toList();

    public Unit() {
        this(null, "new_unit");
    }

    public Unit(DataCollection parent, String name) {
        super(parent, name);
        this.title = name;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getSource() instanceof BaseUnit) {
            this.resetFormula();
        }
    }

    public void setName(String name) {
        if (!name.equals(this.name) && this.getParent() != null && this.getParent() instanceof EModel) {
            EModelHelper helper = new EModelHelper((EModel)this.getParent());
            helper.renameUnit(this.getName(), name);
        }
    }

    @PropertyName(value="Title")
    @PropertyDescription(value="The object title (generally it is object brief name).")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        this.firePropertyChange("title", oldValue, title);
    }

    @PropertyName(value="Comment")
    @PropertyDescription(value="Arbitrary text comments.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.comment;
        this.comment = comment;
        this.firePropertyChange("comment", oldValue, comment);
    }

    @PropertyName(value="Base units")
    @PropertyDescription(value="Base units (type | multiplier | scale | exponent).")
    public BaseUnit[] getBaseUnits() {
        return this.baseUnits;
    }

    public void setBaseUnits(BaseUnit[] baseUnits) {
        BaseUnit[] oldBaseUnits;
        for (BaseUnit baseUnit : oldBaseUnits = this.getBaseUnits()) {
            baseUnit.removePropertyChangeListener(this);
            baseUnit.setParent(null);
        }
        if (baseUnits != null) {
            for (BaseUnit baseUnit : baseUnits) {
                if (baseUnit.getParent() != null) continue;
                baseUnit.addPropertyChangeListener(this);
                baseUnit.setParent((Option)this);
            }
        }
        this.baseUnits = baseUnits;
        this.resetFormula();
        this.firePropertyChange("base_units", oldBaseUnits, baseUnits);
    }

    public DynamicPropertySet getAttributes() {
        if (this.attributes == null) {
            this.attributes = new DynamicPropertySetAsMap();
            this.attributes.addPropertyChangeListener(e -> this.firePropertyChange(new PropertyChangeEvent(this, "attributes/" + e.getPropertyName(), e.getOldValue(), e.getNewValue())));
        }
        return this.attributes;
    }

    public Unit clone(DataCollection parent, String name) {
        Unit newUnit = new Unit(parent, name);
        newUnit.setTitle(this.title);
        newUnit.setComment(this.comment);
        if (this.baseUnits != null) {
            BaseUnit[] newBaseUnits = (BaseUnit[])StreamEx.of((Object[])this.baseUnits).map(baseUnit -> baseUnit.clone((Option)newUnit)).toArray(BaseUnit[]::new);
            newUnit.setBaseUnits(newBaseUnits);
        }
        return newUnit;
    }

    public String calcBaseUnitName(Integer index, Object unit) {
        return this.generateFormula((BaseUnit)((Object)unit));
    }

    public String toString() {
        return this.getName();
    }

    public static List<String> getBaseUnitsList() {
        return baseUnitsList;
    }

    public static List<String> getBaseSubstanceUnits() {
        ArrayList<String> substanceUnits = new ArrayList<String>();
        substanceUnits.add("mole");
        substanceUnits.add("item");
        substanceUnits.add("gram");
        substanceUnits.add("dimensionless");
        return substanceUnits;
    }

    public static List<String> getBaseVolumeUnits() {
        ArrayList<String> substanceUnits = new ArrayList<String>();
        substanceUnits.add("litre");
        substanceUnits.add("cubic metre");
        substanceUnits.add("dimensionless");
        return substanceUnits;
    }

    public static List<String> getBaseTimeUnits() {
        ArrayList<String> substanceUnits = new ArrayList<String>();
        substanceUnits.add("second");
        substanceUnits.add("dimensionless");
        return substanceUnits;
    }

    @PropertyName(value="Formula")
    public String getFormula() {
        if (this.formula == null) {
            this.formula = this.generateFormula();
        }
        return this.formula;
    }

    public void setFormula(String formula) {
    }

    private void resetFormula() {
        this.formula = null;
    }

    public String generateFormula(BaseUnit unit) {
        String result = unit.getType();
        double scale = unit.getScale();
        double multiplier = unit.getMultiplier();
        int exponent = Math.abs(unit.getExponent());
        boolean brackets = false;
        if (scale != 0.0) {
            result = scale == 1.0 ? result + "*10" : result + "*10^(" + scale + ")";
            brackets = true;
        }
        if (multiplier != 1.0) {
            result = multiplier + "*" + result;
            brackets = true;
        }
        if (exponent != 1) {
            result = brackets ? "(" + result + ")^" + exponent : result + "^" + exponent;
        }
        return result;
    }

    private boolean isNumerator(BaseUnit unit) {
        return unit.getExponent() >= 0;
    }

    private boolean isSimple(BaseUnit unit) {
        return unit.scale == 0 && unit.multiplier == 1.0;
    }

    public String generateFormula() {
        StringBuilder result = new StringBuilder();
        BaseUnit[] units = this.getBaseUnits();
        int unitLength = units.length;
        if (unitLength == 0) {
            return result.toString();
        }
        String part = this.generateFormula(units[0]);
        if (!this.isSimple(units[0])) {
            part = "[" + part + "]";
        }
        if (unitLength == 1) {
            if (this.isNumerator(units[0])) {
                return this.generateFormula(units[0]);
            }
            return "1 / " + part;
        }
        if (this.isNumerator(units[0])) {
            result.append(part);
        } else {
            result.append("1 / " + part);
        }
        for (int i = 1; i < unitLength; ++i) {
            part = this.generateFormula(units[i]);
            if (!this.isSimple(units[i])) {
                part = "[" + part + "]";
            }
            if (this.isNumerator(units[i])) {
                result.append(" * " + part);
                continue;
            }
            result.append(" / " + part);
        }
        return result.toString();
    }

    public static boolean equals(Unit u1, Unit u2) {
        if (u1.getBaseUnits().length != u2.getBaseUnits().length) {
            return false;
        }
        HashSet<BaseUnit> alreadyFound = new HashSet<BaseUnit>();
        for (int i = 0; i < u1.getBaseUnits().length; ++i) {
            boolean found = false;
            BaseUnit b1 = u1.getBaseUnits()[i];
            for (int j = 0; j < u2.getBaseUnits().length; ++j) {
                BaseUnit b2 = u2.getBaseUnits()[i];
                if (alreadyFound.contains((Object)b2) || !Unit.equals(b1, b2)) continue;
                found = true;
                alreadyFound.add(b2);
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(BaseUnit u1, BaseUnit u2) {
        if (!u1.getType().equals(u2.getType())) {
            return false;
        }
        if (u1.getExponent() != u2.getExponent()) {
            return false;
        }
        if (u1.getMultiplier() != u2.getMultiplier()) {
            return false;
        }
        return u1.getScale() == u2.getScale();
    }

    public String getUnitFormula() {
        StringBuilder result = new StringBuilder();
        BaseUnit[] units = this.getBaseUnits();
        int unitLength = units.length;
        if (unitLength == 0) {
            return result.toString();
        }
        String part = this.generateBaseUnitFormula(units[0], true, true);
        result.append(part);
        for (int i = 1; i < unitLength; ++i) {
            part = units[i - 1].getExponent() == 1 || units[i - 1].getMultiplier() == 1.0 && units[i - 1].getScale() == 0 ? this.generateBaseUnitFormula(units[i], false, false) : this.generateBaseUnitFormula(units[i], true, false);
            if (this.isNumerator(units[i])) {
                result.append(" * " + part);
                continue;
            }
            result.append(" / " + part);
        }
        return result.toString();
    }

    public String generateBaseUnitFormula(BaseUnit unit, boolean multNeeded, boolean isFirst) {
        StringBuilder result = new StringBuilder();
        double scale = unit.getScale();
        double multiplier = unit.getMultiplier();
        int exponent = isFirst ? unit.getExponent() : Math.abs(unit.getExponent());
        boolean brackets = false;
        if (multiplier != 1.0 || multNeeded) {
            result.append(multiplier);
            if (multiplier != 1.0) {
                brackets = true;
            }
        }
        if (scale != 0.0) {
            if (result.length() != 0) {
                result.append("*");
            }
            if (scale == 1.0) {
                result.append("10");
            } else {
                result.append("10^(" + scale + ")");
            }
            brackets = true;
        }
        if (scale != 0.0 || multiplier != 1.0 || multNeeded) {
            result.append(" ");
        }
        result.append(unit.getType());
        if (exponent != 1) {
            if (brackets) {
                result.insert(0, "(").append(")^" + exponent);
            } else {
                result.append("^" + exponent);
            }
        }
        return result.toString();
    }

    public static class BaseUnitTypeEditor
    extends StringTagEditorSupport {
        public BaseUnitTypeEditor() {
            super(Unit.getBaseUnitsList().toArray(new String[0]));
        }
    }
}

