/*
 * Decompiled with CFR 0.152.
 */
package biouml.standard.type;

import biouml.standard.type.DatabaseReference;
import biouml.standard.type.Referrer;
import java.beans.PropertyChangeListener;
import java.util.DoubleSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataCollectionInfo;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementDescriptor;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.DataElementPutException;
import ru.biosoft.access.core.VectorDataCollection;
import ru.biosoft.exception.LoggedException;
import ru.biosoft.table.ColumnModel;
import ru.biosoft.table.RowDataElement;
import ru.biosoft.table.Sample;
import ru.biosoft.table.StandardTableDataCollection;
import ru.biosoft.table.TableColumn;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.table.TableDataCollectionUtils;

public class TableExperiment
extends Referrer
implements DataCollection<RowDataElement> {
    public static final String SERIES_ATTR = "series";
    public static final String ID_ATTR = "ID";
    protected static final Logger log = Logger.getLogger(TableExperiment.class.getName());
    private TableDataCollection tableData = new StandardTableDataCollection(null, new Properties());
    private DataCollection<Sample> samples;
    private String platform;
    private String species;
    private DataCollection<DataElement> groups;
    private double minValue = 0.0;
    private double maxValue = 0.0;

    public TableExperiment(DataCollection<?> origin, String name) {
        super(origin, name);
    }

    public int getColumnCount() {
        return this.tableData.getColumnModel().getColumnCount();
    }

    public void removeColumn(int columnPos) {
        this.tableData.getColumnModel().removeColumn(columnPos);
    }

    public int getRowCount() {
        return this.tableData.getSize();
    }

    public Object[] getRow(int index) {
        return TableDataCollectionUtils.getRowValues((TableDataCollection)this.tableData, (String)this.tableData.getName(index));
    }

    public double[][] getMatrix(String[] columnNames, double threshold, double mdCode) throws Exception {
        int[] indices = StreamEx.of((Object[])columnNames).mapToInt(arg_0 -> ((ColumnModel)this.getTableData().getColumnModel()).getColumnIndex(arg_0)).toArray();
        return this.getMatrix(indices, threshold, mdCode);
    }

    public double[][] getMatrix(String[] columnNames) throws Exception {
        int[] indices = StreamEx.of((Object[])columnNames).mapToInt(arg_0 -> ((ColumnModel)this.getTableData().getColumnModel()).getColumnIndex(arg_0)).toArray();
        return this.getMatrix(indices);
    }

    public double[][] getMatrix(int[] columnIndices) throws Exception {
        return TableDataCollectionUtils.getMatrix((TableDataCollection)this.tableData, (int[])columnIndices);
    }

    public double[][] getMatrix(int[] columnIndices, double lowerBoundary, double upperBoundary) throws Exception {
        return TableDataCollectionUtils.getMatrix((TableDataCollection)this.tableData, (int[])columnIndices, (double)lowerBoundary, (double)upperBoundary);
    }

    public double[][] getMatrix() throws Exception {
        return TableDataCollectionUtils.getMatrix((TableDataCollection)this.tableData);
    }

    public Object[] getRow(String id) {
        return TableDataCollectionUtils.getRowValues((TableDataCollection)this.tableData, (String)id);
    }

    public void addRow(String key, Object[] rowValues) {
        TableDataCollectionUtils.addRow((TableDataCollection)this.tableData, (String)key, (Object[])rowValues);
    }

    public TableDataCollection getTableData() {
        return this.tableData;
    }

    public void setTableData(TableDataCollection tableData) {
        this.tableData = tableData;
    }

    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String species) {
        String oldValue = this.species;
        this.species = species;
        this.firePropertyChange("species", oldValue, species);
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        String oldValue = this.platform;
        this.platform = platform;
        this.firePropertyChange("platform", oldValue, platform);
    }

    public DataCollection<Sample> getSamples() {
        if (this.samples == null) {
            this.samples = new VectorDataCollection("Samples");
            for (TableColumn col : this.tableData.getColumnModel()) {
                if (col.getNature() != TableColumn.Nature.SAMPLE) continue;
                try {
                    this.samples.put((DataElement)col.getSample());
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        return this.samples;
    }

    public DataCollection<DataElement> getGroups() {
        if (this.groups == null) {
            this.groups = new VectorDataCollection("Groups");
        }
        return this.groups;
    }

    public Object getValue(String gene, String sample) {
        return TableDataCollectionUtils.getRowValues((TableDataCollection)this.tableData, (String)gene, (String[])new String[]{sample})[0];
    }

    public String getGeneId(int i) {
        return this.tableData.getName(i);
    }

    public double getMinValue() {
        if (this.minValue == 0.0 && this.maxValue == 0.0) {
            this.findMinMax();
        }
        return this.minValue;
    }

    public double getMaxValue() {
        if (this.minValue == 0.0 && this.maxValue == 0.0) {
            this.findMinMax();
        }
        return this.maxValue;
    }

    private void findMinMax() {
        DoubleSummaryStatistics statistics = TableDataCollectionUtils.findMinMax((TableDataCollection)this.tableData);
        this.minValue = statistics.getMin();
        this.maxValue = statistics.getMax();
    }

    public TableExperiment clone() {
        TableExperiment result = new TableExperiment((DataCollection<?>)this.getOrigin(), this.getName());
        result.setDescription(this.getDescription());
        result.setSpecies(this.getSpecies());
        result.setPlatform(this.getPlatform());
        result.setTitle(this.getTitle());
        result.setComment(this.getComment());
        result.setDate(this.getDate());
        TableDataCollection clonedTableData = this.tableData.clone(null, this.tableData.getName());
        result.setTableData(clonedTableData);
        if (null != this.getLiteratureReferences()) {
            result.setLiteratureReferences((String[])this.getLiteratureReferences().clone());
        }
        if (null != this.getDatabaseReferences()) {
            result.setDatabaseReferences((DatabaseReference[])this.getDatabaseReferences().clone());
        }
        DataCollection<DataElement> groups = result.getGroups();
        for (DataElement group : this.getGroups()) {
            groups.put(group);
        }
        DataCollection<Sample> samples = result.getSamples();
        for (Sample sample : this.getSamples()) {
            samples.put((DataElement)sample);
        }
        return result;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
        this.tableData.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
        this.tableData.removePropertyChangeListener(l);
    }

    public void addDataCollectionListener(DataCollectionListener l) {
        this.tableData.addDataCollectionListener(l);
    }

    public void close() throws Exception {
        this.tableData.close();
    }

    public boolean contains(String name) {
        return this.tableData.contains(name);
    }

    public boolean contains(DataElement element) {
        return this.tableData.contains(element);
    }

    public RowDataElement get(String name) throws Exception {
        return (RowDataElement)this.tableData.get(name);
    }

    public DataElementDescriptor getDescriptor(String name) {
        return this.tableData.getDescriptor(name);
    }

    @Nonnull
    public DataElementPath getCompletePath() {
        return this.tableData.getCompletePath();
    }

    @Nonnull
    public Class<? extends DataElement> getDataElementType() {
        return RowDataElement.class;
    }

    public DataElement getFromCache(String dataElementName) {
        return this.tableData.getFromCache(dataElementName);
    }

    public DataCollectionInfo getInfo() {
        return this.tableData.getInfo();
    }

    @Nonnull
    public List<String> getNameList() {
        return this.tableData.getNameList();
    }

    public int getSize() {
        return this.tableData.getSize();
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public boolean isMutable() {
        return this.tableData.isMutable();
    }

    @Nonnull
    public Iterator<RowDataElement> iterator() {
        return this.tableData.iterator();
    }

    public void propagateElementChanged(DataCollection<?> source, DataCollectionEvent primaryEvent) {
        this.tableData.propagateElementChanged(source, primaryEvent);
    }

    public void propagateElementWillChange(DataCollection<?> source, DataCollectionEvent primaryEvent) {
        this.tableData.propagateElementWillChange(source, primaryEvent);
    }

    public RowDataElement put(RowDataElement element) throws DataElementPutException {
        return (RowDataElement)this.tableData.put((DataElement)element);
    }

    public void release(String dataElementName) {
        this.tableData.release(dataElementName);
    }

    public void remove(@Nonnull String name) throws Exception {
        this.tableData.remove(name);
    }

    public void removeDataCollectionListener(DataCollectionListener l) {
        this.tableData.removeDataCollectionListener(l);
    }

    public boolean isAcceptable(Class<? extends DataElement> clazz) {
        return RowDataElement.class.isAssignableFrom(clazz);
    }

    public boolean isValid() {
        return true;
    }

    public void reinitialize() throws LoggedException {
    }
}

